/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.pipeline;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.action.GuiContextAction;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.hopgui.HopGuiExtensionPoint;
import org.apache.hop.ui.hopgui.delegates.HopGuiFileOpenedExtension;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.apache.hop.ui.hopgui.file.pipeline.context.HopGuiPipelineContext;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.pipeline.ActionPipeline;

@GuiPlugin
public class ActionPipelineGuiPlugin {
    @GuiContextAction(id="pipeline-graph-transform-10300-copy-pipeline-action", parentId="HopGuiPipelineContext", type=GuiActionType.Modify, name="i18n::ActionPipeline.Copy.Name", tooltip="i18n::ActionPipeline.Copy.Description", image="ui/images/copy.svg", category="Basic", categoryOrder="1")
    public void copyAsActionToClipboard(HopGuiPipelineContext context) {
        PipelineMeta pipelineMeta = context.getPipelineMeta();
        HopGuiPipelineGraph pipelineGraph = context.getPipelineGraph();
        IVariables variables = pipelineGraph.getVariables();
        ActionPipeline actionPipeline = new ActionPipeline(pipelineMeta.getName());
        HopGuiFileOpenedExtension ext = new HopGuiFileOpenedExtension(null, variables, pipelineMeta.getFilename());
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.UI, (IVariables)variables, (String)HopGuiExtensionPoint.HopGuiFileOpenedDialog.id, (Object)ext);
        }
        catch (Exception xe) {
            LogChannel.UI.logError("Error handling extension point 'HopGuiFileOpenDialog'", (Throwable)xe);
        }
        actionPipeline.setFileName(ext.filename);
        try {
            MultiMetadataProvider metadataProvider = pipelineGraph.getHopGui().getMetadataProvider();
            IHopMetadataSerializer serializer = metadataProvider.getSerializer(PipelineRunConfiguration.class);
            List configNames = serializer.listObjectNames();
            if (!configNames.isEmpty()) {
                if (configNames.size() == 1) {
                    actionPipeline.setRunConfiguration((String)configNames.get(0));
                } else {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(pipelineGraph.getShell(), configNames.toArray(new String[0]), "Select run configuration", "Select the pipeline run configuration to use in the action:");
                    String configName = dialog.open();
                    if (configName != null) {
                        actionPipeline.setRunConfiguration(configName);
                    }
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(pipelineGraph.getShell(), "Error", "Error selecting pipeline run configurations", e);
        }
        ActionMeta actionMeta = new ActionMeta((IAction)actionPipeline);
        StringBuilder xml = new StringBuilder(5000).append(XmlHandler.getXmlHeader());
        xml.append(XmlHandler.openTag((String)"workflow-actions")).append(Const.CR);
        xml.append(XmlHandler.openTag((String)"actions")).append(Const.CR);
        xml.append(actionMeta.getXml());
        xml.append(XmlHandler.closeTag((String)"actions")).append(Const.CR);
        xml.append(XmlHandler.closeTag((String)"workflow-actions")).append(Const.CR);
        pipelineGraph.pipelineClipboardDelegate.toClipboard(xml.toString());
    }
}

