/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.monetdbbulkloader;

import java.util.regex.Pattern;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.monetdbbulkloader.MonetDbVersionException;

public class MonetDbVersion
implements Comparable<MonetDbVersion> {
    private static final Class<?> PKG = MonetDbVersion.class;
    private Integer minorVersion;
    private Integer majorVersion;
    private Integer patchVersion;
    private static final String SEPARATOR = "\\.";
    private static final Pattern VERSION_PATTERN = Pattern.compile("^[0-9]+(\\.[0-9]+)*$");
    private static final int JAN_2014_SP2_RELEASE_DB_MAJOR_VERSION = 11;
    private static final int JAN_2014_SP2_RELEASE_DB_MINOR_VERSION = 17;
    private static final int JAN_2014_SP2_RELEASE_DB_PATCH_VERSION = 17;
    public static final MonetDbVersion JAN_2014_SP2_DB_VERSION = new MonetDbVersion(11, 17, 17);

    public MonetDbVersion() {
    }

    public MonetDbVersion(int majorVersion, int minorVersion, int patchVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.patchVersion = patchVersion;
    }

    public MonetDbVersion(String productVersion) throws MonetDbVersionException {
        this.parseVersion(productVersion);
    }

    public Integer getMinorVersion() {
        return this.minorVersion;
    }

    public Integer getMajorVersion() {
        return this.majorVersion;
    }

    public Integer getPatchVersion() {
        return this.patchVersion;
    }

    @Override
    public int compareTo(MonetDbVersion mDbVersion) {
        int result = this.majorVersion.compareTo(mDbVersion.majorVersion);
        if (result != 0) {
            return result;
        }
        result = this.minorVersion.compareTo(mDbVersion.minorVersion);
        if (result != 0) {
            return result;
        }
        result = this.patchVersion.compareTo(mDbVersion.patchVersion);
        if (result != 0) {
            return result;
        }
        return result;
    }

    private void parseVersion(String productVersion) throws MonetDbVersionException {
        if (productVersion == null) {
            throw new MonetDbVersionException(BaseMessages.getString(PKG, (String)"MonetDBVersion.Exception.VersionIsNull", (String[])new String[0]));
        }
        if (!VERSION_PATTERN.matcher(productVersion).matches()) {
            throw new MonetDbVersionException(BaseMessages.getString(PKG, (String)"MonetDBVersion.Exception.VersionFormatIsInvalid", (String[])new String[]{productVersion}));
        }
        int startIndex = 0;
        String[] versionParts = productVersion.split(SEPARATOR);
        this.majorVersion = Integer.valueOf(versionParts[startIndex]);
        if (versionParts.length > 1) {
            this.minorVersion = Integer.valueOf(versionParts[startIndex + 1]);
        }
        if (versionParts.length > 2) {
            this.patchVersion = Integer.valueOf(versionParts[startIndex + 2]);
        }
    }

    public String toString() {
        return "MonetDbVersion: " + this.majorVersion + "." + this.minorVersion + "." + this.patchVersion;
    }
}

