/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataValidation;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STDataValidationErrorStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STDataValidationOperator;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STDataValidationType;

public class XSSFDataValidation
implements DataValidation {
    private static final int MAX_TEXT_LENGTH = 255;
    private CTDataValidation ctDataValidation;
    private XSSFDataValidationConstraint validationConstraint;
    private CellRangeAddressList regions;
    static Map<Integer, STDataValidationOperator.Enum> operatorTypeMappings = new HashMap<Integer, STDataValidationOperator.Enum>();
    static Map<STDataValidationOperator.Enum, Integer> operatorTypeReverseMappings = new HashMap<STDataValidationOperator.Enum, Integer>();
    static Map<Integer, STDataValidationType.Enum> validationTypeMappings = new HashMap<Integer, STDataValidationType.Enum>();
    static Map<STDataValidationType.Enum, Integer> validationTypeReverseMappings = new HashMap<STDataValidationType.Enum, Integer>();
    static Map<Integer, STDataValidationErrorStyle.Enum> errorStyleMappings = new HashMap<Integer, STDataValidationErrorStyle.Enum>();
    static Map<STDataValidationErrorStyle.Enum, Integer> reverseErrorStyleMappings;

    XSSFDataValidation(CellRangeAddressList regions, CTDataValidation ctDataValidation) {
        this(XSSFDataValidation.getConstraint(ctDataValidation), regions, ctDataValidation);
    }

    public XSSFDataValidation(XSSFDataValidationConstraint constraint, CellRangeAddressList regions, CTDataValidation ctDataValidation) {
        this.validationConstraint = constraint;
        this.ctDataValidation = ctDataValidation;
        this.regions = regions;
    }

    CTDataValidation getCtDataValidation() {
        return this.ctDataValidation;
    }

    public void createErrorBox(String title, String text) {
        if (title != null && title.length() > 255) {
            throw new IllegalStateException("Error-title cannot be longer than 32 characters, but had: " + title);
        }
        if (text != null && text.length() > 255) {
            throw new IllegalStateException("Error-text cannot be longer than 255 characters, but had: " + text);
        }
        this.ctDataValidation.setErrorTitle(this.encodeUtf(title));
        this.ctDataValidation.setError(this.encodeUtf(text));
    }

    public void createPromptBox(String title, String text) {
        if (title != null && title.length() > 255) {
            throw new IllegalStateException("Error-title cannot be longer than 32 characters, but had: " + title);
        }
        if (text != null && text.length() > 255) {
            throw new IllegalStateException("Error-text cannot be longer than 255 characters, but had: " + text);
        }
        this.ctDataValidation.setPromptTitle(this.encodeUtf(title));
        this.ctDataValidation.setPrompt(this.encodeUtf(text));
    }

    private String encodeUtf(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (c < ' ') {
                builder.append("_x").append(c < '\u0010' ? "000" : "00").append(Integer.toHexString(c)).append("_");
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public boolean getEmptyCellAllowed() {
        return this.ctDataValidation.getAllowBlank();
    }

    public String getErrorBoxText() {
        return this.ctDataValidation.getError();
    }

    public String getErrorBoxTitle() {
        return this.ctDataValidation.getErrorTitle();
    }

    public int getErrorStyle() {
        return reverseErrorStyleMappings.get(this.ctDataValidation.getErrorStyle());
    }

    public String getPromptBoxText() {
        return this.ctDataValidation.getPrompt();
    }

    public String getPromptBoxTitle() {
        return this.ctDataValidation.getPromptTitle();
    }

    public boolean getShowErrorBox() {
        return this.ctDataValidation.getShowErrorMessage();
    }

    public boolean getShowPromptBox() {
        return this.ctDataValidation.getShowInputMessage();
    }

    public boolean getSuppressDropDownArrow() {
        return !this.ctDataValidation.getShowDropDown();
    }

    public DataValidationConstraint getValidationConstraint() {
        return this.validationConstraint;
    }

    public void setEmptyCellAllowed(boolean allowed) {
        this.ctDataValidation.setAllowBlank(allowed);
    }

    public void setErrorStyle(int errorStyle) {
        this.ctDataValidation.setErrorStyle(errorStyleMappings.get(errorStyle));
    }

    public void setShowErrorBox(boolean show) {
        this.ctDataValidation.setShowErrorMessage(show);
    }

    public void setShowPromptBox(boolean show) {
        this.ctDataValidation.setShowInputMessage(show);
    }

    public void setSuppressDropDownArrow(boolean suppress) {
        if (this.validationConstraint.getValidationType() == 3) {
            this.ctDataValidation.setShowDropDown(!suppress);
        }
    }

    public CellRangeAddressList getRegions() {
        return this.regions;
    }

    public String prettyPrint() {
        StringBuilder builder = new StringBuilder();
        for (CellRangeAddress address : this.regions.getCellRangeAddresses()) {
            builder.append(address.formatAsString());
        }
        builder.append(" => ");
        builder.append(this.validationConstraint.prettyPrint());
        return builder.toString();
    }

    private static XSSFDataValidationConstraint getConstraint(CTDataValidation ctDataValidation) {
        String formula1 = ctDataValidation.getFormula1();
        String formula2 = ctDataValidation.getFormula2();
        STDataValidationOperator.Enum operator = ctDataValidation.getOperator();
        STDataValidationType.Enum type = ctDataValidation.getType();
        Integer validationType = validationTypeReverseMappings.get(type);
        Integer operatorType = operatorTypeReverseMappings.get(operator);
        return new XSSFDataValidationConstraint(validationType, operatorType, formula1, formula2);
    }

    static {
        errorStyleMappings.put(2, STDataValidationErrorStyle.INFORMATION);
        errorStyleMappings.put(0, STDataValidationErrorStyle.STOP);
        errorStyleMappings.put(1, STDataValidationErrorStyle.WARNING);
        reverseErrorStyleMappings = MapUtils.invertMap(errorStyleMappings);
        operatorTypeMappings.put(0, STDataValidationOperator.BETWEEN);
        operatorTypeMappings.put(1, STDataValidationOperator.NOT_BETWEEN);
        operatorTypeMappings.put(2, STDataValidationOperator.EQUAL);
        operatorTypeMappings.put(3, STDataValidationOperator.NOT_EQUAL);
        operatorTypeMappings.put(4, STDataValidationOperator.GREATER_THAN);
        operatorTypeMappings.put(6, STDataValidationOperator.GREATER_THAN_OR_EQUAL);
        operatorTypeMappings.put(5, STDataValidationOperator.LESS_THAN);
        operatorTypeMappings.put(7, STDataValidationOperator.LESS_THAN_OR_EQUAL);
        for (Map.Entry<Integer, STDataValidationOperator.Enum> entry : operatorTypeMappings.entrySet()) {
            operatorTypeReverseMappings.put(entry.getValue(), entry.getKey());
        }
        validationTypeMappings.put(7, STDataValidationType.CUSTOM);
        validationTypeMappings.put(4, STDataValidationType.DATE);
        validationTypeMappings.put(2, STDataValidationType.DECIMAL);
        validationTypeMappings.put(3, STDataValidationType.LIST);
        validationTypeMappings.put(0, STDataValidationType.NONE);
        validationTypeMappings.put(6, STDataValidationType.TEXT_LENGTH);
        validationTypeMappings.put(5, STDataValidationType.TIME);
        validationTypeMappings.put(1, STDataValidationType.WHOLE);
        for (Map.Entry<Integer, STDataValidationOperator.Enum> entry : validationTypeMappings.entrySet()) {
            validationTypeReverseMappings.put((STDataValidationType.Enum)entry.getValue(), entry.getKey());
        }
    }
}

