/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mongodboutput;

import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.MongoExecutionTimeoutException;
import com.mongodb.WriteResult;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mongo.MongoDbException;
import org.apache.hop.mongo.metadata.MongoDbConnection;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mongodboutput.MongoDbOutputData;
import org.apache.hop.pipeline.transforms.mongodboutput.MongoDbOutputMeta;

public class MongoDbOutput
extends BaseTransform<MongoDbOutputMeta, MongoDbOutputData> {
    private static final Class<?> PKG = MongoDbOutputMeta.class;
    protected MongoDbOutputData.MongoTopLevel mongoTopLevelStructure = MongoDbOutputData.MongoTopLevel.INCONSISTENT;
    protected int batchInsertSize = 100;
    protected List<DBObject> batch;
    protected List<Object[]> batchRows;
    protected int writeRetries = 5;
    protected int writeRetryDelay = 10;

    public MongoDbOutput(TransformMeta transformMeta, MongoDbOutputMeta meta, MongoDbOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            List<MongoDbOutputMeta.MongoIndex> indexes;
            if (this.batch != null && this.batch.size() > 0) {
                try {
                    this.doBatch();
                }
                catch (MongoDbException e) {
                    throw new HopException((Throwable)e);
                }
            }
            if ((indexes = ((MongoDbOutputMeta)this.meta).getMongoIndexes()) != null && indexes.size() > 0) {
                this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.ApplyingIndexOpps", (String[])new String[0]));
                try {
                    ((MongoDbOutputData)this.data).applyIndexes(indexes, this.log, ((MongoDbOutputMeta)this.meta).getTruncate());
                }
                catch (MongoDbException e) {
                    throw new HopException((Throwable)e);
                }
            }
            this.disconnect();
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.batchInsertSize = 100;
            String batchInsert = this.resolve(((MongoDbOutputMeta)this.meta).getBatchInsertSize());
            if (!StringUtils.isEmpty((String)batchInsert)) {
                this.batchInsertSize = Integer.parseInt(batchInsert);
            }
            this.batch = new ArrayList<DBObject>(this.batchInsertSize);
            this.batchRows = new ArrayList<Object[]>();
            ((MongoDbOutputData)this.data).setOutputRowMeta(this.getInputRowMeta());
            ((MongoDbOutputData)this.data).hasTopLevelJsonDocInsert = MongoDbOutputData.scanForInsertTopLevelJSONDoc(((MongoDbOutputMeta)this.meta).getMongoFields());
            IRowMeta rmi = this.getInputRowMeta();
            List<MongoDbOutputMeta.MongoField> mongoFields = ((MongoDbOutputMeta)this.meta).getMongoFields();
            this.checkInputFieldsMatch(rmi, mongoFields);
            ((MongoDbOutputData)this.data).setMongoFields(((MongoDbOutputMeta)this.meta).getMongoFields());
            ((MongoDbOutputData)this.data).init((IVariables)this);
            if (((MongoDbOutputMeta)this.meta).getTruncate()) {
                try {
                    this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.TruncatingCollection", (String[])new String[0]));
                    ((MongoDbOutputData)this.data).getCollection().remove();
                }
                catch (Exception m) {
                    this.disconnect();
                    throw new HopException(m.getMessage(), (Throwable)m);
                }
            }
        }
        if (!this.isStopped()) {
            if (((MongoDbOutputMeta)this.meta).getUpdate()) {
                DBObject updateQuery = MongoDbOutputData.getQueryObject(((MongoDbOutputData)this.data).getMongoFields(), this.getInputRowMeta(), row, (IVariables)this, this.mongoTopLevelStructure);
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Debug.QueryForUpsert", (Object[])new Object[]{updateQuery}));
                }
                if (updateQuery != null) {
                    DBObject insertUpdate = null;
                    if (!((MongoDbOutputMeta)this.meta).getModifierUpdate()) {
                        insertUpdate = MongoDbOutputData.hopRowToMongo(((MongoDbOutputData)this.data).getMongoFields(), this.getInputRowMeta(), row, this.mongoTopLevelStructure, ((MongoDbOutputData)this.data).hasTopLevelJsonDocInsert);
                        if (this.log.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Debug.InsertUpsertObject", (Object[])new Object[]{insertUpdate}));
                        }
                    } else {
                        try {
                            insertUpdate = ((MongoDbOutputData)this.data).getModifierUpdateObject(((MongoDbOutputData)this.data).getMongoFields(), this.getInputRowMeta(), row, (IVariables)this, this.mongoTopLevelStructure);
                        }
                        catch (MongoDbException e) {
                            throw new HopException((Throwable)e);
                        }
                        if (this.log.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Debug.ModifierUpdateObject", (Object[])new Object[]{insertUpdate}));
                        }
                    }
                    if (insertUpdate != null) {
                        this.commitUpdate(updateQuery, insertUpdate, row);
                    }
                }
            } else {
                DBObject mongoInsert = MongoDbOutputData.hopRowToMongo(((MongoDbOutputData)this.data).getMongoFields(), this.getInputRowMeta(), row, this.mongoTopLevelStructure, ((MongoDbOutputData)this.data).hasTopLevelJsonDocInsert);
                if (mongoInsert != null) {
                    this.batch.add(mongoInsert);
                    this.batchRows.add(row);
                }
                if (this.batch.size() == this.batchInsertSize) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.CommitingABatch", (String[])new String[0]));
                    try {
                        this.doBatch();
                    }
                    catch (MongoDbException e) {
                        throw new HopException((Throwable)e);
                    }
                }
            }
            this.putRow(((MongoDbOutputData)this.data).getOutputRowMeta(), row);
            this.incrementLinesOutput();
        }
        return true;
    }

    protected void commitUpdate(DBObject updateQuery, DBObject insertUpdate, Object[] row) throws HopException {
        int retrys = 0;
        MongoException lastEx = null;
        while (retrys <= this.writeRetries && !this.isStopped()) {
            WriteResult result;
            block10: {
                result = null;
                try {
                    try {
                        result = ((MongoDbOutputData)this.data).getCollection().update(updateQuery, insertUpdate, ((MongoDbOutputMeta)this.meta).getUpsert(), ((MongoDbOutputMeta)this.meta).getMulti());
                    }
                    catch (MongoDbException e) {
                        throw new MongoException(e.getMessage(), (Throwable)e);
                    }
                }
                catch (MongoException me) {
                    lastEx = me;
                    if (++retrys > this.writeRetries) break block10;
                    this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.ErrorWritingToMongo", (String[])new String[]{me.toString()}));
                    this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Message.Retry", (Object[])new Object[]{this.writeRetryDelay}));
                    try {
                        Thread.sleep(this.writeRetryDelay * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (result == null) continue;
            break;
        }
        if ((retrys > this.writeRetries || this.isStopped()) && lastEx != null) {
            if (this.getTransformMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), row, 1L, lastEx.getMessage(), "", "MongoDbOutput");
            } else {
                throw new HopException((Throwable)lastEx);
            }
        }
    }

    protected WriteResult batchRetryUsingSave(boolean lastRetry) throws MongoException, HopException, MongoDbException {
        WriteResult result = null;
        int count = 0;
        this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.CurrentBatchSize", (Object[])new Object[]{this.batch.size()}));
        int len = this.batch.size();
        for (int i = 0; i < len; ++i) {
            DBObject toTry = this.batch.get(i);
            Object[] correspondingRow = this.batchRows.get(i);
            try {
                result = ((MongoDbOutputData)this.data).getCollection().save(toTry);
                ++count;
                continue;
            }
            catch (MongoException ex) {
                if (!lastRetry) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.SuccessfullySavedXDocuments", (Object[])new Object[]{count}));
                    this.batch = MongoDbOutput.copyExceptFirst(count, this.batch);
                    this.batchRows = MongoDbOutput.copyExceptFirst(count, this.batchRows);
                    throw ex;
                }
                if (this.getTransformMeta().isDoingErrorHandling()) {
                    this.putError(this.getInputRowMeta(), correspondingRow, 1L, ex.getMessage(), "", "MongoDbOutput");
                    continue;
                }
                this.batch = MongoDbOutput.copyExceptFirst(i + 1, this.batch);
                this.batchRows = MongoDbOutput.copyExceptFirst(i + 1, this.batchRows);
                throw ex;
            }
        }
        this.batch.clear();
        this.batchRows.clear();
        this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.SuccessfullySavedXDocuments", (Object[])new Object[]{count}));
        return result;
    }

    private static <T> List<T> copyExceptFirst(int amount, List<T> list) {
        return new ArrayList<T>(list.subList(amount, list.size()));
    }

    protected void doBatch() throws HopException, MongoDbException {
        int retries = 0;
        MongoException lastEx = null;
        while (retries <= this.writeRetries && !this.isStopped()) {
            WriteResult result;
            block10: {
                result = null;
                try {
                    if (retries == 0) {
                        result = ((MongoDbOutputData)this.data).getCollection().insert(this.batch);
                    } else {
                        this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.SavingIndividualDocsInCurrentBatch", (String[])new String[0]));
                        result = this.batchRetryUsingSave(retries == this.writeRetries);
                    }
                }
                catch (MongoException me) {
                    boolean shouldNotBeAvoided;
                    boolean bl = shouldNotBeAvoided = !MongoDbOutput.isTimeoutException(me) && retries == 0;
                    if (shouldNotBeAvoided) {
                        lastEx = me;
                    }
                    if (++retries > this.writeRetries) break block10;
                    if (shouldNotBeAvoided) {
                        this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.ErrorWritingToMongo", (String[])new String[]{me.toString()}));
                        this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Message.Retry", (Object[])new Object[]{this.writeRetryDelay}));
                    }
                    try {
                        Thread.sleep(this.writeRetryDelay * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (result == null) continue;
            break;
        }
        if ((retries > this.writeRetries || this.isStopped()) && lastEx != null) {
            throw new HopException(lastEx);
        }
        this.batch.clear();
        this.batchRows.clear();
    }

    private static boolean isTimeoutException(MongoException me) {
        return me instanceof MongoExecutionTimeoutException;
    }

    public boolean init() {
        if (super.init()) {
            try {
                if (!StringUtils.isEmpty((String)((MongoDbOutputMeta)this.meta).getWriteRetries())) {
                    this.writeRetries = Const.toInt((String)((MongoDbOutputMeta)this.meta).getWriteRetries(), (int)5);
                }
                if (!StringUtils.isEmpty((String)((MongoDbOutputMeta)this.meta).getWriteRetryDelay())) {
                    this.writeRetryDelay = Const.toInt((String)((MongoDbOutputMeta)this.meta).getWriteRetryDelay(), (int)10);
                }
                String connectionName = this.resolve(((MongoDbOutputMeta)this.meta).getConnectionName());
                try {
                    ((MongoDbOutputData)this.data).connection = (MongoDbConnection)this.metadataProvider.getSerializer(MongoDbConnection.class).load(connectionName);
                }
                catch (Exception e) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.ErrorLoadingMongoDbConnection", (String[])new String[]{connectionName}));
                }
                if (((MongoDbOutputData)this.data).connection == null) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.MongoDbConnection.NotFound", (String[])new String[]{connectionName}));
                }
                String databaseName = this.resolve(((MongoDbOutputData)this.data).connection.getDbName());
                if (StringUtils.isEmpty((String)databaseName)) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.NoDBSpecified", (String[])new String[0]));
                }
                String collection = this.resolve(((MongoDbOutputMeta)this.meta).getCollection());
                if (StringUtils.isEmpty((String)collection)) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.NoCollectionSpecified", (String[])new String[0]));
                }
                if (!StringUtils.isEmpty((String)((MongoDbOutputData)this.data).connection.getAuthenticationUser())) {
                    String authInfo = ((MongoDbOutputData)this.data).connection.isUsingKerberos() ? BaseMessages.getString(PKG, (String)"MongoDbInput.Message.KerberosAuthentication", (String[])new String[]{this.resolve(((MongoDbOutputData)this.data).connection.getAuthenticationUser())}) : BaseMessages.getString(PKG, (String)"MongoDbInput.Message.NormalAuthentication", (String[])new String[]{this.resolve(((MongoDbOutputData)this.data).connection.getAuthenticationUser())});
                    this.logBasic(authInfo);
                }
                ((MongoDbOutputData)this.data).clientWrapper = ((MongoDbOutputData)this.data).connection.createWrapper((IVariables)this, this.log);
                if (StringUtils.isEmpty((String)collection)) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoCollectionSpecified", (String[])new String[0]));
                }
                ((MongoDbOutputData)this.data).createCollection(databaseName, collection);
                ((MongoDbOutputData)this.data).setCollection(((MongoDbOutputData)this.data).getConnection().getCollection(databaseName, collection));
                try {
                    this.mongoTopLevelStructure = MongoDbOutputData.checkTopLevelConsistency(((MongoDbOutputMeta)this.meta).getMongoFields(), (IVariables)this);
                    if (this.mongoTopLevelStructure == MongoDbOutputData.MongoTopLevel.INCONSISTENT) {
                        this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.InconsistentMongoTopLevel", (String[])new String[0]));
                        return false;
                    }
                }
                catch (HopException e) {
                    this.logError(e.getMessage());
                    return false;
                }
                return true;
            }
            catch (UnknownHostException ex) {
                this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.UnknownHost", (String[])new String[]{((MongoDbOutputData)this.data).connection.getHostname()}), ex);
                return false;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.ProblemConnecting", (String[])new String[]{((MongoDbOutputData)this.data).connection.getHostname(), ((MongoDbOutputData)this.data).connection.getPort()}), e);
                return false;
            }
        }
        return false;
    }

    protected void disconnect() {
        if (this.data != null) {
            try {
                ((MongoDbOutputData)this.data).getConnection().dispose();
            }
            catch (MongoDbException e) {
                this.log.logError(e.getMessage());
            }
        }
    }

    public void dispose() {
        this.disconnect();
        super.dispose();
    }

    final void checkInputFieldsMatch(IRowMeta rmi, List<MongoDbOutputMeta.MongoField> mongoFields) throws HopException {
        HashSet<String> expected = new HashSet<String>(mongoFields.size(), 1.0f);
        HashSet<String> actual = new HashSet<String>(rmi.getFieldNames().length, 1.0f);
        for (MongoDbOutputMeta.MongoField field : mongoFields) {
            String mongoMatch = this.resolve(field.incomingFieldName);
            expected.add(mongoMatch);
        }
        for (int i = 0; i < rmi.size(); ++i) {
            String metaFieldName = rmi.getValueMeta(i).getName();
            actual.add(metaFieldName);
        }
        if (!actual.containsAll(expected)) {
            expected.removeAll(actual);
            StringBuffer b = new StringBuffer();
            for (String name : expected) {
                b.append("'").append(name).append("', ");
            }
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.MongoField.Error.FieldsNotFoundInMetadata", (String[])new String[]{b.toString()}));
        }
        boolean found = actual.removeAll(expected);
        if (!found) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NotInsertingAnyFields", (String[])new String[0]));
        }
        if (!actual.isEmpty()) {
            StringBuffer b = new StringBuffer();
            for (String name : actual) {
                b.append("'").append(name).append("', ");
            }
            this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.FieldsNotToBeInserted", (String[])new String[]{b.toString()}));
        }
    }
}

