/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;

public class RegisterExecutor
extends BlockTransferMessage {
    public final String appId;
    public final String execId;
    public final ExecutorShuffleInfo executorInfo;

    public RegisterExecutor(String appId, String execId, ExecutorShuffleInfo executorInfo) {
        this.appId = appId;
        this.execId = execId;
        this.executorInfo = executorInfo;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.REGISTER_EXECUTOR;
    }

    public int hashCode() {
        return Objects.hash(this.appId, this.execId, this.executorInfo);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("appId", (Object)this.appId).append("execId", (Object)this.execId).append("executorInfo", (Object)this.executorInfo).toString();
    }

    public boolean equals(Object other) {
        if (other instanceof RegisterExecutor) {
            RegisterExecutor o = (RegisterExecutor)other;
            return Objects.equals(this.appId, o.appId) && Objects.equals(this.execId, o.execId) && Objects.equals(this.executorInfo, o.executorInfo);
        }
        return false;
    }

    public int encodedLength() {
        return Encoders.Strings.encodedLength((String)this.appId) + Encoders.Strings.encodedLength((String)this.execId) + this.executorInfo.encodedLength();
    }

    public void encode(ByteBuf buf) {
        Encoders.Strings.encode((ByteBuf)buf, (String)this.appId);
        Encoders.Strings.encode((ByteBuf)buf, (String)this.execId);
        this.executorInfo.encode(buf);
    }

    public static RegisterExecutor decode(ByteBuf buf) {
        String appId = Encoders.Strings.decode((ByteBuf)buf);
        String execId = Encoders.Strings.decode((ByteBuf)buf);
        ExecutorShuffleInfo executorShuffleInfo = ExecutorShuffleInfo.decode(buf);
        return new RegisterExecutor(appId, execId, executorShuffleInfo);
    }
}

