/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.ppr;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class PartExprEvalUtils {
    public static synchronized Object evalExprWithPart(ExprNodeDesc expr, Partition p, List<VirtualColumn> vcs, StructObjectInspector rowObjectInspector) throws HiveException {
        LinkedHashMap<String, String> partSpec = p.getSpec();
        Properties partProps = p.getSchema();
        String pcolTypes = partProps.getProperty("partition_columns.types");
        String[] partKeyTypes = pcolTypes.trim().split(":");
        if (partSpec.size() != partKeyTypes.length) {
            throw new HiveException("Internal error : Partition Spec size, " + partProps.size() + " doesn't match partition key definition size, " + partKeyTypes.length);
        }
        boolean hasVC = vcs != null && !vcs.isEmpty();
        Object[] rowWithPart = new Object[hasVC ? 3 : 2];
        ArrayList<String> partNames = new ArrayList<String>();
        ArrayList<Object> partValues = new ArrayList<Object>();
        ArrayList<AbstractPrimitiveWritableObjectInspector> partObjectInspectors = new ArrayList<AbstractPrimitiveWritableObjectInspector>();
        int i = 0;
        for (Map.Entry<String, String> entry : partSpec.entrySet()) {
            partNames.add(entry.getKey());
            AbstractPrimitiveWritableObjectInspector oi = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)partKeyTypes[i++]));
            partValues.add(ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)oi).convert((Object)entry.getValue()));
            partObjectInspectors.add(oi);
        }
        StandardStructObjectInspector partObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(partNames, partObjectInspectors);
        rowWithPart[1] = partValues;
        ArrayList<Object> ois = new ArrayList<Object>(2);
        ois.add(rowObjectInspector);
        ois.add(partObjectInspector);
        if (hasVC) {
            ois.add(VirtualColumn.getVCSObjectInspector(vcs));
        }
        UnionStructObjectInspector rowWithPartObjectInspector = ObjectInspectorFactory.getUnionStructObjectInspector(ois);
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get(expr);
        ObjectInspector evaluateResultOI = evaluator.initialize((ObjectInspector)rowWithPartObjectInspector);
        Object evaluateResultO = evaluator.evaluate(rowWithPart);
        return ((PrimitiveObjectInspector)evaluateResultOI).getPrimitiveJavaObject(evaluateResultO);
    }

    public static synchronized ObjectPair<PrimitiveObjectInspector, ExprNodeEvaluator> prepareExpr(ExprNodeGenericFuncDesc expr, List<String> partColumnNames, List<PrimitiveTypeInfo> partColumnTypeInfos) throws HiveException {
        ArrayList<AbstractPrimitiveJavaObjectInspector> partObjectInspectors = new ArrayList<AbstractPrimitiveJavaObjectInspector>();
        for (int i = 0; i < partColumnNames.size(); ++i) {
            partObjectInspectors.add(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)partColumnTypeInfos.get(i)));
        }
        StandardStructObjectInspector objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(partColumnNames, partObjectInspectors);
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get(expr);
        ObjectInspector evaluateResultOI = evaluator.initialize((ObjectInspector)objectInspector);
        return ObjectPair.create((Object)((PrimitiveObjectInspector)evaluateResultOI), (Object)evaluator);
    }

    public static synchronized Object evaluateExprOnPart(ObjectPair<PrimitiveObjectInspector, ExprNodeEvaluator> pair, Object partColValues) throws HiveException {
        return ((PrimitiveObjectInspector)pair.getFirst()).getPrimitiveJavaObject(((ExprNodeEvaluator)pair.getSecond()).evaluate(partColValues));
    }
}

