/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.snowflake.bulkloader;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.compress.CompressionProviderFactory;
import org.apache.hop.core.compress.ICompressionProvider;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBigNumber;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.snowflake.bulkloader.SnowflakeBulkLoaderData;
import org.apache.hop.pipeline.transforms.snowflake.bulkloader.SnowflakeBulkLoaderMeta;

public class SnowflakeBulkLoader
extends BaseTransform<SnowflakeBulkLoaderMeta, SnowflakeBulkLoaderData> {
    private static final Class<?> PKG = SnowflakeBulkLoaderMeta.class;

    public SnowflakeBulkLoader(TransformMeta transformMeta, SnowflakeBulkLoaderMeta meta, SnowflakeBulkLoaderData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public synchronized boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row != null && this.first) {
            this.first = false;
            ((SnowflakeBulkLoaderData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((SnowflakeBulkLoaderMeta)this.meta).getFields(((SnowflakeBulkLoaderData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            this.openNewFile(this.buildFilename());
            ((SnowflakeBulkLoaderData)this.data).oneFileOpened = true;
            this.initBinaryDataFields();
            if (((SnowflakeBulkLoaderMeta)this.meta).isSpecifyFields() && ((SnowflakeBulkLoaderMeta)this.meta).getDataType().equals(SnowflakeBulkLoaderMeta.DATA_TYPE_CODES[0])) {
                ((SnowflakeBulkLoaderData)this.data).fieldnrs = new HashMap<String, Integer>();
                this.getDbFields();
                for (int i = 0; i < ((SnowflakeBulkLoaderMeta)this.meta).getSnowflakeBulkLoaderFields().size(); ++i) {
                    int streamFieldLocation = ((SnowflakeBulkLoaderData)this.data).outputRowMeta.indexOfValue(((SnowflakeBulkLoaderMeta)this.meta).getSnowflakeBulkLoaderFields().get(i).getStreamField());
                    if (streamFieldLocation < 0) {
                        throw new HopTransformException("Field [" + ((SnowflakeBulkLoaderMeta)this.meta).getSnowflakeBulkLoaderFields().get(i).getStreamField() + "] couldn't be found in the input stream!");
                    }
                    int dbFieldLocation = -1;
                    for (int e = 0; e < ((SnowflakeBulkLoaderData)this.data).dbFields.size(); ++e) {
                        String[] field = ((SnowflakeBulkLoaderData)this.data).dbFields.get(e);
                        if (!field[0].equalsIgnoreCase(((SnowflakeBulkLoaderMeta)this.meta).getSnowflakeBulkLoaderFields().get(i).getTableField())) continue;
                        dbFieldLocation = e;
                        break;
                    }
                    if (dbFieldLocation < 0) {
                        throw new HopException("Field [" + ((SnowflakeBulkLoaderMeta)this.meta).getSnowflakeBulkLoaderFields().get(i).getTableField() + "] couldn't be found in the table!");
                    }
                    ((SnowflakeBulkLoaderData)this.data).fieldnrs.put(((SnowflakeBulkLoaderMeta)this.meta).getSnowflakeBulkLoaderFields().get(i).getTableField().toUpperCase(), streamFieldLocation);
                }
            } else if (((SnowflakeBulkLoaderMeta)this.meta).getDataType().equals(SnowflakeBulkLoaderMeta.DATA_TYPE_CODES[1])) {
                ((SnowflakeBulkLoaderData)this.data).fieldnrs = new HashMap<String, Integer>();
                int streamFieldLocation = ((SnowflakeBulkLoaderData)this.data).outputRowMeta.indexOfValue(((SnowflakeBulkLoaderMeta)this.meta).getJsonField());
                if (streamFieldLocation < 0) {
                    throw new HopTransformException("Field [" + ((SnowflakeBulkLoaderMeta)this.meta).getJsonField() + "] couldn't be found in the input stream!");
                }
                ((SnowflakeBulkLoaderData)this.data).fieldnrs.put("json", streamFieldLocation);
            }
        }
        if (row != null && ((SnowflakeBulkLoaderData)this.data).outputCount > 0 && Const.toInt((String)this.resolve(((SnowflakeBulkLoaderMeta)this.meta).getSplitSize()), (int)0) > 0 && ((SnowflakeBulkLoaderData)this.data).outputCount % Const.toInt((String)this.resolve(((SnowflakeBulkLoaderMeta)this.meta).getSplitSize()), (int)0) == 0) {
            this.closeFile();
            this.openNewFile(this.buildFilename());
        }
        if (row == null) {
            this.closeFile();
            this.loadDatabase();
            this.setOutputDone();
            return false;
        }
        this.writeRowToFile(((SnowflakeBulkLoaderData)this.data).outputRowMeta, row);
        this.putRow(((SnowflakeBulkLoaderData)this.data).outputRowMeta, row);
        if (this.checkFeedback(((SnowflakeBulkLoaderData)this.data).outputCount)) {
            this.logBasic("linenr " + ((SnowflakeBulkLoaderData)this.data).outputCount);
        }
        return true;
    }

    private void getDbFields() throws HopException {
        ((SnowflakeBulkLoaderData)this.data).dbFields = new ArrayList();
        Object sql = "desc table ";
        if (!StringUtils.isEmpty((CharSequence)this.resolve(((SnowflakeBulkLoaderMeta)this.meta).getTargetSchema()))) {
            sql = (String)sql + this.resolve(((SnowflakeBulkLoaderMeta)this.meta).getTargetSchema()) + ".";
        }
        sql = (String)sql + this.resolve(((SnowflakeBulkLoaderMeta)this.meta).getTargetTable());
        this.logDetailed("Executing SQL " + (String)sql);
        try (ResultSet resultSet = ((SnowflakeBulkLoaderData)this.data).db.openQuery((String)sql, null, null, 1000, false);){
            IRowMeta rowMeta = ((SnowflakeBulkLoaderData)this.data).db.getReturnRowMeta();
            int nameField = rowMeta.indexOfValue("NAME");
            int typeField = rowMeta.indexOfValue("TYPE");
            if (nameField < 0 || typeField < 0) {
                throw new HopException("Unable to get database fields");
            }
            Object[] row = ((SnowflakeBulkLoaderData)this.data).db.getRow(resultSet);
            if (row == null) {
                throw new HopException("No fields found in table");
            }
            while (row != null) {
                String[] field = new String[]{rowMeta.getString(row, nameField).toUpperCase(), rowMeta.getString(row, typeField)};
                ((SnowflakeBulkLoaderData)this.data).dbFields.add(field);
                row = ((SnowflakeBulkLoaderData)this.data).db.getRow(resultSet);
            }
            ((SnowflakeBulkLoaderData)this.data).db.closeQuery(resultSet);
        }
        catch (Exception ex) {
            throw new HopException("Error getting database fields", (Throwable)ex);
        }
    }

    private void loadDatabase() throws HopDatabaseException, HopFileException, HopValueException {
        boolean endsWithSlash = this.resolve(((SnowflakeBulkLoaderMeta)this.meta).getWorkDirectory()).endsWith("\\") || this.resolve(((SnowflakeBulkLoaderMeta)this.meta).getWorkDirectory()).endsWith("/");
        String sql = "PUT 'file://" + this.resolve(((SnowflakeBulkLoaderMeta)this.meta).getWorkDirectory()).replaceAll("\\\\", "/") + (endsWithSlash ? "" : "/") + this.resolve(((SnowflakeBulkLoaderMeta)this.meta).getTargetTable()) + "_" + ((SnowflakeBulkLoaderMeta)this.meta).getFileDate() + "_*' " + ((SnowflakeBulkLoaderMeta)this.meta).getStage((IVariables)this) + ";";
        this.logDebug("Executing SQL " + sql);
        try (ResultSet putResultSet = ((SnowflakeBulkLoaderData)this.data).db.openQuery(sql, null, null, 1000, false);){
            IRowMeta putRowMeta = ((SnowflakeBulkLoaderData)this.data).db.getReturnRowMeta();
            Object[] putRow = ((SnowflakeBulkLoaderData)this.data).db.getRow(putResultSet);
            this.logDebug("=========================Put File Results======================");
            int fileNum = 0;
            while (putRow != null) {
                this.logDebug("------------------------ File " + fileNum + "--------------------------");
                for (int i = 0; i < putRowMeta.getFieldNames().length; ++i) {
                    this.logDebug(putRowMeta.getFieldNames()[i] + " = " + putRowMeta.getString(putRow, i));
                    if (!putRowMeta.getFieldNames()[i].equalsIgnoreCase("status") || !putRowMeta.getString(putRow, i).equalsIgnoreCase("ERROR")) continue;
                    throw new HopDatabaseException("Error putting file to Snowflake stage \n" + putRowMeta.getString(putRow, "message", ""));
                }
                ++fileNum;
                putRow = ((SnowflakeBulkLoaderData)this.data).db.getRow(putResultSet);
            }
            ((SnowflakeBulkLoaderData)this.data).db.closeQuery(putResultSet);
        }
        catch (SQLException exception) {
            throw new HopDatabaseException((Throwable)exception);
        }
        String copySQL = ((SnowflakeBulkLoaderMeta)this.meta).getCopyStatement((IVariables)this, ((SnowflakeBulkLoaderData)this.data).getPreviouslyOpenedFiles());
        this.logDebug("Executing SQL " + copySQL);
        try (ResultSet resultSet = ((SnowflakeBulkLoaderData)this.data).db.openQuery(copySQL, null, null, 1000, false);){
            IRowMeta rowMeta = ((SnowflakeBulkLoaderData)this.data).db.getReturnRowMeta();
            Object[] row = ((SnowflakeBulkLoaderData)this.data).db.getRow(resultSet);
            int rowsLoaded = 0;
            int rowsLoadedField = rowMeta.indexOfValue("rows_loaded");
            int rowsError = 0;
            int errorField = rowMeta.indexOfValue("errors_seen");
            this.logBasic("====================== Bulk Load Results======================");
            int rowNum = 1;
            while (row != null) {
                this.logBasic("---------------------- Row " + rowNum + " ----------------------");
                for (int i = 0; i < rowMeta.getFieldNames().length; ++i) {
                    this.logBasic(rowMeta.getFieldNames()[i] + " = " + rowMeta.getString(row, i));
                }
                if (rowsLoadedField >= 0) {
                    rowsLoaded = (int)((long)rowsLoaded + rowMeta.getInteger(row, rowsLoadedField));
                }
                if (errorField >= 0) {
                    rowsError = (int)((long)rowsError + rowMeta.getInteger(row, errorField));
                }
                ++rowNum;
                row = ((SnowflakeBulkLoaderData)this.data).db.getRow(resultSet);
            }
            ((SnowflakeBulkLoaderData)this.data).db.closeQuery(resultSet);
            this.setLinesOutput(rowsLoaded);
            this.setLinesRejected(rowsError);
        }
        catch (SQLException exception) {
            throw new HopDatabaseException((Throwable)exception);
        }
        ((SnowflakeBulkLoaderData)this.data).db.execStatement("commit");
    }

    private void writeRowToFile(IRowMeta rowMeta, Object[] row) throws HopTransformException {
        try {
            if (((SnowflakeBulkLoaderMeta)this.meta).getDataTypeId() == 0 && !((SnowflakeBulkLoaderMeta)this.meta).isSpecifyFields()) {
                for (int i = 0; i < rowMeta.size(); ++i) {
                    if (i > 0 && ((SnowflakeBulkLoaderData)this.data).binarySeparator.length > 0) {
                        ((SnowflakeBulkLoaderData)this.data).writer.write(((SnowflakeBulkLoaderData)this.data).binarySeparator);
                    }
                    IValueMeta v = rowMeta.getValueMeta(i);
                    Object valueData = row[i];
                    this.writeField(v, valueData, null);
                }
                ((SnowflakeBulkLoaderData)this.data).writer.write(((SnowflakeBulkLoaderData)this.data).binaryNewline);
            } else if (((SnowflakeBulkLoaderMeta)this.meta).getDataTypeId() == 0) {
                for (int i = 0; i < ((SnowflakeBulkLoaderData)this.data).dbFields.size(); ++i) {
                    ValueMetaDate v;
                    String[] field;
                    if (((SnowflakeBulkLoaderData)this.data).dbFields.get(i) == null) continue;
                    if (i > 0 && ((SnowflakeBulkLoaderData)this.data).binarySeparator.length > 0) {
                        ((SnowflakeBulkLoaderData)this.data).writer.write(((SnowflakeBulkLoaderData)this.data).binarySeparator);
                    }
                    if ((field = ((SnowflakeBulkLoaderData)this.data).dbFields.get(i))[1].toUpperCase().startsWith("TIMESTAMP")) {
                        v = new ValueMetaDate();
                        v.setConversionMask("yyyy-MM-dd HH:mm:ss.SSS");
                    } else if (field[1].toUpperCase().startsWith("DATE")) {
                        v = new ValueMetaDate();
                        v.setConversionMask("yyyy-MM-dd");
                    } else if (field[1].toUpperCase().startsWith("TIME")) {
                        v = new ValueMetaDate();
                        v.setConversionMask("HH:mm:ss.SSS");
                    } else if (field[1].toUpperCase().startsWith("NUMBER") || field[1].toUpperCase().startsWith("FLOAT")) {
                        v = new ValueMetaBigNumber();
                    } else {
                        v = new ValueMetaString();
                        v.setLength(-1);
                    }
                    int fieldIndex = -1;
                    if (((SnowflakeBulkLoaderData)this.data).fieldnrs.get(((SnowflakeBulkLoaderData)this.data).dbFields.get(i)[0]) != null) {
                        fieldIndex = ((SnowflakeBulkLoaderData)this.data).fieldnrs.get(((SnowflakeBulkLoaderData)this.data).dbFields.get(i)[0]);
                    }
                    Object valueData = null;
                    if (fieldIndex >= 0) {
                        valueData = v.convertData(rowMeta.getValueMeta(fieldIndex), row[fieldIndex]);
                    } else if (((SnowflakeBulkLoaderMeta)this.meta).isErrorColumnMismatch()) {
                        throw new HopException("Error column mismatch: Database field " + ((SnowflakeBulkLoaderData)this.data).dbFields.get(i)[0] + " not found on stream.");
                    }
                    this.writeField((IValueMeta)v, valueData, ((SnowflakeBulkLoaderData)this.data).binaryNullValue);
                }
                ((SnowflakeBulkLoaderData)this.data).writer.write(((SnowflakeBulkLoaderData)this.data).binaryNewline);
            } else {
                int jsonField = ((SnowflakeBulkLoaderData)this.data).fieldnrs.get("json");
                ((SnowflakeBulkLoaderData)this.data).writer.write(((SnowflakeBulkLoaderData)this.data).outputRowMeta.getString(row, jsonField).getBytes(StandardCharsets.UTF_8));
                ((SnowflakeBulkLoaderData)this.data).writer.write(((SnowflakeBulkLoaderData)this.data).binaryNewline);
            }
            ++((SnowflakeBulkLoaderData)this.data).outputCount;
        }
        catch (Exception e) {
            throw new HopTransformException("Error writing line", (Throwable)e);
        }
    }

    private byte[] formatField(IValueMeta v, Object valueData) throws HopValueException {
        if (v.isString()) {
            if (v.isStorageBinaryString() && v.getTrimType() == 0 && v.getLength() < 0 && StringUtils.isEmpty((CharSequence)v.getStringEncoding())) {
                return (byte[])valueData;
            }
            String svalue = valueData instanceof String ? (String)valueData : v.getString(valueData);
            return this.convertStringToBinaryString(v, Const.trimToType((String)svalue, (int)v.getTrimType()));
        }
        return v.getBinaryString(valueData);
    }

    private byte[] convertStringToBinaryString(IValueMeta v, String string) {
        int length = v.getLength();
        if (string == null) {
            return new byte[0];
        }
        if (length > -1 && length < string.length()) {
            String tmp = string.substring(0, length);
            return tmp.getBytes(StandardCharsets.UTF_8);
        }
        byte[] text = string.getBytes(StandardCharsets.UTF_8);
        if (length > string.length()) {
            int size = 0;
            byte[] filler = " ".getBytes(StandardCharsets.UTF_8);
            size = text.length + filler.length * (length - string.length());
            byte[] bytes = new byte[size];
            System.arraycopy(text, 0, bytes, 0, text.length);
            if (filler.length == 1) {
                Arrays.fill(bytes, text.length, size, filler[0]);
            } else {
                int currIndex = text.length;
                for (int i = 0; i < length - string.length(); ++i) {
                    for (byte aFiller : filler) {
                        bytes[currIndex++] = aFiller;
                    }
                }
            }
            return bytes;
        }
        return text;
    }

    private void writeField(IValueMeta v, Object valueData, byte[] nullString) throws HopTransformException {
        try {
            byte[] str = nullString != null && v.isNull(valueData) ? nullString : this.formatField(v, valueData);
            if (str != null && str.length > 0) {
                List<Integer> enclosures = null;
                boolean writeEnclosures = false;
                if (v.isString() && this.containsSeparatorOrEnclosure(str, ((SnowflakeBulkLoaderData)this.data).binarySeparator, ((SnowflakeBulkLoaderData)this.data).binaryEnclosure, ((SnowflakeBulkLoaderData)this.data).escapeCharacters)) {
                    writeEnclosures = true;
                }
                if (writeEnclosures) {
                    ((SnowflakeBulkLoaderData)this.data).writer.write(((SnowflakeBulkLoaderData)this.data).binaryEnclosure);
                    enclosures = this.getEnclosurePositions(str);
                }
                if (enclosures == null) {
                    ((SnowflakeBulkLoaderData)this.data).writer.write(str);
                } else {
                    int from = 0;
                    for (Integer enclosure : enclosures) {
                        int position = enclosure;
                        ((SnowflakeBulkLoaderData)this.data).writer.write(str, from, position - from);
                        ((SnowflakeBulkLoaderData)this.data).writer.write(((SnowflakeBulkLoaderData)this.data).escapeCharacters);
                        from = position;
                    }
                    if (from < str.length) {
                        ((SnowflakeBulkLoaderData)this.data).writer.write(str, from, str.length - from);
                    }
                }
                if (writeEnclosures) {
                    ((SnowflakeBulkLoaderData)this.data).writer.write(((SnowflakeBulkLoaderData)this.data).binaryEnclosure);
                }
            }
        }
        catch (Exception e) {
            throw new HopTransformException("Error writing field content to file", (Throwable)e);
        }
    }

    private List<Integer> getEnclosurePositions(byte[] str) {
        ArrayList<Integer> positions = null;
        int len = str.length;
        for (int i = 0; i < len; ++i) {
            int x;
            boolean found = true;
            for (x = 0; found && x < ((SnowflakeBulkLoaderData)this.data).binaryEnclosure.length; ++x) {
                if (str[i + x] == ((SnowflakeBulkLoaderData)this.data).binaryEnclosure[x]) continue;
                found = false;
            }
            if (!found) {
                found = true;
                for (x = 0; found && x < ((SnowflakeBulkLoaderData)this.data).escapeCharacters.length; ++x) {
                    if (str[i + x] == ((SnowflakeBulkLoaderData)this.data).escapeCharacters[x]) continue;
                    found = false;
                }
            }
            if (!found) continue;
            if (positions == null) {
                positions = new ArrayList<Integer>();
            }
            positions.add(i);
        }
        return positions;
    }

    private String buildFilename() {
        return ((SnowflakeBulkLoaderMeta)this.meta).buildFilename((IVariables)this, this.getCopy(), this.getPartitionId(), ((SnowflakeBulkLoaderData)this.data).splitnr);
    }

    private void openNewFile(String baseFilename) throws HopException {
        if (baseFilename == null) {
            throw new HopFileException(BaseMessages.getString(PKG, (String)"SnowflakeBulkLoader.Exception.FileNameNotSet", (String[])new String[0]));
        }
        ((SnowflakeBulkLoaderData)this.data).writer = null;
        String filename = this.resolve(baseFilename);
        try {
            ICompressionProvider compressionProvider = CompressionProviderFactory.getInstance().getCompressionProviderByName("GZip");
            if (compressionProvider == null) {
                throw new HopException("No compression provider found with name = GZip");
            }
            if (!compressionProvider.supportsOutput()) {
                throw new HopException("Compression provider GZip does not support output streams!");
            }
            if (this.log.isDetailed()) {
                this.logDetailed("Opening output stream using provider: " + compressionProvider.getName());
            }
            if (this.checkPreviouslyOpened(filename)) {
                ((SnowflakeBulkLoaderData)this.data).fos = this.getOutputStream(filename, this.variables, true);
            } else {
                ((SnowflakeBulkLoaderData)this.data).fos = this.getOutputStream(filename, this.variables, false);
                ((SnowflakeBulkLoaderData)this.data).previouslyOpenedFiles.add(filename);
            }
            ((SnowflakeBulkLoaderData)this.data).out = compressionProvider.createOutputStream(((SnowflakeBulkLoaderData)this.data).fos);
            ((SnowflakeBulkLoaderData)this.data).out.addEntry(filename, "gz");
            ((SnowflakeBulkLoaderData)this.data).writer = new BufferedOutputStream((OutputStream)((SnowflakeBulkLoaderData)this.data).out, 5000);
            if (this.log.isDetailed()) {
                this.logDetailed("Opened new file with name [" + HopVfs.getFriendlyURI((String)filename) + "]");
            }
        }
        catch (Exception e) {
            throw new HopException("Error opening new file : " + e.toString());
        }
        ++((SnowflakeBulkLoaderData)this.data).splitnr;
    }

    private boolean closeFile() {
        boolean returnValue = false;
        try {
            if (((SnowflakeBulkLoaderData)this.data).writer != null) {
                ((SnowflakeBulkLoaderData)this.data).writer.flush();
            }
            ((SnowflakeBulkLoaderData)this.data).writer = null;
            if (this.log.isDebug()) {
                this.logDebug("Closing normal file ...");
            }
            if (((SnowflakeBulkLoaderData)this.data).out != null) {
                ((SnowflakeBulkLoaderData)this.data).out.close();
            }
            if (((SnowflakeBulkLoaderData)this.data).fos != null) {
                ((SnowflakeBulkLoaderData)this.data).fos.close();
                ((SnowflakeBulkLoaderData)this.data).fos = null;
            }
            returnValue = true;
        }
        catch (Exception e) {
            this.logError("Exception trying to close file: " + e.toString());
            this.setErrors(1L);
            returnValue = false;
        }
        return returnValue;
    }

    private boolean checkPreviouslyOpened(String filename) {
        return ((SnowflakeBulkLoaderData)this.data).getPreviouslyOpenedFiles().contains(filename);
    }

    public boolean init() {
        if (super.init()) {
            ((SnowflakeBulkLoaderData)this.data).splitnr = 0;
            try {
                ((SnowflakeBulkLoaderData)this.data).databaseMeta = this.getPipelineMeta().findDatabase(((SnowflakeBulkLoaderMeta)this.meta).getConnection(), this.variables);
                ((SnowflakeBulkLoaderData)this.data).db = new Database((ILoggingObject)this, this.variables, ((SnowflakeBulkLoaderData)this.data).databaseMeta);
                ((SnowflakeBulkLoaderData)this.data).db.connect();
                if (this.log.isBasic()) {
                    this.logBasic("Connected to database [" + ((SnowflakeBulkLoaderMeta)this.meta).getConnection() + "]");
                }
                ((SnowflakeBulkLoaderData)this.data).db.setCommit(Integer.MAX_VALUE);
                this.initBinaryDataFields();
            }
            catch (Exception e) {
                this.logError("Couldn't initialize binary data fields", e);
                this.setErrors(1L);
                this.stopAll();
            }
            return true;
        }
        return false;
    }

    private void initBinaryDataFields() throws HopException {
        try {
            ((SnowflakeBulkLoaderData)this.data).binarySeparator = new byte[0];
            ((SnowflakeBulkLoaderData)this.data).binaryEnclosure = new byte[0];
            ((SnowflakeBulkLoaderData)this.data).binaryNewline = new byte[0];
            ((SnowflakeBulkLoaderData)this.data).escapeCharacters = new byte[0];
            ((SnowflakeBulkLoaderData)this.data).binarySeparator = this.resolve(",").getBytes(StandardCharsets.UTF_8);
            ((SnowflakeBulkLoaderData)this.data).binaryEnclosure = this.resolve("\"").getBytes(StandardCharsets.UTF_8);
            ((SnowflakeBulkLoaderData)this.data).binaryNewline = "\n".getBytes(StandardCharsets.UTF_8);
            ((SnowflakeBulkLoaderData)this.data).escapeCharacters = "\\".getBytes(StandardCharsets.UTF_8);
            ((SnowflakeBulkLoaderData)this.data).binaryNullValue = "".getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new HopException("Unexpected error while encoding binary fields", (Throwable)e);
        }
    }

    public void dispose() {
        if (((SnowflakeBulkLoaderData)this.data).oneFileOpened) {
            this.closeFile();
        }
        try {
            if (((SnowflakeBulkLoaderData)this.data).fos != null) {
                ((SnowflakeBulkLoaderData)this.data).fos.close();
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error closing file", e);
            this.setErrors(1L);
        }
        try {
            if (((SnowflakeBulkLoaderData)this.data).db != null) {
                ((SnowflakeBulkLoaderData)this.data).db.disconnect();
            }
        }
        catch (Exception e) {
            this.logError("Unable to close connection to database", e);
            this.setErrors(1L);
        }
        if (((SnowflakeBulkLoaderMeta)this.meta).isRemoveFiles() || !Boolean.parseBoolean(this.resolve("${SNOWFLAKE_DEBUG_MODE}"))) {
            for (String filename : ((SnowflakeBulkLoaderData)this.data).previouslyOpenedFiles) {
                try {
                    HopVfs.getFileObject((String)filename).delete();
                    this.logDetailed("Deleted temp file " + filename);
                }
                catch (Exception ex) {
                    this.logMinimal("Unable to delete temp file", new Object[]{ex});
                }
            }
        }
        super.dispose();
    }

    private boolean containsSeparatorOrEnclosure(byte[] source, byte[] separator, byte[] enclosure, byte[] escape) {
        boolean escapeExists;
        boolean result = false;
        boolean enclosureExists = enclosure != null && enclosure.length > 0;
        boolean separatorExists = separator != null && separator.length > 0;
        boolean bl = escapeExists = escape != null && escape.length > 0;
        if (separatorExists || enclosureExists || escapeExists) {
            block0: for (int index = 0; !result && index < source.length; ++index) {
                int i;
                if (enclosureExists && source[index] == enclosure[0]) {
                    if (index + enclosure.length > source.length) continue;
                    result = true;
                    for (i = 1; i < enclosure.length; ++i) {
                        if (source[index + i] == enclosure[i]) continue;
                        result = false;
                        continue block0;
                    }
                    continue;
                }
                if (separatorExists && source[index] == separator[0]) {
                    if (index + separator.length > source.length) continue;
                    result = true;
                    for (i = 1; i < separator.length; ++i) {
                        if (source[index + i] == separator[i]) continue;
                        result = false;
                        continue block0;
                    }
                    continue;
                }
                if (!escapeExists || source[index] != escape[0] || index + escape.length > source.length) continue;
                result = true;
                for (i = 1; i < escape.length; ++i) {
                    if (source[index + i] == escape[i]) continue;
                    result = false;
                    continue block0;
                }
            }
        }
        return result;
    }

    protected FileObject getFileObject(String vfsFilename) throws HopFileException {
        return HopVfs.getFileObject((String)vfsFilename);
    }

    protected FileObject getFileObject(String vfsFilename, IVariables variables) throws HopFileException {
        return HopVfs.getFileObject((String)vfsFilename);
    }

    private OutputStream getOutputStream(String vfsFilename, IVariables variables, boolean append) throws HopFileException {
        return HopVfs.getOutputStream((String)vfsFilename, (boolean)append);
    }
}

