/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.persistence;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;

public class PersistenceTaskResult
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private boolean inMaintenanceMode;
    private boolean maintenanceTaskCompleted;
    private List<String> handledCaches;
    private List<String> failedToHandleCaches;
    private Map<String, IgniteBiTuple<Boolean, Boolean>> cachesInfo;

    public PersistenceTaskResult() {
    }

    public PersistenceTaskResult(boolean inMaintenanceMode) {
        this.inMaintenanceMode = inMaintenanceMode;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeBoolean(this.inMaintenanceMode);
        out.writeBoolean(this.maintenanceTaskCompleted);
        U.writeCollection(out, this.handledCaches);
        U.writeCollection(out, this.failedToHandleCaches);
        U.writeMap(out, this.cachesInfo);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.inMaintenanceMode = in.readBoolean();
        this.maintenanceTaskCompleted = in.readBoolean();
        this.handledCaches = U.readList(in);
        this.failedToHandleCaches = U.readList(in);
        this.cachesInfo = U.readMap(in);
    }

    public boolean inMaintenanceMode() {
        return this.inMaintenanceMode;
    }

    public boolean maintenanceTaskCompleted() {
        return this.maintenanceTaskCompleted;
    }

    public void maintenanceTaskCompleted(boolean maintenanceTaskCompleted) {
        this.maintenanceTaskCompleted = maintenanceTaskCompleted;
    }

    public List<String> handledCaches() {
        return this.handledCaches;
    }

    public void handledCaches(List<String> handledCaches) {
        this.handledCaches = handledCaches;
    }

    public List<String> failedCaches() {
        return this.failedToHandleCaches;
    }

    public void failedCaches(List<String> failedToHandleCaches) {
        this.failedToHandleCaches = failedToHandleCaches;
    }

    public Map<String, IgniteBiTuple<Boolean, Boolean>> cachesInfo() {
        return this.cachesInfo;
    }

    public void cachesInfo(Map<String, IgniteBiTuple<Boolean, Boolean>> cachesInfo) {
        this.cachesInfo = cachesInfo;
    }
}

