/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class MetaPageUpdatePartitionDataRecord
extends PageDeltaRecord {
    private long updateCntr;
    private long globalRmvId;
    private int partSize;
    private byte state;
    private int allocatedIdxCandidate;
    private long cntrsPageId;

    public MetaPageUpdatePartitionDataRecord(int grpId, long pageId, long updateCntr, long globalRmvId, int partSize, long cntrsPageId, byte state, int allocatedIdxCandidate) {
        super(grpId, pageId);
        this.updateCntr = updateCntr;
        this.globalRmvId = globalRmvId;
        this.partSize = partSize;
        this.state = state;
        this.allocatedIdxCandidate = allocatedIdxCandidate;
        this.cntrsPageId = cntrsPageId;
    }

    public MetaPageUpdatePartitionDataRecord(DataInput in) throws IOException {
        super(in.readInt(), in.readLong());
        this.updateCntr = in.readLong();
        this.globalRmvId = in.readLong();
        this.partSize = in.readInt();
        this.cntrsPageId = in.readLong();
        this.state = in.readByte();
        this.allocatedIdxCandidate = in.readInt();
    }

    public long updateCounter() {
        return this.updateCntr;
    }

    public long globalRemoveId() {
        return this.globalRmvId;
    }

    public int partitionSize() {
        return this.partSize;
    }

    public long countersPageId() {
        return this.cntrsPageId;
    }

    public byte state() {
        return this.state;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        PagePartitionMetaIO io = PagePartitionMetaIO.VERSIONS.forPage(pageAddr);
        io.setUpdateCounter(pageAddr, this.updateCntr);
        io.setGlobalRemoveId(pageAddr, this.globalRmvId);
        io.setSize(pageAddr, this.partSize);
        io.setCountersPageId(pageAddr, this.cntrsPageId);
        io.setPartitionState(pageAddr, this.state);
        io.setCandidatePageCount(pageAddr, this.allocatedIdxCandidate);
    }

    public int allocatedIndexCandidate() {
        return this.allocatedIdxCandidate;
    }

    public void toBytes(ByteBuffer buf) {
        buf.putInt(this.groupId());
        buf.putLong(this.pageId());
        buf.putLong(this.updateCounter());
        buf.putLong(this.globalRemoveId());
        buf.putInt(this.partitionSize());
        buf.putLong(this.countersPageId());
        buf.put(this.state());
        buf.putInt(this.allocatedIndexCandidate());
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.PARTITION_META_PAGE_UPDATE_COUNTERS;
    }

    @Override
    public String toString() {
        return S.toString(MetaPageUpdatePartitionDataRecord.class, this, "partId", (Object)PageIdUtils.partId(this.pageId()), "super", (Object)super.toString());
    }
}

