/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.internal.cache.query.InIndexQueryCriterion;
import org.apache.ignite.internal.cache.query.RangeIndexQueryCriterion;
import org.apache.ignite.internal.cache.query.index.IndexQueryProcessor;
import org.apache.ignite.internal.cache.query.index.SortOrder;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowComparator;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexImpl;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKeyFactory;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.jetbrains.annotations.Nullable;

class IndexKeyQueryCondition {
    private final String fldName;
    private RangeIndexQueryCriterion range;
    private SortedSet<IndexKey> inVals;
    private final InlineIndexImpl idx;
    private IndexRowComparator keyCmp;

    IndexKeyQueryCondition(String fldName, InlineIndexImpl idx) {
        this.idx = idx;
        this.fldName = fldName;
        this.keyCmp = idx.indexDefinition().rowComparator();
    }

    IndexKeyQueryCondition(String fldName, InlineIndexImpl idx, RangeIndexQueryCriterion range, SortedSet<IndexKey> inVals) {
        this.range = range;
        this.idx = idx;
        this.fldName = fldName;
        this.inVals = inVals;
    }

    public List<IndexKeyQueryCondition> splitInToRanges() {
        ArrayList<IndexKeyQueryCondition> conds = new ArrayList<IndexKeyQueryCondition>(this.inVals.size());
        for (IndexKey k : this.inVals) {
            RangeIndexQueryCriterion c = new RangeIndexQueryCriterion(this.fldName, k, k);
            c.lowerIncl(true);
            c.upperIncl(true);
            conds.add(new IndexKeyQueryCondition(this.fldName, this.idx, c, null));
        }
        return conds;
    }

    void accumulate(IndexQueryCriterion criterion) throws IgniteCheckedException {
        if (criterion instanceof InIndexQueryCriterion) {
            this.addInCriterion((InIndexQueryCriterion)criterion);
        } else if (criterion instanceof RangeIndexQueryCriterion) {
            this.addRangeCriterion((RangeIndexQueryCriterion)criterion);
        } else {
            throw new IgniteCheckedException("Unexpected IndexQueryCriterion class: " + criterion);
        }
    }

    public RangeIndexQueryCriterion range() {
        return this.range;
    }

    public SortedSet<IndexKey> inVals() {
        return this.inVals == null ? null : Collections.unmodifiableSortedSet(this.inVals);
    }

    private void addInCriterion(InIndexQueryCriterion criterion) throws IgniteCheckedException {
        if (this.inVals != null) {
            throw new IgniteCheckedException("Multiple IN criteria for same field arent't supported.");
        }
        this.inVals = new TreeSet<IndexKey>((idxKeyLeft, idxKeyRight) -> {
            try {
                return this.compare((IndexKey)idxKeyLeft, (IndexKey)idxKeyRight);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        });
        for (Object v : criterion.values()) {
            this.inVals.add(this.key(v, v == null));
        }
        this.narrowRangeWithIn();
    }

    private void addRangeCriterion(RangeIndexQueryCriterion criterion) throws IgniteCheckedException {
        boolean desc = this.desc();
        if (desc) {
            criterion = criterion.swap();
        }
        IndexKey l = this.key(criterion.lower(), criterion.lowerNull());
        IndexKey u = this.key(criterion.upper(), criterion.upperNull());
        if (l != null && u != null && (desc ? -1 : 1) * this.keyCmp.compareKey(l, u) > 0) {
            throw new IgniteCheckedException("Illegal criterion: lower boundary is greater than the upper boundary: " + IndexQueryProcessor.rangeDesc(criterion, this.fldName, null, null));
        }
        RangeIndexQueryCriterion crit = new RangeIndexQueryCriterion(this.fldName, l, u);
        crit.lowerIncl(criterion.lowerIncl());
        crit.upperIncl(criterion.upperIncl());
        crit.lowerNull(criterion.lowerNull());
        crit.upperNull(criterion.upperNull());
        this.range = this.range == null ? crit : this.mergeRanges(crit);
        this.checkInAndRangeCriteria();
    }

    private RangeIndexQueryCriterion mergeRanges(RangeIndexQueryCriterion idxKeyCrit) throws IgniteCheckedException {
        IndexKey prevLower = (IndexKey)this.range.lower();
        IndexKey prevUpper = (IndexKey)this.range.upper();
        IndexKey l = (IndexKey)idxKeyCrit.lower();
        IndexKey u = (IndexKey)idxKeyCrit.upper();
        if (!this.checkBoundaries(l, prevUpper, idxKeyCrit.lowerIncl(), this.range.upperIncl()) || !this.checkBoundaries(prevLower, u, this.range.lowerIncl(), idxKeyCrit.upperIncl())) {
            String prevDesc = IndexQueryProcessor.rangeDesc(this.range, this.range.field(), prevLower == null ? null : prevLower.key(), prevUpper == null ? null : prevUpper.key());
            throw new IgniteCheckedException("Failed to merge criterion " + IndexQueryProcessor.rangeDesc(idxKeyCrit, idxKeyCrit.field(), null, null) + " with previous criteria range " + prevDesc);
        }
        int lowCmp = 0;
        boolean lowIncl = idxKeyCrit.lowerIncl();
        boolean lowNull = idxKeyCrit.lowerNull();
        if (l == null || prevLower != null && (lowCmp = this.compare(prevLower, l)) >= 0) {
            l = prevLower;
            lowIncl = lowCmp != 0 ? this.range.lowerIncl() : (this.range.lowerIncl() ? lowIncl : this.range.lowerIncl());
            lowNull = this.range.lowerNull();
        }
        int upCmp = 0;
        boolean upIncl = idxKeyCrit.upperIncl();
        boolean upNull = idxKeyCrit.upperNull();
        if (u == null || prevUpper != null && (upCmp = this.compare(prevUpper, u)) <= 0) {
            u = prevUpper;
            upIncl = upCmp != 0 ? this.range.upperIncl() : (this.range.upperIncl() ? upIncl : this.range.upperIncl());
            upNull = this.range.upperNull();
        }
        RangeIndexQueryCriterion crit = new RangeIndexQueryCriterion(idxKeyCrit.field(), l, u);
        crit.lowerIncl(lowIncl);
        crit.upperIncl(upIncl);
        crit.lowerNull(lowNull);
        crit.upperNull(upNull);
        return crit;
    }

    private boolean checkBoundaries(IndexKey left, IndexKey right, boolean leftIncl, boolean rightIncl) throws IgniteCheckedException {
        boolean boundaryCheck;
        boolean bl = boundaryCheck = left != null && right != null;
        if (boundaryCheck) {
            int cmp = this.compare(left, right);
            return cmp < 0 || cmp == 0 && leftIncl && rightIncl;
        }
        return true;
    }

    private void checkInAndRangeCriteria() throws IgniteCheckedException {
        boolean changed = false;
        if (this.inVals != null && this.range != null) {
            Iterator it = this.inVals.iterator();
            while (it.hasNext()) {
                int cmp;
                IndexKey k = (IndexKey)it.next();
                if (this.range.lower() != null && ((cmp = this.compare((IndexKey)this.range.lower(), k)) > 0 || cmp == 0 && !this.range.lowerIncl())) {
                    it.remove();
                    changed = true;
                }
                if (this.range.upper() == null || (cmp = this.compare((IndexKey)this.range.upper(), k)) >= 0 && (cmp != 0 || this.range.upperIncl())) continue;
                it.remove();
                changed = true;
            }
            if (this.inVals != null && this.inVals.isEmpty()) {
                throw new IgniteCheckedException("Failed to merge IN and RANGE criteria. No IN values match range criterion " + this.range);
            }
        }
        if (changed) {
            this.narrowRangeWithIn();
        }
    }

    private void narrowRangeWithIn() throws IgniteCheckedException {
        RangeIndexQueryCriterion r = new RangeIndexQueryCriterion(this.fldName, this.inVals.first(), this.inVals.last());
        r.lowerIncl(true);
        r.upperIncl(true);
        this.range = this.range == null ? r : this.mergeRanges(r);
        this.checkInAndRangeCriteria();
    }

    private IndexKey key(@Nullable Object val, boolean isNull) {
        IndexKeyType keyType;
        IndexKeyTypeSettings keyTypeSettings = this.idx.segment(0).rowHandler().indexKeyTypeSettings();
        CacheObjectContext coctx = this.idx.segment(0).cacheGroupContext().cacheObjectContext();
        IndexKey key = null;
        IndexKeyType indexKeyType = keyType = val == null ? IndexKeyType.NULL : IndexKeyType.forClass(val.getClass());
        if (val != null || isNull) {
            key = IndexKeyFactory.wrap(val, keyType, (CacheObjectValueContext)coctx, keyTypeSettings);
        }
        return key;
    }

    private int compare(IndexKey left, IndexKey right) throws IgniteCheckedException {
        return (this.desc() ? -1 : 1) * this.keyCmp.compareKey(left, right);
    }

    boolean desc() {
        IndexKeyDefinition keyDef = this.idx.indexDefinition().indexKeyDefinitions().get(this.fldName);
        return keyDef.order().sortOrder() == SortOrder.DESC;
    }
}

