/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.keys;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.cache.query.index.IndexProcessor;
import org.apache.ignite.internal.cache.query.index.sorted.keys.JavaObjectIndexKey;
import org.jetbrains.annotations.Nullable;

public class PlainJavaObjectIndexKey
extends JavaObjectIndexKey {
    private Object key;
    private byte[] serialized;

    public PlainJavaObjectIndexKey(@Nullable Object key, @Nullable byte[] serialized) {
        this.key = key;
        this.serialized = serialized;
    }

    @Override
    public byte[] bytesNoCopy() {
        try {
            if (this.serialized == null) {
                this.serialized = IndexProcessor.serializer.serialize(this.key);
            }
            return this.serialized;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public Object key() {
        try {
            if (this.key == null) {
                this.key = IndexProcessor.serializer.deserialize(this.serialized);
            }
            return this.key;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to deserialize Java Object from byte array", e);
        }
    }
}

