/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheFindGarbageCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Positional
    @Argument(optional=true, example="groupName1,...,groupNameN")
    private String value;
    @Positional
    @Argument(optional=true, example="nodeId")
    private String value2;
    private String[] groups;
    private UUID[] nodeIds;
    @Argument(optional=true)
    private boolean delete;

    private void parse(String value) {
        try {
            this.nodeIds = CommandUtils.parseVal(value, UUID[].class);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.groups = CommandUtils.parseVal(value, String[].class);
            return;
        }
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.value);
        U.writeString(out, this.value2);
        U.writeArray(out, this.groups);
        U.writeArray(out, this.nodeIds);
        out.writeBoolean(this.delete);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = U.readString(in);
        this.value2 = U.readString(in);
        this.groups = U.readArray(in, String.class);
        this.nodeIds = U.readArray(in, UUID.class);
        this.delete = in.readBoolean();
    }

    public UUID[] nodeIds() {
        return this.nodeIds;
    }

    public void nodeIds(UUID[] nodeIds) {
        this.nodeIds = nodeIds;
    }

    public String value() {
        return this.value;
    }

    public void value(String value) {
        this.value = value;
        this.parse(value);
    }

    public String value2() {
        return this.value2;
    }

    public void value2(String value2) {
        this.value2 = value2;
        this.parse(value2);
    }

    public boolean delete() {
        return this.delete;
    }

    public void delete(boolean delete) {
        this.delete = delete;
    }

    public String[] groups() {
        return this.groups;
    }

    public void groups(String[] groups) {
        this.groups = groups;
    }
}

