/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.compress;

import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.DiskPageCompression;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.ThreadLocalDirectByteBuffer;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.CompactablePageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CompressionProcessor
extends GridProcessorAdapter {
    public static final int LZ4_MIN_LEVEL = 0;
    public static final int LZ4_MAX_LEVEL = 17;
    public static final int LZ4_DEFAULT_LEVEL = 0;
    public static final int ZSTD_MIN_LEVEL = -131072;
    public static final int ZSTD_MAX_LEVEL = 22;
    public static final int ZSTD_DEFAULT_LEVEL = 3;
    public static final byte UNCOMPRESSED_PAGE = 0;
    protected static final byte COMPACTED_PAGE = 1;
    protected static final byte ZSTD_COMPRESSED_PAGE = 2;
    protected static final byte LZ4_COMPRESSED_PAGE = 3;
    protected static final byte SNAPPY_COMPRESSED_PAGE = 4;
    private final ThreadLocalDirectByteBuffer compactBuf = new ThreadLocalDirectByteBuffer(16384, GridUnsafe.NATIVE_BYTE_ORDER);

    public CompressionProcessor(GridKernalContext ctx) {
        super(ctx);
    }

    public static int getCompressionLevel(Integer compressLevel, DiskPageCompression compression) {
        return compressLevel != null ? CompressionProcessor.checkCompressionLevelBounds(compressLevel, compression) : CompressionProcessor.getDefaultCompressionLevel(compression);
    }

    public static int getDefaultCompressionLevel(DiskPageCompression compression) {
        switch (compression) {
            case ZSTD: {
                return 3;
            }
            case LZ4: {
                return 0;
            }
            case SNAPPY: 
            case SKIP_GARBAGE: 
            case DISABLED: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Compression: " + compression);
    }

    public static int checkCompressionLevelBounds(int compressLevel, DiskPageCompression compression) {
        switch (compression) {
            case ZSTD: {
                CompressionProcessor.checkCompressionLevelBounds(compressLevel, -131072, 22);
                break;
            }
            case LZ4: {
                CompressionProcessor.checkCompressionLevelBounds(compressLevel, 0, 17);
                break;
            }
            default: {
                throw new IllegalArgumentException("Compression level for " + compression + " is not supported.");
            }
        }
        return compressLevel;
    }

    private static void checkCompressionLevelBounds(int compressLevel, int min, int max) {
        if (compressLevel < min || compressLevel > max) {
            throw new IllegalArgumentException("Compression level for LZ4 must be between " + min + " and " + max + ".");
        }
    }

    private static <T> T fail() throws IgniteCheckedException {
        throw new IgniteCheckedException("Make sure that ignite-compress module is in classpath.");
    }

    public void checkPageCompressionSupported() throws IgniteCheckedException {
        CompressionProcessor.fail();
    }

    public void checkPageCompressionSupported(Path storagePath, int pageSize) throws IgniteCheckedException {
        CompressionProcessor.fail();
    }

    protected static ByteBuffer setCompactionInfo(ByteBuffer page, int compactSize) {
        return CompressionProcessor.setCompressionInfo(page, DiskPageCompression.SKIP_GARBAGE, compactSize, compactSize);
    }

    protected static ByteBuffer setCompressionInfo(ByteBuffer page, DiskPageCompression compression, int compressedSize, int compactedSize) {
        assert (compressedSize >= 0 && compressedSize <= Short.MAX_VALUE) : compressedSize;
        assert (compactedSize >= 0 && compactedSize <= Short.MAX_VALUE) : compactedSize;
        PageIO.setCompressionType(page, CompressionProcessor.getCompressionType(compression));
        PageIO.setCompressedSize(page, (short)compressedSize);
        PageIO.setCompactedSize(page, (short)compactedSize);
        return page;
    }

    private static byte getCompressionType(DiskPageCompression compression) {
        if (compression == DiskPageCompression.DISABLED) {
            return 0;
        }
        switch (compression) {
            case ZSTD: {
                return 2;
            }
            case LZ4: {
                return 3;
            }
            case SNAPPY: {
                return 4;
            }
            case SKIP_GARBAGE: {
                return 1;
            }
        }
        throw new IllegalStateException("Unexpected compression: " + compression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer compressPage(ByteBuffer page, int pageSize, int blockSize, DiskPageCompression compression, int compressLevel) throws IgniteCheckedException {
        assert (compression != null && compression != DiskPageCompression.DISABLED) : compression;
        assert (U.isPow2(blockSize)) : blockSize;
        assert (page.position() == 0 && page.limit() >= pageSize);
        int oldPageLimit = page.limit();
        try {
            page.limit(pageSize);
            ByteBuffer compactPage = this.doCompactPage(page, pageSize);
            int compactSize = compactPage.limit();
            assert (compactSize <= pageSize) : compactSize;
            if (compactSize < blockSize || compression == DiskPageCompression.SKIP_GARBAGE) {
                ByteBuffer byteBuffer = CompressionProcessor.setCompactionInfo(compactPage, compactSize);
                return byteBuffer;
            }
            ByteBuffer compressedPage = this.doCompressPage(compression, compactPage, compactSize, compressLevel);
            assert (compressedPage.position() == 0);
            int freeCompactBlocks = (pageSize - compactSize) / blockSize;
            int compressedSize = compressedPage.limit();
            int freeCompressedBlocks = (pageSize - compressedSize) / blockSize;
            if (freeCompactBlocks >= freeCompressedBlocks) {
                if (freeCompactBlocks == 0) {
                    ByteBuffer byteBuffer = page;
                    return byteBuffer;
                }
                ByteBuffer byteBuffer = CompressionProcessor.setCompactionInfo(compactPage, compactSize);
                return byteBuffer;
            }
            ByteBuffer byteBuffer = CompressionProcessor.setCompressionInfo(compressedPage, compression, compressedSize, compactSize);
            return byteBuffer;
        }
        finally {
            page.limit(oldPageLimit);
        }
    }

    protected ByteBuffer doCompactPage(ByteBuffer page, int pageSize) throws IgniteCheckedException {
        Object io = PageIO.getPageIO(page);
        ByteBuffer compactPage = this.compactBuf.get();
        if (io instanceof CompactablePageIO) {
            ((CompactablePageIO)io).compactPage(page, compactPage, pageSize);
        } else {
            if (page.isDirect()) {
                return page;
            }
            PageUtils.putBytes(GridUnsafe.bufferAddress(compactPage), 0, page.array());
            compactPage.limit(pageSize);
        }
        return compactPage;
    }

    protected ByteBuffer doCompressPage(DiskPageCompression compression, ByteBuffer compactPage, int compactSize, int compressLevel) {
        throw new IllegalStateException("Unsupported compression: " + compression);
    }

    public void decompressPage(ByteBuffer page, int pageSize) throws IgniteCheckedException {
        assert (page.capacity() >= pageSize) : "capacity=" + page.capacity() + ", pageSize=" + pageSize;
        byte compressType = PageIO.getCompressionType(page);
        if (compressType == 0) {
            return;
        }
        short compressedSize = PageIO.getCompressedSize(page);
        short compactSize = PageIO.getCompactedSize(page);
        assert (compactSize <= pageSize && compactSize >= compressedSize);
        if (compressType == 1) {
            page.position(0).limit(compactSize);
        } else {
            this.doDecompressPage(compressType, page, compressedSize, compactSize);
        }
        Object io = PageIO.getPageIO(page);
        if (io instanceof CompactablePageIO) {
            ((CompactablePageIO)io).restorePage(page, pageSize);
        } else assert (compactSize == pageSize) : "Wrong compacted page size [compactSize=" + compactSize + ", pageSize=" + pageSize + "]";
        CompressionProcessor.setCompressionInfo(page, DiskPageCompression.DISABLED, 0, 0);
    }

    protected void doDecompressPage(int compressType, ByteBuffer page, int compressedSize, int compactSize) {
        throw new IllegalStateException("Unsupported compression: " + compressType);
    }
}

