/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.tags.propagation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import io.opencensus.implcore.internal.CurrentState;
import io.opencensus.implcore.tags.TagMapImpl;
import io.opencensus.implcore.tags.TagValueWithMetadata;
import io.opencensus.tags.InternalUtils;
import io.opencensus.tags.Tag;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagMetadata;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.propagation.TagContextDeserializationException;
import io.opencensus.tags.propagation.TagContextSerializationException;
import io.opencensus.tags.propagation.TagContextTextFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class CorrelationContextFormat
extends TagContextTextFormat {
    @VisibleForTesting
    static final String CORRELATION_CONTEXT = "Correlation-Context";
    private static final List<String> FIELDS = Collections.singletonList("Correlation-Context");
    @VisibleForTesting
    static final int MAX_NUMBER_OF_TAGS = 180;
    private static final int TAG_SERIALIZED_SIZE_LIMIT = 4096;
    private static final int TAGCONTEXT_SERIALIZED_SIZE_LIMIT = 8192;
    private static final char TAG_KEY_VALUE_DELIMITER = '=';
    private static final char TAG_DELIMITER = ',';
    private static final Splitter TAG_KEY_VALUE_SPLITTER = Splitter.on((char)'=');
    private static final Splitter TAG_SPLITTER = Splitter.on((char)',');
    private static final char TAG_PROPERTIES_DELIMITER = ';';
    @VisibleForTesting
    static final TagMetadata METADATA_UNLIMITED_PROPAGATION = TagMetadata.create((TagMetadata.TagTtl)TagMetadata.TagTtl.UNLIMITED_PROPAGATION);
    private final CurrentState state;

    CorrelationContextFormat(CurrentState state) {
        this.state = state;
    }

    public List<String> fields() {
        return FIELDS;
    }

    public <C> void inject(TagContext tagContext, C carrier, TagContextTextFormat.Setter<C> setter) throws TagContextSerializationException {
        Preconditions.checkNotNull((Object)tagContext, (Object)"tagContext");
        Preconditions.checkNotNull(carrier, (Object)"carrier");
        Preconditions.checkNotNull(setter, (Object)"setter");
        if (CurrentState.State.DISABLED.equals((Object)this.state.getInternal())) {
            return;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder(8192);
            int totalChars = 0;
            int totalTags = 0;
            Iterator i = InternalUtils.getTags((TagContext)tagContext);
            while (i.hasNext()) {
                Tag tag = (Tag)i.next();
                if (TagMetadata.TagTtl.NO_PROPAGATION.equals((Object)tag.getTagMetadata().getTagTtl())) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                ++totalTags;
                totalChars += CorrelationContextFormat.encodeTag(tag, stringBuilder);
            }
            Preconditions.checkArgument((totalTags <= 180 ? 1 : 0) != 0, (Object)"Number of tags in the TagContext exceeds limit 180");
            Preconditions.checkArgument((totalChars <= 8192 ? 1 : 0) != 0, (Object)"Size of TagContext exceeds the maximum serialized size 8192");
            setter.put(carrier, CORRELATION_CONTEXT, stringBuilder.toString());
        }
        catch (IllegalArgumentException e) {
            throw new TagContextSerializationException("Failed to serialize TagContext", (Throwable)e);
        }
    }

    private static int encodeTag(Tag tag, StringBuilder stringBuilder) {
        String key = tag.getKey().getName();
        String value = tag.getValue().asString();
        int charsOfTag = key.length() + value.length();
        Preconditions.checkArgument((charsOfTag <= 4096 ? 1 : 0) != 0, (Object)("Serialized size of tag " + tag + " exceeds limit " + 4096));
        stringBuilder.append(key).append('=').append(value);
        return charsOfTag;
    }

    public <C> TagContext extract(C carrier, TagContextTextFormat.Getter<C> getter) throws TagContextDeserializationException {
        Preconditions.checkNotNull(carrier, (Object)"carrier");
        Preconditions.checkNotNull(getter, (Object)"getter");
        if (CurrentState.State.DISABLED.equals((Object)this.state.getInternal())) {
            return TagMapImpl.EMPTY;
        }
        String correlationContext = getter.get(carrier, CORRELATION_CONTEXT);
        if (correlationContext == null) {
            throw new TagContextDeserializationException("Correlation-Context not present.");
        }
        try {
            if (correlationContext.isEmpty()) {
                return TagMapImpl.EMPTY;
            }
            HashMap<TagKey, TagValueWithMetadata> tags = new HashMap<TagKey, TagValueWithMetadata>();
            List stringTags = TAG_SPLITTER.splitToList((CharSequence)correlationContext);
            for (String stringTag : stringTags) {
                CorrelationContextFormat.decodeTag(stringTag, tags);
            }
            return new TagMapImpl(tags);
        }
        catch (IllegalArgumentException e) {
            throw new TagContextDeserializationException("Invalid TagContext: " + correlationContext, (Throwable)e);
        }
    }

    private static void decodeTag(String stringTag, Map<TagKey, TagValueWithMetadata> tags) {
        int firstPropertyIndex = stringTag.indexOf(59);
        String keyWithValue = firstPropertyIndex != -1 ? stringTag.substring(0, firstPropertyIndex) : stringTag;
        List keyValuePair = TAG_KEY_VALUE_SPLITTER.splitToList((CharSequence)keyWithValue);
        Preconditions.checkArgument((keyValuePair.size() == 2 ? 1 : 0) != 0, (Object)("Malformed tag " + stringTag));
        TagKey key = TagKey.create((String)((String)keyValuePair.get(0)).trim());
        TagValue value = TagValue.create((String)((String)keyValuePair.get(1)).trim());
        TagValueWithMetadata valueWithMetadata = TagValueWithMetadata.create(value, METADATA_UNLIMITED_PROPAGATION);
        tags.put(key, valueWithMetadata);
    }
}

