/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.query.calcite.externalize.RelInputEx;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.processors.query.calcite.rel.ProjectableFilterableTableScan;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteIndex;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIndexScan
extends ProjectableFilterableTableScan {
    protected final String idxName;
    protected final List<SearchBounds> searchBounds;

    protected AbstractIndexScan(RelInput input) {
        super(input);
        this.idxName = input.getString("index");
        this.searchBounds = ((RelInputEx)input).getSearchBounds("searchBounds");
    }

    protected AbstractIndexScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, String idxName, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable List<SearchBounds> searchBounds, @Nullable ImmutableBitSet reqColumns) {
        super(cluster, traitSet, Collections.emptyList(), table, proj, cond, reqColumns);
        this.idxName = idxName;
        this.searchBounds = searchBounds;
    }

    @Override
    protected RelWriter explainTerms0(RelWriter pw) {
        pw = pw.item("index", (Object)this.idxName);
        pw = super.explainTerms0(pw);
        if ((pw = pw.itemIf("searchBounds", this.searchBounds, this.searchBounds != null)).getDetailLevel() == SqlExplainLevel.ALL_ATTRIBUTES) {
            pw = pw.item("inlineScan", (Object)this.isInlineScan());
        }
        return pw;
    }

    public String indexName() {
        return this.idxName;
    }

    public boolean isInlineScan() {
        IgniteTable tbl = (IgniteTable)this.table.unwrap(IgniteTable.class);
        IgniteIndex idx = tbl.getIndex(this.idxName);
        if (idx != null) {
            return idx.isInlineScanPossible(this.requiredColumns);
        }
        return false;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double cost;
        double inlineReward;
        double rows = this.table.getRowCount();
        IgniteTable tbl = (IgniteTable)this.table.unwrap(IgniteTable.class);
        IgniteIndex idx = tbl.getIndex(this.idxName);
        double d = inlineReward = idx != null && this.isInlineScan() ? 0.5 + 0.5 * (double)idx.collation().getFieldCollations().size() / (double)this.table.getRowType().getFieldCount() : 1.0;
        if (this.condition == null) {
            cost = rows * 1.0 * inlineReward;
        } else {
            RexBuilder builder = this.getCluster().getRexBuilder();
            double selectivity = 1.0;
            cost = 0.0;
            if (this.searchBounds != null) {
                selectivity = mq.getSelectivity((RelNode)this, RexUtil.composeConjunction((RexBuilder)builder, Commons.transform(this.searchBounds, b -> b == null ? null : b.condition())));
                cost = Math.log(rows) * 3.0;
            }
            if ((rows *= selectivity) <= 0.0) {
                rows = 1.0;
            }
            cost += rows * (3.0 + 1.0 * inlineReward);
        }
        return planner.getCostFactory().makeCost(rows, cost, 0.0).plus(planner.getCostFactory().makeTinyCost());
    }

    public List<SearchBounds> searchBounds() {
        return this.searchBounds;
    }
}

