/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index;

import java.util.List;
import java.util.SortedSet;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.cache.query.RangeIndexQueryCriterion;
import org.apache.ignite.internal.cache.query.index.IndexKeyQueryCondition;
import org.apache.ignite.internal.cache.query.index.IndexSingleRangeQuery;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowComparator;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexTree;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.jetbrains.annotations.Nullable;

class IndexQueryCriteriaClosure
implements BPlusTree.TreeRowClosure<IndexRow, IndexRow> {
    private final IndexSingleRangeQuery qry;
    private final IndexRowComparator rowCmp;

    IndexQueryCriteriaClosure(IndexSingleRangeQuery qry, IndexRowComparator rowCmp) {
        this.qry = qry;
        this.rowCmp = rowCmp;
    }

    @Override
    public boolean apply(BPlusTree<IndexRow, IndexRow> tree, BPlusIO<IndexRow> io, long pageAddr, int idx) throws IgniteCheckedException {
        return this.rowMatchRange((InlineIndexTree)tree, io, pageAddr, idx, this.qry.lower(), this.qry.upper());
    }

    private boolean rowMatchRange(InlineIndexTree tree, BPlusIO<IndexRow> io, long pageAddr, int idx, IndexRow low, IndexRow high) throws IgniteCheckedException {
        int off = io.offset(idx);
        int fieldOff = 0;
        InlineIndexRow currRow = new InlineIndexRow(tree, io, pageAddr, idx);
        List<InlineIndexKeyType> keyTypes = tree.rowHandler().inlineIndexKeyTypes();
        for (int keyIdx = 0; keyIdx < tree.rowHandler().indexKeyDefinitions().size(); ++keyIdx) {
            int cmp;
            IndexKeyQueryCondition keyCond = this.qry.keyCondition(keyIdx);
            if (keyCond == null) {
                return true;
            }
            RangeIndexQueryCriterion c = keyCond.range();
            SortedSet<IndexKey> inVals = keyCond.inVals();
            InlineIndexKeyType keyType = keyIdx < keyTypes.size() ? keyTypes.get(keyIdx) : null;
            boolean descOrder = keyCond.desc();
            int maxSize = tree.inlineSize() - fieldOff;
            if (inVals != null) {
                IndexKey key = null;
                if (keyType != null && keyType.type() != IndexKeyType.JAVA_OBJECT && keyType.inlinedFullValue(pageAddr, off + fieldOff, maxSize)) {
                    key = keyType.get(pageAddr, off + fieldOff, maxSize);
                }
                if (key == null) {
                    IndexRow row = io.getLookupRow(tree, pageAddr, idx);
                    key = row.key(keyIdx);
                }
                if (!inVals.contains(key)) {
                    return false;
                }
            }
            if (low != null && low.key(keyIdx) != null && ((cmp = currRow.compare(this.rowCmp, low, keyIdx, off + fieldOff, maxSize, keyType)) == 0 ? !c.lowerIncl() : cmp < 0 ^ descOrder)) {
                return false;
            }
            if (high != null && high.key(keyIdx) != null && ((cmp = currRow.compare(this.rowCmp, high, keyIdx, off + fieldOff, maxSize, keyType)) == 0 ? !c.upperIncl() : cmp > 0 ^ descOrder)) {
                return false;
            }
            if (keyType == null) continue;
            fieldOff += keyType.inlineSize(pageAddr, off + fieldOff);
        }
        return true;
    }

    private static class InlineIndexRow {
        private final long pageAddr;
        private final int idx;
        private final InlineIndexTree tree;
        private final BPlusIO<IndexRow> io;
        private IndexRow currRow;

        private InlineIndexRow(InlineIndexTree tree, BPlusIO<IndexRow> io, long addr, int idx) {
            this.pageAddr = addr;
            this.idx = idx;
            this.tree = tree;
            this.io = io;
        }

        private int compare(IndexRowComparator rowCmp, IndexRow o, int keyIdx, int off, int maxSize, @Nullable InlineIndexKeyType keyType) throws IgniteCheckedException {
            if (this.currRow == null) {
                int cmp = Integer.MIN_VALUE;
                if (keyType != null) {
                    cmp = rowCmp.compareKey(this.pageAddr, off, maxSize, o.key(keyIdx), keyType);
                }
                if (cmp == Integer.MIN_VALUE || cmp == -2) {
                    this.currRow = (IndexRow)this.tree.getRow(this.io, this.pageAddr, this.idx);
                } else {
                    return cmp;
                }
            }
            return rowCmp.compareRow(this.currRow, o, keyIdx);
        }
    }
}

