/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryInvalidTypeException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfoBean;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.cache.CacheClassLoaderMarker;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheInternal;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.IgnitePeerToPeerClassLoadingException;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.util.lang.GridPeerDeployAware;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CA;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedHashMap;

public class GridCacheDeploymentManager<K, V>
extends GridCacheSharedManagerAdapter<K, V> {
    private volatile ClassLoader globalLdr;
    private final Map<String, List<CA>> undeploys = new HashMap<String, List<CA>>();
    private ConcurrentMap<IgniteUuid, CachedDeploymentInfo<K, V>> deps = new ConcurrentHashMap<IgniteUuid, CachedDeploymentInfo<K, V>>();
    private GridLocalEventListener discoLsnr;
    private final AtomicReference<GridDeployment> locDep = new AtomicReference();
    private final ThreadLocal<Boolean> ignoreOwnership = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private boolean depEnabled;
    private final ThreadLocal<IgniteUuid> localLdrId = new ThreadLocal();

    @Override
    public void start0() throws IgniteCheckedException {
        this.globalLdr = new CacheClassLoader(this.cctx.gridConfig().getClassLoader());
        this.depEnabled = this.cctx.gridDeploy().enabled();
        if (this.depEnabled) {
            this.discoLsnr = new GridLocalEventListener(){

                @Override
                public void onEvent(Event evt) {
                    assert (evt.type() == 12 || evt.type() == 11) : "Unexpected event: " + evt;
                    UUID id = ((DiscoveryEvent)evt).eventNode().id();
                    if (GridCacheDeploymentManager.this.log.isDebugEnabled()) {
                        GridCacheDeploymentManager.this.log.debug("Processing node departure: " + id);
                    }
                    for (Map.Entry entry : GridCacheDeploymentManager.this.deps.entrySet()) {
                        CachedDeploymentInfo d = (CachedDeploymentInfo)entry.getValue();
                        if (GridCacheDeploymentManager.this.log.isDebugEnabled()) {
                            GridCacheDeploymentManager.this.log.debug("Examining cached info: " + d);
                        }
                        if (!d.senderId().equals(id) && !d.removeParticipant(id)) continue;
                        GridCacheDeploymentManager.this.deps.remove(entry.getKey(), d);
                        if (!GridCacheDeploymentManager.this.log.isDebugEnabled()) continue;
                        GridCacheDeploymentManager.this.log.debug("Removed cached info [d=" + d + ", deps=" + GridCacheDeploymentManager.this.deps + "]");
                    }
                }
            };
            this.cctx.gridEvents().addLocalEventListener(this.discoLsnr, 11, 12);
        }
    }

    @Override
    protected void stop0(boolean cancel) {
        if (this.discoLsnr != null) {
            this.cctx.gridEvents().removeLocalEventListener(this.discoLsnr, new int[0]);
        }
    }

    public ClassLoader localLoader() {
        GridDeployment dep = this.locDep.get();
        return dep == null ? U.gridClassLoader() : dep.classLoader();
    }

    public ClassLoader globalLoader() {
        return this.globalLdr;
    }

    public void onEnter() {
    }

    public boolean ignoreOwnership(boolean ignore) {
        boolean old = this.ignoreOwnership.get();
        this.ignoreOwnership.set(ignore);
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unwind(GridCacheContext ctx) {
        List<CA> q;
        Map<String, List<CA>> map = this.undeploys;
        synchronized (map) {
            q = this.undeploys.remove(ctx.name());
        }
        if (q == null) {
            return;
        }
        int cnt = 0;
        for (CA c : q) {
            c.apply();
            ++cnt;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Unwound undeploys count: " + cnt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUndeploy(final ClassLoader ldr, final GridCacheContext<K, V> ctx) {
        assert (ldr != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received onUndeploy() request [ldr=" + ldr + ", cctx=" + this.cctx + "]");
        }
        Map<String, List<CA>> map = this.undeploys;
        synchronized (map) {
            List<CA> queue = this.undeploys.get(ctx.name());
            if (queue == null) {
                queue = new ArrayList<CA>();
                this.undeploys.put(ctx.name(), queue);
            }
            queue.add(new CA(){

                @Override
                public void apply() {
                    GridCacheDeploymentManager.this.onUndeploy0(ldr, ctx);
                }
            });
        }
    }

    private void onUndeploy0(ClassLoader ldr, GridCacheContext<K, V> cacheCtx) {
        GridCacheAdapter<K, V> cache = cacheCtx.cache();
        ArrayList<KeyCacheObject> keys = new ArrayList<KeyCacheObject>();
        this.addEntries(ldr, keys, cache);
        if (cache.isNear()) {
            this.addEntries(ldr, keys, ((GridNearCacheAdapter)cache).dht());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Finished searching keys for undeploy [keysCnt=" + keys.size() + "]");
        }
        cache.clearLocally(keys, true);
        if (cacheCtx.isNear()) {
            cacheCtx.near().dht().clearLocally(keys, true);
        }
        int swapUndeployCnt = cacheCtx.offheap().onUndeploy(ldr);
        if (cacheCtx.userCache() && (!keys.isEmpty() || swapUndeployCnt != 0)) {
            U.quietAndWarn(this.log, "");
            U.quietAndWarn(this.log, "Cleared all cache entries for undeployed class loader [cacheName=" + cacheCtx.name() + ", undeployCnt=" + keys.size() + ", swapUndeployCnt=" + swapUndeployCnt + ", clsLdr=" + ldr.getClass().getName() + "]");
            U.quietAndWarn(this.log, "  ^-- Cache auto-undeployment happens in SHARED deployment mode (to turn off, switch to CONTINUOUS mode)");
            U.quietAndWarn(this.log, "");
        }
        this.globalLdr = new CacheClassLoader();
    }

    private void addEntries(ClassLoader ldr, Collection<KeyCacheObject> keys, GridCacheAdapter cache) {
        GridCacheContext cacheCtx = cache.context();
        for (GridCacheEntryEx e : cache.entries()) {
            boolean bl = cacheCtx.isNear() ? this.undeploy(ldr, e, cacheCtx.near()) || this.undeploy(ldr, e, cacheCtx.near().dht()) : this.undeploy(ldr, e, cacheCtx.cache());
            boolean undeploy = bl;
            if (!undeploy) continue;
            keys.add(e.key());
        }
    }

    private boolean undeploy(ClassLoader ldr, GridCacheEntryEx e, GridCacheAdapter cache) {
        boolean res;
        Object val0;
        Object key0;
        KeyCacheObject key = e.key();
        GridCacheEntryEx entry = cache.peekEx(key);
        if (entry == null) {
            return false;
        }
        try {
            CacheObject v = entry.peek();
            key0 = key.value(cache.context().cacheObjectContext(), false);
            assert (key0 != null) : "Key cannot be null for cache entry: " + e;
            val0 = CU.value(v, cache.context(), false);
        }
        catch (GridCacheEntryRemovedException ignore) {
            return false;
        }
        catch (BinaryInvalidTypeException ex) {
            this.log.error("An attempt to undeploy cache with binary objects.", ex);
            return false;
        }
        catch (IgniteCheckedException | IgniteException ignore) {
            return true;
        }
        ClassLoader keyLdr = U.detectObjectClassLoader(key0);
        ClassLoader valLdr = U.detectObjectClassLoader(val0);
        boolean bl = res = F.eq(ldr, keyLdr) || F.eq(ldr, valLdr);
        if (this.log.isDebugEnabled()) {
            this.log.debug(S.toString("Finished examining entry", "entryCls", e.getClass(), true, "key", key0, true, "keyCls", key0.getClass(), true, "valCls", val0 != null ? val0.getClass() : "null", true, "keyLdr", (Object)keyLdr, false, "valLdr", (Object)valLdr, false, "res", (Object)res, false));
        }
        return res;
    }

    public void p2pContext(UUID sndId, IgniteUuid ldrId, String userVer, DeploymentMode mode, Map<UUID, IgniteUuid> participants) throws IgnitePeerToPeerClassLoadingException {
        CachedDeploymentInfo depInfo;
        this.localLdrId.set(ldrId);
        assert (this.depEnabled);
        if (mode == DeploymentMode.PRIVATE || mode == DeploymentMode.ISOLATED) {
            ClusterNode node = this.cctx.discovery().node(sndId);
            if (node == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Ignoring p2p context (sender has left) [sndId=" + sndId + ", ldrId=" + ldrId + ", userVer=" + userVer + ", mode=" + mode + ", participants=" + participants + "]");
                }
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Ignoring deployment in PRIVATE or ISOLATED mode [sndId=" + sndId + ", ldrId=" + ldrId + ", userVer=" + userVer + ", mode=" + mode + ", participants=" + participants + "]");
            }
            LT.warn(this.log, "Ignoring deployment in PRIVATE or ISOLATED mode [sndId=" + sndId + ", ldrId=" + ldrId + ", userVer=" + userVer + ", mode=" + mode + ", participants=" + participants + "]");
            return;
        }
        if (mode != this.cctx.gridConfig().getDeploymentMode()) {
            LT.warn(this.log, "Local and remote deployment mode mismatch (please fix configuration and restart) [locDepMode=" + this.cctx.gridConfig().getDeploymentMode() + ", rmtDepMode=" + mode + ", rmtNodeId=" + sndId + "]");
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Setting p2p context [sndId=" + sndId + ", ldrId=" + ldrId + ", userVer=" + userVer + ", seqNum=" + ldrId.localId() + ", mode=" + mode + ", participants=" + participants + ", locDepOwner=false]");
        }
        while (true) {
            if ((depInfo = (CachedDeploymentInfo)this.deps.get(ldrId)) == null) {
                if (!sndId.equals(ldrId.globalId()) && participants == null) {
                    throw new IgnitePeerToPeerClassLoadingException("Failed to load class using class loader with given id (loader id doesn't match sender id and there are no more participants) [clsLdrId=" + ldrId + ", senderId=" + sndId + ", participants=null]");
                }
                depInfo = new CachedDeploymentInfo(sndId, ldrId, userVer, mode, participants);
                CachedDeploymentInfo old = this.deps.putIfAbsent(ldrId, depInfo);
                if (old == null) break;
                depInfo = old;
            }
            if (participants == null || depInfo.addParticipants(participants, this.cctx)) break;
            this.deps.remove(ldrId, depInfo);
        }
        if (this.cctx.discovery().node(sndId) == null) {
            this.deps.remove(ldrId, depInfo);
        }
        if (participants != null) {
            for (UUID id : participants.keySet()) {
                if (this.cctx.discovery().node(id) != null || !depInfo.removeParticipant(id)) continue;
                this.deps.remove(ldrId, depInfo);
            }
        }
    }

    public IgniteUuid locLoaderId() {
        return this.localLdrId.get();
    }

    public void registerClasses(Object ... objs) throws IgniteCheckedException {
        this.registerClasses(F.asList(objs));
    }

    public void registerClasses(Iterable<?> objs) throws IgniteCheckedException {
        if (objs != null) {
            for (Object o : objs) {
                this.registerClass(o);
            }
        }
    }

    public void registerClass(Object obj) throws IgniteCheckedException {
        if (obj == null) {
            return;
        }
        if (obj instanceof GridPeerDeployAware) {
            GridPeerDeployAware p = (GridPeerDeployAware)obj;
            this.registerClass(p.deployClass(), p.classLoader());
        } else {
            this.registerClass(obj instanceof Class ? (Class<?>)obj : obj.getClass());
        }
    }

    public void registerClass(Class<?> cls) throws IgniteCheckedException {
        if (cls == null) {
            return;
        }
        this.registerClass(cls, U.detectClassLoader(cls));
    }

    public void registerClass(Class<?> cls, ClassLoader ldr) throws IgniteCheckedException {
        block9: {
            assert (this.cctx.deploymentEnabled());
            if (cls == null || GridCacheInternal.class.isAssignableFrom(cls)) {
                return;
            }
            if (ldr == null) {
                ldr = U.detectClassLoader(cls);
            }
            if (U.p2pLoader(ldr)) {
                return;
            }
            GridDeployment dep = this.locDep.get();
            if (dep == null || !ldr.equals(dep.classLoader()) && !U.hasParent(ldr, dep.classLoader())) {
                block10: {
                    while (true) {
                        ClassLoader curLdr;
                        if ((dep = this.locDep.get()) != null && !dep.local()) {
                            return;
                        }
                        if (dep != null && ((curLdr = dep.classLoader()).equals(ldr) || !curLdr.equals(U.gridClassLoader()) && dep.deployedClass(cls.getName(), new String[0]).get1() != null)) break block9;
                        GridDeployment newDep = this.cctx.gridDeploy().deploy(cls, ldr);
                        if (newDep == null) break block10;
                        if (dep != null) {
                            if (newDep.deployedClass(dep.sampleClassName(), new String[0]).get1() != null) {
                                if (!this.locDep.compareAndSet(dep, newDep)) continue;
                                break block9;
                            }
                            throw new IgniteCheckedException("Encountered incompatible class loaders for cache [class1=" + cls.getName() + ", class2=" + dep.sampleClassName() + "]");
                        }
                        if (this.locDep.compareAndSet(null, newDep)) break;
                    }
                    break block9;
                }
                throw new IgniteCheckedException("Failed to deploy class for local deployment [clsName=" + cls.getName() + ", ldr=" + ldr + "]");
            }
        }
    }

    public void prepare(GridCacheDeployable deployable) throws IgnitePeerToPeerClassLoadingException {
        assert (this.depEnabled);
        if (deployable.deployInfo() == null) {
            GridDeploymentInfoBean dep = this.globalDeploymentInfo();
            if (dep == null) {
                GridDeployment locDep0 = this.locDep.get();
                if (locDep0 != null) {
                    dep = new GridDeploymentInfoBean(locDep0);
                    this.checkDeploymentIsCorrect(dep, deployable, false);
                }
            } else {
                this.checkDeploymentIsCorrect(dep, deployable, true);
            }
            if (dep != null) {
                deployable.prepare(dep);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Prepared grid cache deployable [dep=" + dep + ", deployable=" + deployable + "]");
            }
        }
    }

    private void checkDeploymentIsCorrect(GridDeploymentInfoBean deployment, GridCacheDeployable deployable, boolean failIfNotCorrect) throws IgnitePeerToPeerClassLoadingException {
        if (deployment.participants() == null && !this.cctx.localNode().id().equals(deployment.classLoaderId().globalId())) {
            String msg = "Should not use deployment to prepare deployable, because local node id does not correspond with class loader id, and there are no more participants [locNodeId=" + this.cctx.localNode().id() + ", deployment=" + deployment + ", deployable=" + deployable + ", locDep=" + this.locDep.get() + "]";
            if (failIfNotCorrect) {
                throw new IgnitePeerToPeerClassLoadingException(msg);
            }
            this.log.warning(msg);
        }
    }

    @Nullable
    public GridDeploymentInfoBean globalDeploymentInfo() {
        GridDeploymentInfoBean deploymentInfoBean;
        assert (this.depEnabled);
        if (this.cctx.gridConfig().getDeploymentMode() == DeploymentMode.CONTINUOUS) {
            return null;
        }
        IgniteUuid locLdrId0 = this.localLdrId.get();
        if (locLdrId0 != null && (deploymentInfoBean = this.getDepBean((CachedDeploymentInfo)this.deps.get(this.localLdrId.get()))) != null) {
            return deploymentInfoBean;
        }
        for (CachedDeploymentInfo d : this.deps.values()) {
            GridDeploymentInfoBean deploymentInfoBean2 = this.getDepBean(d);
            if (deploymentInfoBean2 == null) continue;
            return deploymentInfoBean2;
        }
        return null;
    }

    @Nullable
    private GridDeploymentInfoBean getDepBean(CachedDeploymentInfo<K, V> d) {
        if (d == null || this.cctx.discovery().node(d.senderId()) == null) {
            return null;
        }
        Map<UUID, IgniteUuid> participants = d.participants();
        if (participants != null) {
            for (UUID id : participants.keySet()) {
                if (this.cctx.discovery().node(id) == null) continue;
                return new GridDeploymentInfoBean(d.loaderId(), d.userVersion(), d.mode(), participants);
            }
        }
        return null;
    }

    @Override
    public void printMemoryStats() {
        X.println(">>> ", new Object[0]);
        X.println(">>> Cache deployment manager memory stats [igniteInstanceName=" + this.cctx.igniteInstanceName() + "]", new Object[0]);
        X.println(">>>   Undeploys: " + this.undeploys.size(), new Object[0]);
        X.println(">>>   Cached deployments: " + this.deps.size(), new Object[0]);
    }

    @Nullable
    public IgniteUuid getClassLoaderId(@Nullable ClassLoader ldr) {
        if (ldr == null) {
            return null;
        }
        return this.cctx.gridDeploy().getClassLoaderId(ldr);
    }

    @Nullable
    public ClassLoader getClassLoader(IgniteUuid ldrId) {
        assert (ldrId != null);
        GridDeployment dep = this.cctx.gridDeploy().getDeployment(ldrId);
        return dep != null ? dep.classLoader() : null;
    }

    public boolean isGlobalLoader() {
        return this.cctx.gridDeploy().isGlobalLoader(Thread.currentThread().getContextClassLoader());
    }

    private static class CachedDeploymentInfo<K, V> {
        private final UUID sndId;
        private final IgniteUuid ldrId;
        private final String userVer;
        private final DeploymentMode depMode;
        @GridToStringInclude
        private Map<UUID, IgniteUuid> participants;
        private final ReadWriteLock participantsLock = new ReentrantReadWriteLock();

        private CachedDeploymentInfo(UUID sndId, IgniteUuid ldrId, String userVer, DeploymentMode depMode, Map<UUID, IgniteUuid> participants) {
            assert (sndId.equals(ldrId.globalId()) || participants != null) : "[senderId=" + sndId + ", loaderGlobalId=" + ldrId.globalId() + ", participants is null]";
            this.sndId = sndId;
            this.ldrId = ldrId;
            this.userVer = userVer;
            this.depMode = depMode;
            this.participants = F.isEmpty(participants) ? null : new ConcurrentLinkedHashMap<UUID, IgniteUuid>(participants);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addParticipants(Map<UUID, IgniteUuid> newParticipants, GridCacheSharedContext<K, V> cctx) {
            this.participantsLock.readLock().lock();
            try {
                if (this.participants != null && this.participants.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                for (Map.Entry<UUID, IgniteUuid> e : newParticipants.entrySet()) {
                    assert (e.getKey().equals(e.getValue().globalId()));
                    if (cctx.discovery().node(e.getKey()) == null) continue;
                    if (this.participants == null) {
                        this.participants = new ConcurrentLinkedHashMap<UUID, IgniteUuid>();
                    }
                    if (this.participants.containsKey(e.getKey())) continue;
                    this.participants.put(e.getKey(), e.getValue());
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.participantsLock.readLock().unlock();
            }
        }

        boolean removeParticipant(UUID leftNodeId) {
            assert (leftNodeId != null);
            this.participantsLock.writeLock().lock();
            try {
                boolean bl = this.participants != null && this.participants.remove(leftNodeId) != null && this.participants.isEmpty();
                return bl;
            }
            finally {
                this.participantsLock.writeLock().unlock();
            }
        }

        Map<UUID, IgniteUuid> participants() {
            return this.participants;
        }

        UUID senderId() {
            return this.sndId;
        }

        IgniteUuid loaderId() {
            return this.ldrId;
        }

        String userVersion() {
            return this.userVer;
        }

        public DeploymentMode mode() {
            return this.depMode;
        }

        public String toString() {
            return S.toString(CachedDeploymentInfo.class, this);
        }
    }

    private class CacheClassLoader
    extends ClassLoader
    implements CacheClassLoaderMarker {
        private final String[] p2pExclude;

        private CacheClassLoader() {
            this(U.detectClassLoader(GridCacheDeploymentManager.class));
        }

        private CacheClassLoader(ClassLoader classLdr) {
            super(classLdr != null ? classLdr : U.detectClassLoader(GridCacheDeploymentManager.class));
            this.p2pExclude = GridCacheDeploymentManager.this.cctx.gridConfig().getPeerClassLoadingLocalClassPathExclude();
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.findClass(name);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            IgniteBiTuple<Class<?>, Throwable> cls;
            Object t;
            Class<?> cls2;
            GridDeployment d;
            if (!this.isLocallyExcluded(name) && (d = GridCacheDeploymentManager.this.cctx.gridDeploy().getLocalDeployment(name)) != null && (cls2 = d.deployedClass(name, new String[0]).get1()) != null) {
                return cls2;
            }
            IgniteUuid curLdrId = GridCacheDeploymentManager.this.localLdrId.get();
            Throwable err = null;
            if (curLdrId != null && (t = (CachedDeploymentInfo)GridCacheDeploymentManager.this.deps.get(curLdrId)) != null && (cls = this.tryToloadClassFromCacheDep(name, (CachedDeploymentInfo)t)) != null) {
                if (cls.get1() != null) {
                    return cls.get1();
                }
                err = cls.get2();
            }
            for (CachedDeploymentInfo t2 : GridCacheDeploymentManager.this.deps.values()) {
                IgniteBiTuple<Class<?>, Throwable> cls3 = this.tryToloadClassFromCacheDep(name, t2);
                if (cls3 == null) continue;
                if (cls3.get1() != null) {
                    return cls3.get1();
                }
                if (err != null) continue;
                err = cls3.get2();
            }
            try {
                return this.getParent().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                if (err instanceof LinkageError) {
                    U.warn(GridCacheDeploymentManager.this.log, "Failed to load class [name=" + name + "]", err);
                }
                throw e;
            }
        }

        @Nullable
        private IgniteBiTuple<Class<?>, Throwable> tryToloadClassFromCacheDep(String name, CachedDeploymentInfo<K, V> deploymentInfo) {
            UUID sndId = deploymentInfo.senderId();
            IgniteUuid ldrId = deploymentInfo.loaderId();
            String userVer = deploymentInfo.userVersion();
            DeploymentMode mode = deploymentInfo.mode();
            Map<UUID, IgniteUuid> participants = deploymentInfo.participants();
            GridDeployment d = GridCacheDeploymentManager.this.cctx.gridDeploy().getGlobalDeployment(mode, name, name, userVer, sndId, ldrId, participants, F.alwaysTrue());
            return d != null ? d.deployedClass(name, new String[0]) : null;
        }

        private boolean isLocallyExcluded(String name) {
            if (this.p2pExclude != null) {
                for (String path : this.p2pExclude) {
                    if (path.endsWith("*")) {
                        path = path.substring(0, path.length() - 1);
                    }
                    if (!name.startsWith(path)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

