/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.NoopSpan;
import org.apache.ignite.internal.processors.tracing.NoopTracing;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.processors.tracing.Tracing;
import org.apache.ignite.internal.processors.tracing.messages.SpanTransport;
import org.apache.ignite.internal.util.nio.GridNioFilterAdapter;
import org.apache.ignite.internal.util.nio.GridNioFuture;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteInClosure;

public class GridNioTracerFilter
extends GridNioFilterAdapter {
    @GridToStringExclude
    private IgniteLogger log;
    private final Tracing tracer;

    public GridNioTracerFilter(IgniteLogger log, Tracing tracer) {
        super("GridNioTracerFilter");
        this.log = log;
        this.tracer = tracer == null ? new NoopTracing() : tracer;
    }

    @Override
    public String toString() {
        return S.toString(GridNioTracerFilter.class, this);
    }

    @Override
    public void onSessionOpened(GridNioSession ses) throws IgniteCheckedException {
        this.proceedSessionOpened(ses);
    }

    @Override
    public void onSessionClosed(GridNioSession ses) throws IgniteCheckedException {
        this.proceedSessionClosed(ses);
    }

    @Override
    public void onExceptionCaught(GridNioSession ses, IgniteCheckedException ex) throws IgniteCheckedException {
        this.proceedExceptionCaught(ses, ex);
    }

    @Override
    public GridNioFuture<?> onSessionWrite(GridNioSession ses, Object msg, boolean fut, IgniteInClosure<IgniteException> ackC) throws IgniteCheckedException {
        if (msg instanceof SpanTransport && MTC.span() != NoopSpan.INSTANCE) {
            ((SpanTransport)msg).span(this.tracer.serialize(MTC.span()));
        }
        return this.proceedSessionWrite(ses, msg, fut, ackC);
    }

    @Override
    public void onMessageReceived(GridNioSession ses, Object msg) throws IgniteCheckedException {
        byte[] serializedSpan;
        byte[] byArray = serializedSpan = msg instanceof SpanTransport ? ((SpanTransport)msg).span() : null;
        if (serializedSpan != null && serializedSpan.length != 0) {
            Span span = this.tracer.create(SpanType.COMMUNICATION_SOCKET_READ, serializedSpan);
            try (MTC.TraceSurroundings ignore = MTC.support(span);){
                this.proceedMessageReceived(ses, msg);
            }
        } else {
            this.proceedMessageReceived(ses, msg);
        }
    }

    @Override
    public GridNioFuture<Boolean> onSessionClose(GridNioSession ses) throws IgniteCheckedException {
        return this.proceedSessionClose(ses);
    }

    @Override
    public void onSessionIdleTimeout(GridNioSession ses) throws IgniteCheckedException {
        this.proceedSessionIdleTimeout(ses);
    }

    @Override
    public void onSessionWriteTimeout(GridNioSession ses) throws IgniteCheckedException {
        this.proceedSessionWriteTimeout(ses);
    }
}

