/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

public class ParserUtil {
    public static final int KEYWORD = 1;
    public static final int IDENTIFIER = 2;
    public static final int NULL = 3;
    public static final int TRUE = 4;
    public static final int FALSE = 5;
    public static final int ROWNUM = 6;

    private ParserUtil() {
    }

    public static boolean isKeyword(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return ParserUtil.getSaveTokenType(string, false) != 2;
    }

    public static boolean isSimpleIdentifier(String string, boolean bl) {
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!Character.isLetter(c) && c != '_' || Character.isLowerCase(c)) {
            return false;
        }
        int n = string.length();
        for (int i = 1; i < n; ++i) {
            c = string.charAt(i);
            if ((Character.isLetterOrDigit(c) || c == '_') && !Character.isLowerCase(c)) continue;
            return false;
        }
        return ParserUtil.getSaveTokenType(string, bl) == 2;
    }

    public static int getSaveTokenType(String string, boolean bl) {
        switch (string.charAt(0)) {
            case 'A': {
                return ParserUtil.getKeywordOrIdentifier(string, "ALL", 1);
            }
            case 'C': {
                if ("CHECK".equals(string)) {
                    return 1;
                }
                if ("CONSTRAINT".equals(string)) {
                    return 1;
                }
                if ("CROSS".equals(string)) {
                    return 1;
                }
                if (bl && ("CURRENT_DATE".equals(string) || "CURRENT_TIME".equals(string) || "CURRENT_TIMESTAMP".equals(string))) {
                    return 1;
                }
                return 2;
            }
            case 'D': {
                return ParserUtil.getKeywordOrIdentifier(string, "DISTINCT", 1);
            }
            case 'E': {
                if ("EXCEPT".equals(string)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(string, "EXISTS", 1);
            }
            case 'F': {
                if ("FETCH".equals(string)) {
                    return 1;
                }
                if ("FROM".equals(string)) {
                    return 1;
                }
                if ("FOR".equals(string)) {
                    return 1;
                }
                if ("FOREIGN".equals(string)) {
                    return 1;
                }
                if ("FULL".equals(string)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(string, "FALSE", 5);
            }
            case 'G': {
                return ParserUtil.getKeywordOrIdentifier(string, "GROUP", 1);
            }
            case 'H': {
                return ParserUtil.getKeywordOrIdentifier(string, "HAVING", 1);
            }
            case 'I': {
                if ("INNER".equals(string)) {
                    return 1;
                }
                if ("INTERSECT".equals(string)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(string, "IS", 1);
            }
            case 'J': {
                return ParserUtil.getKeywordOrIdentifier(string, "JOIN", 1);
            }
            case 'L': {
                if ("LIMIT".equals(string)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(string, "LIKE", 1);
            }
            case 'M': {
                return ParserUtil.getKeywordOrIdentifier(string, "MINUS", 1);
            }
            case 'N': {
                if ("NOT".equals(string)) {
                    return 1;
                }
                if ("NATURAL".equals(string)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(string, "NULL", 3);
            }
            case 'O': {
                if ("OFFSET".equals(string)) {
                    return 1;
                }
                if ("ON".equals(string)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(string, "ORDER", 1);
            }
            case 'P': {
                return ParserUtil.getKeywordOrIdentifier(string, "PRIMARY", 1);
            }
            case 'R': {
                return ParserUtil.getKeywordOrIdentifier(string, "ROWNUM", 6);
            }
            case 'S': {
                if ("SELECT".equals(string)) {
                    return 1;
                }
                if (bl && ("SYSDATE".equals(string) || "SYSTIME".equals(string) || "SYSTIMESTAMP".equals(string))) {
                    return 1;
                }
                return 2;
            }
            case 'T': {
                if ("TRUE".equals(string)) {
                    return 4;
                }
                if (bl && "TODAY".equals(string)) {
                    return 1;
                }
                return 2;
            }
            case 'U': {
                if ("UNIQUE".equals(string)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(string, "UNION", 1);
            }
            case 'W': {
                if ("WITH".equals(string)) {
                    return 1;
                }
                return ParserUtil.getKeywordOrIdentifier(string, "WHERE", 1);
            }
        }
        return 2;
    }

    private static int getKeywordOrIdentifier(String string, String string2, int n) {
        if (string.equals(string2)) {
            return n;
        }
        return 2;
    }
}

