/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.function.Consumer;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.handshake.HandshakeException;
import org.apache.ignite.internal.network.handshake.HandshakeManager;
import org.apache.ignite.internal.network.netty.InNetworkObject;
import org.apache.ignite.internal.network.netty.MessageHandler;
import org.apache.ignite.internal.network.serialization.PerSessionSerializationService;
import org.apache.ignite.network.NetworkMessage;

public class HandshakeHandler
extends ChannelInboundHandlerAdapter {
    public static final String NAME = "handshake-handler";
    private static final IgniteLogger LOG = Loggers.forClass(HandshakeHandler.class);
    private final HandshakeManager manager;
    private final Consumer<InNetworkObject> messageListener;
    private final PerSessionSerializationService serializationService;

    public HandshakeHandler(HandshakeManager manager, Consumer<InNetworkObject> messageListener, PerSessionSerializationService serializationService) {
        this.manager = manager;
        this.messageListener = messageListener;
        this.serializationService = serializationService;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.manager.onInit(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.manager.onConnectionOpen();
        this.manager.handshakeFuture().whenComplete((unused, throwable) -> {
            if (throwable != null) {
                LOG.debug("Error when performing handshake", throwable);
                ctx.close();
            }
        });
        ctx.fireChannelActive();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.manager.onMessage((NetworkMessage)msg);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.manager.handshakeFuture().completeExceptionally(new HandshakeException("Channel has been closed before handshake has finished or handshake has failed"));
        ctx.fireChannelInactive();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.manager.handshakeFuture().completeExceptionally(cause);
    }

    public MessageHandler createMessageHandler(String remoteConsistentId) {
        return new MessageHandler(this.messageListener, remoteConsistentId, this.serializationService);
    }
}

