/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.index.sorted.io;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.internal.pagememory.io.IoVersions;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.tree.BplusTree;
import org.apache.ignite.internal.pagememory.tree.io.BplusInnerIo;
import org.apache.ignite.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite.internal.storage.pagememory.index.sorted.SortedIndexRowKey;
import org.apache.ignite.internal.storage.pagememory.index.sorted.SortedIndexTree;
import org.apache.ignite.internal.storage.pagememory.index.sorted.io.SortedIndexTreeIo;
import org.apache.ignite.lang.IgniteInternalCheckedException;

public class SortedIndexTreeInnerIo
extends BplusInnerIo<SortedIndexRowKey>
implements SortedIndexTreeIo {
    public static final List<IoVersions<SortedIndexTreeInnerIo>> VERSIONS = IntStream.rangeClosed(0, 2048).mapToObj(inlineSize -> new IoVersions((PageIo[])new SortedIndexTreeInnerIo[]{new SortedIndexTreeInnerIo(1, inlineSize)})).collect(Collectors.toUnmodifiableList());

    private SortedIndexTreeInnerIo(int ver, int inlineSize) {
        super(20000 + inlineSize, ver, true, 38 + inlineSize);
    }

    @Override
    public void store(long dstPageAddr, int dstIdx, BplusIo<SortedIndexRowKey> srcIo, long srcPageAddr, int srcIdx) {
        SortedIndexTreeIo.super.store(dstPageAddr, dstIdx, srcIo, srcPageAddr, srcIdx);
    }

    @Override
    public void storeByOffset(long pageAddr, int off, SortedIndexRowKey row) {
        SortedIndexTreeIo.super.storeByOffset(pageAddr, off, row);
    }

    public SortedIndexRowKey getLookupRow(BplusTree<SortedIndexRowKey, ?> tree, long pageAddr, int idx) throws IgniteInternalCheckedException {
        SortedIndexTree sortedIndexTree = (SortedIndexTree)tree;
        return this.getRow(sortedIndexTree.dataPageReader(), sortedIndexTree.partitionId(), pageAddr, idx);
    }
}

