/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.ignite.internal.util.CollectionUtils;

public class HintUtils {
    private HintUtils() {
    }

    public static boolean containsDisabledRules(List<RelHint> hints) {
        return hints.stream().anyMatch(h -> "DISABLE_RULE".equals(h.hintName) && !h.listOptions.isEmpty());
    }

    public static Set<String> disabledRules(List<RelHint> hints) {
        if (CollectionUtils.nullOrEmpty(hints)) {
            return Collections.emptySet();
        }
        return hints.stream().filter(h -> "DISABLE_RULE".equals(h.hintName)).flatMap(h -> h.listOptions.stream()).collect(Collectors.toSet());
    }

    public static boolean isExpandDistinctAggregate(LogicalAggregate rel) {
        return rel.getHints().stream().anyMatch(h -> "EXPAND_DISTINCT_AGG".equals(h.hintName)) && rel.getAggCallList().stream().anyMatch(AggregateCall::isDistinct);
    }
}

