/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.logger;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.ignite.lang.IgniteStringFormatter;
import org.jetbrains.annotations.NotNull;

public class IgniteLogger {
    private final System.Logger delegate;

    IgniteLogger(@NotNull System.Logger delegate) {
        this.delegate = delegate;
    }

    public void info(String msg, Object ... params) {
        this.logInternal(System.Logger.Level.INFO, msg, null, params);
    }

    public void info(String msg, Throwable th, Object ... params) {
        this.logInternal(System.Logger.Level.INFO, msg, th, params);
    }

    public void info(Supplier<String> msgSupplier, Throwable th) {
        this.logInternalExceptional(System.Logger.Level.INFO, msgSupplier, th);
    }

    public void info(String msg, Throwable th) {
        this.delegate.log(System.Logger.Level.INFO, msg, th);
    }

    public void debug(String msg, Object ... params) {
        this.logInternal(System.Logger.Level.DEBUG, msg, null, params);
    }

    public void debug(String msg, Throwable th, Object ... params) {
        this.logInternal(System.Logger.Level.DEBUG, msg, th, params);
    }

    public void debug(Supplier<String> msgSupplier, Throwable th) {
        this.logInternalExceptional(System.Logger.Level.DEBUG, msgSupplier, th);
    }

    public void debug(String msg, Throwable th) {
        this.delegate.log(System.Logger.Level.DEBUG, msg, th);
    }

    public void warn(String msg, Object ... params) {
        this.logInternal(System.Logger.Level.WARNING, msg, null, params);
    }

    public void warn(String msg, Throwable th, Object ... params) {
        this.logInternal(System.Logger.Level.WARNING, msg, th, params);
    }

    public void warn(Supplier<String> msgSupplier, Throwable th) {
        this.logInternalExceptional(System.Logger.Level.WARNING, msgSupplier, th);
    }

    public void warn(String msg, Throwable th) {
        this.delegate.log(System.Logger.Level.WARNING, msg, th);
    }

    public void error(String msg, Object ... params) {
        this.logInternal(System.Logger.Level.ERROR, msg, null, params);
    }

    public void error(String msg, Throwable th, Object ... params) {
        this.logInternal(System.Logger.Level.ERROR, msg, th, params);
    }

    public void error(Supplier<String> msgSupplier, Throwable th) {
        this.logInternalExceptional(System.Logger.Level.ERROR, msgSupplier, th);
    }

    public void error(String msg, Throwable th) {
        this.delegate.log(System.Logger.Level.ERROR, msg, th);
    }

    public void trace(String msg, Object ... params) {
        this.logInternal(System.Logger.Level.TRACE, msg, null, params);
    }

    public void trace(String msg, Throwable th, Object ... params) {
        this.logInternal(System.Logger.Level.TRACE, msg, th, params);
    }

    public void trace(Supplier<String> msgSupplier, Throwable th) {
        this.logInternalExceptional(System.Logger.Level.TRACE, msgSupplier, th);
    }

    public void trace(String msg, Throwable th) {
        this.delegate.log(System.Logger.Level.TRACE, msg, th);
    }

    private void logInternal(System.Logger.Level level, String msg, Throwable th, Object ... params) {
        Objects.requireNonNull(level);
        if (!this.delegate.isLoggable(level)) {
            return;
        }
        if (th != null) {
            this.delegate.log(level, IgniteStringFormatter.format(msg, params), th);
        } else {
            this.delegate.log(level, IgniteStringFormatter.format(msg, params));
        }
    }

    private void logInternalExceptional(System.Logger.Level level, Supplier<String> msgSupplier, Throwable th) {
        Objects.requireNonNull(level);
        Objects.requireNonNull(msgSupplier);
        if (!this.delegate.isLoggable(level)) {
            return;
        }
        this.delegate.log(level, msgSupplier.get(), th);
    }

    public boolean isTraceEnabled() {
        return this.delegate.isLoggable(System.Logger.Level.TRACE);
    }

    public boolean isDebugEnabled() {
        return this.delegate.isLoggable(System.Logger.Level.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.delegate.isLoggable(System.Logger.Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.delegate.isLoggable(System.Logger.Level.WARNING);
    }
}

