/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import com.github.benmanes.caffeine.cache.Caffeine;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.ignite.configuration.ConfigurationChangeException;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.TopologyEventHandler;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.InternalSqlRowImpl;
import org.apache.ignite.internal.sql.engine.InternalSqlRowSingleBoolean;
import org.apache.ignite.internal.sql.engine.InternalSqlRowSingleString;
import org.apache.ignite.internal.sql.engine.NodeLeftException;
import org.apache.ignite.internal.sql.engine.QueryCancel;
import org.apache.ignite.internal.sql.engine.QueryCancelledException;
import org.apache.ignite.internal.sql.engine.SqlOperationContext;
import org.apache.ignite.internal.sql.engine.SqlQueryProcessor;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.exec.AsyncDataCursor;
import org.apache.ignite.internal.sql.engine.exec.AsyncDataCursorExt;
import org.apache.ignite.internal.sql.engine.exec.ExchangeService;
import org.apache.ignite.internal.sql.engine.exec.ExecutablePlan;
import org.apache.ignite.internal.sql.engine.exec.ExecutableTableRegistry;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.ExecutionDependencyResolver;
import org.apache.ignite.internal.sql.engine.exec.ExecutionId;
import org.apache.ignite.internal.sql.engine.exec.ExecutionService;
import org.apache.ignite.internal.sql.engine.exec.LogicalRelImplementor;
import org.apache.ignite.internal.sql.engine.exec.MailboxRegistry;
import org.apache.ignite.internal.sql.engine.exec.NodeWithConsistencyToken;
import org.apache.ignite.internal.sql.engine.exec.QueryTaskExecutor;
import org.apache.ignite.internal.sql.engine.exec.RemoteFragmentExecutionException;
import org.apache.ignite.internal.sql.engine.exec.RemoteFragmentKey;
import org.apache.ignite.internal.sql.engine.exec.ResolvedDependencies;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.TxAttributes;
import org.apache.ignite.internal.sql.engine.exec.TxAwareAsyncCursor;
import org.apache.ignite.internal.sql.engine.exec.ddl.DdlCommandHandler;
import org.apache.ignite.internal.sql.engine.exec.exp.ExpressionFactory;
import org.apache.ignite.internal.sql.engine.exec.exp.func.TableFunctionRegistry;
import org.apache.ignite.internal.sql.engine.exec.kill.KillCommand;
import org.apache.ignite.internal.sql.engine.exec.kill.KillCommandHandler;
import org.apache.ignite.internal.sql.engine.exec.mapping.ColocationGroup;
import org.apache.ignite.internal.sql.engine.exec.mapping.FragmentDescription;
import org.apache.ignite.internal.sql.engine.exec.mapping.MappedFragment;
import org.apache.ignite.internal.sql.engine.exec.mapping.MappingParameters;
import org.apache.ignite.internal.sql.engine.exec.mapping.MappingService;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.AsyncRootNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Outbox;
import org.apache.ignite.internal.sql.engine.externalize.RelJsonReader;
import org.apache.ignite.internal.sql.engine.message.ErrorMessage;
import org.apache.ignite.internal.sql.engine.message.MessageService;
import org.apache.ignite.internal.sql.engine.message.QueryCloseMessage;
import org.apache.ignite.internal.sql.engine.message.QueryStartRequest;
import org.apache.ignite.internal.sql.engine.message.QueryStartResponse;
import org.apache.ignite.internal.sql.engine.message.SqlQueryMessagesFactory;
import org.apache.ignite.internal.sql.engine.prepare.DdlPlan;
import org.apache.ignite.internal.sql.engine.prepare.ExplainPlan;
import org.apache.ignite.internal.sql.engine.prepare.ExplainablePlan;
import org.apache.ignite.internal.sql.engine.prepare.Fragment;
import org.apache.ignite.internal.sql.engine.prepare.IgniteRelShuttle;
import org.apache.ignite.internal.sql.engine.prepare.KillPlan;
import org.apache.ignite.internal.sql.engine.prepare.MultiStepPlan;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite.internal.sql.engine.rel.IgniteIndexScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableModify;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableScan;
import org.apache.ignite.internal.sql.engine.rel.SourceAwareIgniteRel;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.schema.SqlSchemaManager;
import org.apache.ignite.internal.sql.engine.tx.QueryTransactionContext;
import org.apache.ignite.internal.sql.engine.tx.QueryTransactionWrapper;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.IteratorToDataCursorAdapter;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.AsyncCursor;
import org.apache.ignite.internal.util.AsyncWrapper;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ExecutionServiceImpl<RowT>
implements ExecutionService,
TopologyEventHandler {
    private static final int CACHE_SIZE = 1024;
    private static final IgniteLogger LOG = Loggers.forClass(ExecutionServiceImpl.class);
    private static final SqlQueryMessagesFactory FACTORY = new SqlQueryMessagesFactory();
    private static final List<InternalSqlRow> APPLIED_ANSWER = List.of(new InternalSqlRowSingleBoolean(true));
    private static final List<InternalSqlRow> NOT_APPLIED_ANSWER = List.of(new InternalSqlRowSingleBoolean(false));
    private static final FragmentDescription DUMMY_DESCRIPTION = new FragmentDescription(0L, true, (Long2ObjectMap<ColocationGroup>)Long2ObjectMaps.emptyMap(), null, null, null);
    private final ConcurrentMap<FragmentCacheKey, IgniteRel> physNodesCache = Caffeine.newBuilder().maximumSize(1024L).build().asMap();
    private final AtomicInteger executionTokenGen = new AtomicInteger();
    private final MessageService messageService;
    private final TopologyService topSrvc;
    private final ClusterNode localNode;
    private final SqlSchemaManager sqlSchemaManager;
    private final QueryTaskExecutor taskExecutor;
    private final MappingService mappingService;
    private final RowHandler<RowT> handler;
    private final DdlCommandHandler ddlCmdHnd;
    private final ExecutionDependencyResolver dependencyResolver;
    private final ExecutableTableRegistry tableRegistry;
    private final ImplementorFactory<RowT> implementorFactory;
    private final Map<ExecutionId, DistributedQueryManager> queryManagerMap = new ConcurrentHashMap<ExecutionId, DistributedQueryManager>();
    private final long shutdownTimeout;
    private final ClockService clockService;
    private final KillCommandHandler killCommandHandler;
    private final ExpressionFactory<RowT> expressionFactory;

    public ExecutionServiceImpl(MessageService messageService, TopologyService topSrvc, MappingService mappingService, SqlSchemaManager sqlSchemaManager, DdlCommandHandler ddlCmdHnd, QueryTaskExecutor taskExecutor, RowHandler<RowT> handler, ExecutableTableRegistry tableRegistry, ExecutionDependencyResolver dependencyResolver, ImplementorFactory<RowT> implementorFactory, ClockService clockService, KillCommandHandler killCommandHandler, ExpressionFactory<RowT> expressionFactory, long shutdownTimeout) {
        this.localNode = topSrvc.localMember();
        this.handler = handler;
        this.messageService = messageService;
        this.mappingService = mappingService;
        this.topSrvc = topSrvc;
        this.sqlSchemaManager = sqlSchemaManager;
        this.taskExecutor = taskExecutor;
        this.ddlCmdHnd = ddlCmdHnd;
        this.tableRegistry = tableRegistry;
        this.dependencyResolver = dependencyResolver;
        this.implementorFactory = implementorFactory;
        this.clockService = clockService;
        this.killCommandHandler = killCommandHandler;
        this.expressionFactory = expressionFactory;
        this.shutdownTimeout = shutdownTimeout;
    }

    public static <RowT> ExecutionServiceImpl<RowT> create(TopologyService topSrvc, MessageService msgSrvc, SqlSchemaManager sqlSchemaManager, DdlCommandHandler ddlCommandHandler, QueryTaskExecutor taskExecutor, RowHandler<RowT> handler, MailboxRegistry mailboxRegistry, ExchangeService exchangeSrvc, MappingService mappingService, ExecutableTableRegistry tableRegistry, ExecutionDependencyResolver dependencyResolver, TableFunctionRegistry tableFunctionRegistry, ClockService clockService, KillCommandHandler killCommandHandler, ExpressionFactory<RowT> expressionFactory, long shutdownTimeout) {
        return new ExecutionServiceImpl<RowT>(msgSrvc, topSrvc, mappingService, sqlSchemaManager, ddlCommandHandler, taskExecutor, handler, tableRegistry, dependencyResolver, (ctx, deps) -> new LogicalRelImplementor(ctx, mailboxRegistry, exchangeSrvc, deps, tableFunctionRegistry), clockService, killCommandHandler, expressionFactory, shutdownTimeout);
    }

    @Override
    public void start() {
        this.messageService.register((n, m) -> this.onMessage(n, (QueryStartRequest)m), (short)0);
        this.messageService.register((n, m) -> this.onMessage(n, (QueryStartResponse)m), (short)1);
        this.messageService.register((n, m) -> this.onMessage(n, (QueryCloseMessage)m), (short)5);
        this.messageService.register((n, m) -> this.onMessage(n, (ErrorMessage)m), (short)2);
    }

    @TestOnly
    public ExecutableTableRegistry tableRegistry() {
        return this.tableRegistry;
    }

    @TestOnly
    public DdlCommandHandler ddlCommandHandler() {
        return this.ddlCmdHnd;
    }

    private CompletableFuture<AsyncDataCursorExt<InternalSqlRow>> executeQuery(SqlOperationContext operationContext, MultiStepPlan plan) {
        ExecutionId executionid = this.nextExecutionId(operationContext.queryId());
        DistributedQueryManager queryManager = new DistributedQueryManager(executionid, this.localNode.name(), true, operationContext);
        DistributedQueryManager old = this.queryManagerMap.put(executionid, queryManager);
        assert (old == null);
        QueryCancel cancelHandler = operationContext.cancel();
        assert (cancelHandler != null);
        cancelHandler.add(timeout -> {
            AsyncDataCursorExt.CancellationReason reason = timeout ? AsyncDataCursorExt.CancellationReason.TIMEOUT : AsyncDataCursorExt.CancellationReason.CANCEL;
            queryManager.close(reason);
        });
        QueryTransactionContext txContext = operationContext.txContext();
        assert (txContext != null);
        boolean readOnly = plan.type().implicitTransactionReadOnlyMode();
        QueryTransactionWrapper txWrapper = txContext.getOrStartSqlManaged(readOnly, false);
        InternalTransaction tx = txWrapper.unwrap();
        operationContext.notifyTxUsed(txWrapper);
        SqlQueryProcessor.PrefetchCallback prefetchCallback = queryManager.prefetchCallback;
        CompletionStage<Void> firstPageReady = prefetchCallback.prefetchFuture();
        if (plan.type() == SqlQueryType.DML) {
            firstPageReady = firstPageReady.thenCompose(none -> txWrapper.commitImplicit());
        }
        CompletableFuture<Void> firstPageReady0 = firstPageReady;
        Predicate<String> nodeExclusionFilter = operationContext.nodeExclusionFilter();
        CompletionStage f = queryManager.execute(tx, plan, nodeExclusionFilter).thenApply(dataCursor -> new TxAwareAsyncCursor(txWrapper, dataCursor, firstPageReady0, x$0 -> queryManager.close((AsyncDataCursorExt.CancellationReason)((Object)((Object)x$0))), operationContext::notifyError));
        return ((CompletableFuture)f).whenComplete((r, t) -> {
            if (t != null) {
                txWrapper.rollback((Throwable)t);
            }
        });
    }

    private static SqlOperationContext createOperationContext(UUID queryId, ZoneId timeZoneId, Object[] params, HybridTimestamp operationTime) {
        return SqlOperationContext.builder().queryId(queryId).parameters(params).timeZoneId(timeZoneId).operationTime(operationTime).build();
    }

    private IgniteRel relationalTreeFromJsonString(int catalogVersion, String jsonFragment) {
        SchemaPlus rootSchema = this.sqlSchemaManager.schema(catalogVersion);
        return this.physNodesCache.computeIfAbsent(new FragmentCacheKey(catalogVersion, jsonFragment), key -> (IgniteRel)RelJsonReader.fromJson(rootSchema, key.fragmentString));
    }

    @Override
    public CompletableFuture<AsyncDataCursorExt<InternalSqlRow>> executePlan(QueryPlan plan, SqlOperationContext operationContext) {
        SqlQueryType queryType = plan.type();
        switch (queryType) {
            case DML: 
            case QUERY: {
                if (plan instanceof ExecutablePlan) {
                    return Commons.cast(CompletableFuture.completedFuture(this.executeExecutablePlan(operationContext, (ExecutablePlan)((Object)plan))));
                }
                assert (plan instanceof MultiStepPlan) : plan.getClass();
                return this.executeQuery(operationContext, (MultiStepPlan)plan);
            }
            case EXPLAIN: {
                return Commons.cast(CompletableFuture.completedFuture(this.executeExplain((ExplainPlan)plan)));
            }
            case DDL: {
                return Commons.cast(CompletableFuture.completedFuture(this.executeDdl(operationContext, (DdlPlan)plan)));
            }
            case KILL: {
                return Commons.cast(CompletableFuture.completedFuture(this.executeKill(operationContext, (KillPlan)plan)));
            }
        }
        throw new AssertionError((Object)("Unexpected query type: " + String.valueOf(plan)));
    }

    private AsyncDataCursor<InternalSqlRow> executeExecutablePlan(SqlOperationContext operationContext, ExecutablePlan plan) {
        AsyncWrapper dataCursor;
        QueryCancel queryCancel = operationContext.cancel();
        assert (queryCancel != null);
        ExecutionId executionId = this.nextExecutionId(operationContext.queryId());
        ExecutionContext<RowT> ectx = new ExecutionContext<RowT>(this.expressionFactory, this.taskExecutor, executionId, this.localNode, this.localNode.name(), DUMMY_DESCRIPTION, this.handler, Commons.parametersMap(operationContext.parameters()), TxAttributes.dummy(), operationContext.timeZoneId(), operationContext.cancel());
        QueryTransactionContext txContext = operationContext.txContext();
        assert (txContext != null);
        ExplainablePlan queryPlan = (ExplainablePlan)((Object)plan);
        boolean readOnly = queryPlan.type().implicitTransactionReadOnlyMode();
        QueryTransactionWrapper txWrapper = txContext.getOrStartSqlManaged(readOnly, true);
        operationContext.notifyTxUsed(txWrapper);
        SqlQueryProcessor.PrefetchCallback prefetchCallback = new SqlQueryProcessor.PrefetchCallback();
        try {
            dataCursor = plan.execute(ectx, txWrapper.unwrap(), this.tableRegistry, prefetchCallback);
        }
        catch (Throwable t) {
            prefetchCallback.onPrefetchComplete(t);
            dataCursor = new AsyncWrapper(CompletableFuture.failedFuture(t), Runnable::run);
        }
        return new TxAwareAsyncCursor<InternalSqlRow>(txWrapper, (AsyncCursor<InternalSqlRow>)dataCursor, prefetchCallback.prefetchFuture(), reason -> CompletableFutures.nullCompletedFuture(), operationContext::notifyError);
    }

    private AsyncDataCursor<InternalSqlRow> executeDdl(SqlOperationContext operationContext, DdlPlan plan) {
        CompletionStage ret = ((CompletableFuture)this.ddlCmdHnd.handle(plan.command()).thenApply(activationTime -> {
            if (activationTime == null) {
                return NOT_APPLIED_ANSWER.iterator();
            }
            QueryTransactionContext txCtx = operationContext.txContext();
            assert (txCtx != null);
            txCtx.updateObservableTime(HybridTimestamp.hybridTimestamp((long)activationTime));
            return APPLIED_ANSWER.iterator();
        })).exceptionally(th -> {
            throw ExecutionServiceImpl.convertDdlException(th);
        });
        QueryCancel queryCancel = operationContext.cancel();
        assert (queryCancel != null);
        queryCancel.add(arg_0 -> ExecutionServiceImpl.lambda$executeDdl$14((CompletableFuture)ret, arg_0));
        return new IteratorToDataCursorAdapter<InternalSqlRow>((CompletableFuture<Iterator<InternalSqlRow>>)ret, Runnable::run);
    }

    private AsyncDataCursor<InternalSqlRow> executeKill(SqlOperationContext operationContext, KillPlan plan) {
        KillCommand cmd = plan.command();
        CompletionStage ret = ((CompletableFuture)this.killCommandHandler.handle(cmd).thenApply(cancelled -> (cancelled != false ? APPLIED_ANSWER : NOT_APPLIED_ANSWER).iterator())).exceptionally(th -> {
            Throwable e = ExceptionUtils.unwrapCause((Throwable)th);
            if (e instanceof IgniteInternalCheckedException) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Failed to execute KILL statement [command=" + String.valueOf(cmd) + ", err=" + e.getMessage() + "]", e);
            }
            throw e instanceof RuntimeException ? (RuntimeException)e : new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, e);
        });
        QueryCancel queryCancel = operationContext.cancel();
        assert (queryCancel != null);
        queryCancel.add(arg_0 -> ExecutionServiceImpl.lambda$executeKill$17((CompletableFuture)ret, arg_0));
        return new IteratorToDataCursorAdapter<InternalSqlRow>((CompletableFuture<Iterator<InternalSqlRow>>)ret, Runnable::run);
    }

    private static RuntimeException convertDdlException(Throwable e) {
        if ((e = ExceptionUtils.unwrapCause((Throwable)e)) instanceof ConfigurationChangeException) {
            assert (e.getCause() != null);
            e = e.getCause();
        }
        if (e instanceof IgniteInternalCheckedException) {
            return new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Failed to execute DDL statement [stmt=, err=" + e.getMessage() + "]", e);
        }
        return e instanceof RuntimeException ? (RuntimeException)e : new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, e);
    }

    private AsyncDataCursor<InternalSqlRow> executeExplain(ExplainPlan plan) {
        String planString = plan.plan().explain();
        InternalSqlRowSingleString res = new InternalSqlRowSingleString(planString);
        return new IteratorToDataCursorAdapter<InternalSqlRow>(List.of(res).iterator());
    }

    private void onMessage(String nodeName, QueryStartRequest msg) {
        assert (nodeName != null && msg != null);
        CompletableFuture<Void> fut = this.sqlSchemaManager.schemaReadyFuture(msg.catalogVersion());
        if (fut.isDone()) {
            this.submitFragment(nodeName, msg);
        } else {
            fut.whenComplete((mgr, ex) -> {
                if (ex != null) {
                    this.handleError((Throwable)ex, nodeName, msg);
                    return;
                }
                this.taskExecutor.execute(msg.queryId(), msg.fragmentId(), () -> this.submitFragment(nodeName, msg));
            });
        }
    }

    private void onMessage(String nodeName, QueryStartResponse msg) {
        assert (nodeName != null && msg != null);
        DistributedQueryManager dqm = this.queryManagerMap.get(new ExecutionId(msg.queryId(), msg.executionToken()));
        if (dqm != null) {
            dqm.acknowledgeFragment(nodeName, msg.fragmentId(), msg.error());
        }
    }

    private void onMessage(String nodeName, ErrorMessage msg) {
        assert (nodeName != null && msg != null);
        DistributedQueryManager dqm = this.queryManagerMap.get(new ExecutionId(msg.queryId(), msg.executionToken()));
        if (dqm != null) {
            RemoteFragmentExecutionException e = new RemoteFragmentExecutionException(nodeName, msg.queryId(), msg.fragmentId(), msg.traceId(), msg.code(), msg.message());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Query remote fragment execution failed [nodeName={}, queryId={}, fragmentId={}, originalMessage={}]", new Object[]{nodeName, e.queryId(), e.fragmentId(), e.getMessage()});
            }
            dqm.onError(e);
        }
    }

    private void onMessage(String nodeName, QueryCloseMessage msg) {
        assert (nodeName != null && msg != null);
        DistributedQueryManager dqm = this.queryManagerMap.get(new ExecutionId(msg.queryId(), msg.executionToken()));
        if (dqm != null) {
            dqm.close(AsyncDataCursorExt.CancellationReason.CANCEL);
        }
    }

    @Override
    public void stop() throws Exception {
        CompletableFuture<Void> f = CompletableFuture.allOf((CompletableFuture[])this.queryManagerMap.values().stream().filter(mgr -> mgr.rootFragmentId != null).map(mgr -> mgr.close(AsyncDataCursorExt.CancellationReason.CANCEL)).toArray(CompletableFuture[]::new));
        try {
            f.get(this.shutdownTimeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            String message = IgniteStringFormatter.format((String)"SQL execution service could not be stopped within the specified timeout ({} ms).", (Object[])new Object[]{this.shutdownTimeout});
            LOG.warn(message + this.dumpDebugInfo() + ExecutionServiceImpl.dumpThreads(), new Object[0]);
        }
        catch (CancellationException e) {
            LOG.warn("The stop future was cancelled, going to proceed the stop procedure", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("The stop future was interrupted, going to proceed the stop procedure", (Throwable)e);
        }
    }

    public void onDisappeared(ClusterNode member) {
        this.queryManagerMap.values().forEach(qm -> qm.onNodeLeft(member.name()));
    }

    @TestOnly
    public List<AbstractNode<?>> localFragments(UUID queryId) {
        return this.queryManagerMap.entrySet().stream().filter(e -> ((ExecutionId)e.getKey()).queryId().equals(queryId)).flatMap(e -> ((DistributedQueryManager)e.getValue()).localFragments().stream()).collect(Collectors.toList());
    }

    private void submitFragment(String nodeName, QueryStartRequest msg) {
        DistributedQueryManager queryManager = this.getOrCreateQueryManager(nodeName, msg);
        queryManager.submitFragment(nodeName, msg.catalogVersion(), msg.root(), msg.fragmentDescription(), msg.txAttributes());
    }

    private void handleError(Throwable ex, String nodeName, QueryStartRequest msg) {
        DistributedQueryManager queryManager = this.getOrCreateQueryManager(nodeName, msg);
        queryManager.handleError(ex, nodeName, msg.fragmentDescription().fragmentId());
    }

    private DistributedQueryManager getOrCreateQueryManager(String coordinatorNodeName, QueryStartRequest msg) {
        return this.queryManagerMap.computeIfAbsent(new ExecutionId(msg.queryId(), msg.executionToken()), key -> {
            SqlOperationContext operationContext = ExecutionServiceImpl.createOperationContext(key.queryId(), ZoneId.of(msg.timeZoneId()), msg.parameters(), msg.operationTime());
            return new DistributedQueryManager((ExecutionId)key, coordinatorNodeName, operationContext);
        });
    }

    String dumpDebugInfo() {
        IgniteStringBuilder buf = new IgniteStringBuilder();
        for (Map.Entry<ExecutionId, DistributedQueryManager> entry : this.queryManagerMap.entrySet()) {
            List localFragments;
            ExecutionId executionId = entry.getKey();
            DistributedQueryManager mgr = entry.getValue();
            buf.nl();
            buf.app("Debug info for query: ").app((Object)executionId).app(" (canceled=").app(mgr.cancelled.get()).app(", stopped=").app(mgr.cancelFut.isDone()).app(")");
            buf.nl();
            buf.app("  Coordinator node: ").app(mgr.coordinatorNodeName);
            if (mgr.coordinator) {
                buf.app(" (current node)");
            }
            buf.nl();
            CompletableFuture rootNodeFut = mgr.root;
            if (rootNodeFut != null) {
                buf.app("  Root node state: ");
                try {
                    AsyncRootNode rootNode = rootNodeFut.getNow(null);
                    if (rootNode != null) {
                        if (rootNode.isClosed()) {
                            buf.app("closed");
                        } else {
                            buf.app("opened");
                        }
                    } else {
                        buf.app("absent");
                    }
                }
                catch (CompletionException ex) {
                    buf.app("completed exceptionally ").app('(').app((Object)ExceptionUtils.unwrapCause((Throwable)ex)).app(')');
                }
                catch (CancellationException ex) {
                    buf.app("canceled");
                }
                buf.nl();
            }
            buf.nl();
            List initFragments = mgr.remoteFragmentInitCompletion.entrySet().stream().filter(entry0 -> !((CompletableFuture)entry0.getValue()).isDone()).map(Map.Entry::getKey).sorted(Comparator.comparingLong(RemoteFragmentKey::fragmentId)).collect(Collectors.toList());
            if (!initFragments.isEmpty()) {
                buf.app("  Fragments awaiting init completion:").nl();
                for (RemoteFragmentKey fragmentKey : initFragments) {
                    buf.app("    id=").app(fragmentKey.fragmentId()).app(", node=").app(fragmentKey.nodeName());
                    buf.nl();
                }
                buf.nl();
            }
            if ((localFragments = mgr.localFragments().stream().sorted(Comparator.comparingLong(n -> n.context().fragmentId())).collect(Collectors.toList())).isEmpty()) continue;
            buf.app("  Local fragments:").nl();
            for (AbstractNode fragment : localFragments) {
                long fragmentId = fragment.context().fragmentId();
                buf.app("    id=").app(fragmentId).app(", state=").app(fragment.isClosed() ? "closed" : "opened").app(", canceled=").app(fragment.context().isCancelled()).app(", class=").app(fragment.getClass().getSimpleName());
                Long rootFragmentId = mgr.rootFragmentId;
                if (rootFragmentId != null && rootFragmentId == fragmentId) {
                    buf.app("  (root)");
                }
                buf.nl();
            }
        }
        return buf.length() > 0 ? buf.toString() : " No debug information available.";
    }

    private static String dumpThreads() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] infos = bean.dumpAllThreads(true, true);
        IgniteStringBuilder buf = new IgniteStringBuilder();
        buf.nl().nl().app("Dumping threads:").nl().nl();
        for (ThreadInfo info : infos) {
            buf.app(info.toString()).nl();
        }
        return buf.toString();
    }

    private ExecutionId nextExecutionId(UUID queryId) {
        return new ExecutionId(queryId, this.executionTokenGen.getAndIncrement());
    }

    private static /* synthetic */ void lambda$executeKill$17(CompletableFuture ret, boolean timeout) {
        if (timeout) {
            ret.completeExceptionally((Throwable)((Object)new QueryCancelledException("Query timeout")));
        }
    }

    private static /* synthetic */ void lambda$executeDdl$14(CompletableFuture ret, boolean timeout) {
        if (timeout) {
            ret.completeExceptionally((Throwable)((Object)new QueryCancelledException("Query timeout")));
        }
    }

    @FunctionalInterface
    public static interface ImplementorFactory<RowT> {
        public LogicalRelImplementor<RowT> create(ExecutionContext<RowT> var1, ResolvedDependencies var2);
    }

    private class DistributedQueryManager {
        private final ExecutionId executionId;
        private final boolean coordinator;
        private final String coordinatorNodeName;
        private final SqlOperationContext ctx;
        private final CompletableFuture<Void> cancelFut = new CompletableFuture();
        private final SqlQueryProcessor.PrefetchCallback prefetchCallback = new SqlQueryProcessor.PrefetchCallback();
        private final AtomicBoolean cancelled = new AtomicBoolean();
        private final Map<RemoteFragmentKey, CompletableFuture<Void>> remoteFragmentInitCompletion = new HashMap<RemoteFragmentKey, CompletableFuture<Void>>();
        private final Queue<AbstractNode<RowT>> localFragments = new ConcurrentLinkedQueue();
        @Nullable
        private final CompletableFuture<AsyncRootNode<RowT, InternalSqlRow>> root;
        @Nullable
        private final QueryCancel cancel;
        private final Object initMux = new Object();
        private volatile Long rootFragmentId = null;

        private DistributedQueryManager(ExecutionId executionId, String coordinatorNodeName, boolean coordinator, SqlOperationContext ctx) {
            this.executionId = executionId;
            this.ctx = ctx;
            this.coordinator = coordinator;
            this.coordinatorNodeName = coordinatorNodeName;
            if (coordinator) {
                CompletableFuture root = new CompletableFuture();
                root.exceptionally(t -> {
                    this.close(AsyncDataCursorExt.CancellationReason.CANCEL);
                    return null;
                });
                this.root = root;
                this.cancel = ctx.cancel();
            } else {
                this.root = null;
                this.cancel = null;
            }
        }

        private DistributedQueryManager(ExecutionId executionId, String coordinatorNodeName, SqlOperationContext ctx) {
            this(executionId, coordinatorNodeName, false, ctx);
        }

        private List<AbstractNode<?>> localFragments() {
            return List.copyOf(this.localFragments);
        }

        private CompletableFuture<Void> sendFragment(String targetNodeName, String serialisedFragment, FragmentDescription desc, TxAttributes txAttributes, int catalogVersion) {
            QueryStartRequest request = FACTORY.queryStartRequest().queryId(this.executionId.queryId()).executionToken(this.executionId.executionToken()).fragmentId(desc.fragmentId()).root(serialisedFragment).fragmentDescription(desc).parameters(this.ctx.parameters()).txAttributes(txAttributes).catalogVersion(catalogVersion).timeZoneId(this.ctx.timeZoneId().getId()).operationTime(this.ctx.operationTime()).timestamp(ExecutionServiceImpl.this.clockService.now()).build();
            return ExecutionServiceImpl.this.messageService.send(targetNodeName, request);
        }

        private void acknowledgeFragment(String nodeName, long fragmentId, @Nullable Throwable ex) {
            if (ex != null) {
                Long rootFragmentId0 = this.rootFragmentId;
                if (rootFragmentId0 != null && fragmentId == rootFragmentId0) {
                    this.root.completeExceptionally(ex);
                } else {
                    this.root.thenAccept(root -> {
                        root.onError(ex);
                        this.close(AsyncDataCursorExt.CancellationReason.CANCEL);
                    });
                }
            }
            this.remoteFragmentInitCompletion.get(new RemoteFragmentKey(nodeName, fragmentId)).complete(null);
        }

        private void onError(RemoteFragmentExecutionException ex) {
            this.root.thenAccept(root -> {
                root.onError((Throwable)((Object)ex));
                this.close(AsyncDataCursorExt.CancellationReason.CANCEL);
            });
        }

        private void onNodeLeft(String nodeName) {
            this.remoteFragmentInitCompletion.entrySet().stream().filter(e -> nodeName.equals(((RemoteFragmentKey)e.getKey()).nodeName())).forEach(e -> ((CompletableFuture)e.getValue()).completeExceptionally((Throwable)((Object)new NodeLeftException(nodeName))));
        }

        private CompletableFuture<Void> executeFragment(IgniteRel treeRoot, ResolvedDependencies deps, ExecutionContext<RowT> ectx) {
            String origNodeName = ectx.originatingNodeName();
            AbstractNode node = (AbstractNode)ExecutionServiceImpl.this.implementorFactory.create(ectx, deps).go(treeRoot);
            this.localFragments.add(node);
            if (!(node instanceof Outbox)) {
                BiFunction<Integer, Object, Object> internalTypeConverter = TypeUtils.resultTypeConverter(ectx, treeRoot.getRowType());
                AsyncRootNode<Object, InternalSqlRow> rootNode = new AsyncRootNode<Object, InternalSqlRow>(node, inRow -> new InternalSqlRowImpl<Object>(inRow, ectx.rowHandler(), internalTypeConverter));
                node.onRegister(rootNode);
                rootNode.startPrefetch().whenCompleteAsync((res, err) -> this.prefetchCallback.onPrefetchComplete((Throwable)err), (Executor)ExecutionServiceImpl.this.taskExecutor);
                assert (this.root != null);
                this.root.complete(rootNode);
            }
            CompletableFuture<Void> sendingResult = ExecutionServiceImpl.this.messageService.send(origNodeName, FACTORY.queryStartResponse().queryId(ectx.queryId()).executionToken(ectx.executionToken()).fragmentId(ectx.fragmentId()).build());
            if (node instanceof Outbox) {
                ((Outbox)node).prefetch();
            }
            return sendingResult;
        }

        private ExecutionContext<RowT> createContext(String initiatorNodeName, FragmentDescription desc, TxAttributes txAttributes) {
            return new ExecutionContext(ExecutionServiceImpl.this.expressionFactory, ExecutionServiceImpl.this.taskExecutor, this.executionId, ExecutionServiceImpl.this.localNode, initiatorNodeName, desc, ExecutionServiceImpl.this.handler, Commons.parametersMap(this.ctx.parameters()), txAttributes, this.ctx.timeZoneId(), this.cancel);
        }

        private void submitFragment(String initiatorNode, int catalogVersion, String fragmentString, FragmentDescription desc, TxAttributes txAttributes) {
            try {
                ExecutionContext context = this.createContext(initiatorNode, desc, txAttributes);
                IgniteRel treeRoot = ExecutionServiceImpl.this.relationalTreeFromJsonString(catalogVersion, fragmentString);
                ResolvedDependencies resolvedDependencies = ExecutionServiceImpl.this.dependencyResolver.resolveDependencies(List.of(treeRoot), catalogVersion);
                this.executeFragment(treeRoot, resolvedDependencies, context).exceptionally(ex -> {
                    this.handleError((Throwable)ex, initiatorNode, desc.fragmentId());
                    return null;
                });
            }
            catch (Throwable ex2) {
                this.handleError(ex2, initiatorNode, desc.fragmentId());
            }
        }

        private void handleError(Throwable ex, String initiatorNode, long fragmentId) {
            LOG.debug("Unable to start query fragment", ex);
            try {
                ExecutionServiceImpl.this.messageService.send(initiatorNode, FACTORY.queryStartResponse().queryId(this.executionId.queryId()).executionToken(this.executionId.executionToken()).fragmentId(fragmentId).error(ex).build());
            }
            catch (Exception e) {
                LOG.info("Unable to send error message", (Throwable)e);
                this.close(AsyncDataCursorExt.CancellationReason.CANCEL);
            }
        }

        private CompletableFuture<AsyncCursor<InternalSqlRow>> execute(InternalTransaction tx, MultiStepPlan multiStepPlan, @Nullable Predicate<String> nodeExclusionFilter) {
            assert (this.root != null);
            boolean mapOnBackups = tx.isReadOnly();
            MappingParameters mappingParameters = MappingParameters.create(this.ctx.parameters(), mapOnBackups, nodeExclusionFilter);
            return ((CompletableFuture)ExecutionServiceImpl.this.mappingService.map(multiStepPlan, mappingParameters).thenComposeAsync(mappedFragments -> this.sendFragments(tx, multiStepPlan, (List<MappedFragment>)mappedFragments), (Executor)ExecutionServiceImpl.this.taskExecutor)).thenApply(this::wrapRootNode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CompletableFuture<AsyncCursor<InternalSqlRow>> sendFragments(InternalTransaction tx, MultiStepPlan multiStepPlan, List<MappedFragment> mappedFragments) {
            assert (!CollectionUtils.nullOrEmpty(mappedFragments) && mappedFragments.get(0).fragment().rootFragment()) : mappedFragments;
            if (!tx.isReadOnly()) {
                for (MappedFragment mappedFragment : mappedFragments) {
                    this.enlistPartitions(mappedFragment, tx);
                }
            }
            Object object = this.initMux;
            synchronized (object) {
                QueryCancel queryCancel = this.ctx.cancel();
                if (queryCancel != null) {
                    queryCancel.throwIfCancelled();
                }
                for (MappedFragment mappedFragment : mappedFragments) {
                    if (mappedFragment.fragment().rootFragment()) {
                        assert (this.rootFragmentId == null);
                        this.rootFragmentId = mappedFragment.fragment().fragmentId();
                    }
                    for (String nodeName : mappedFragment.nodes()) {
                        this.remoteFragmentInitCompletion.put(new RemoteFragmentKey(nodeName, mappedFragment.fragment().fragmentId()), new CompletableFuture());
                    }
                }
            }
            TxAttributes attributes = TxAttributes.fromTx(tx);
            ArrayList<CompletableFuture<Void>> resultsOfFragmentSending = new ArrayList<CompletableFuture<Void>>();
            for (MappedFragment mappedFragment : mappedFragments) {
                Fragment fragment = mappedFragment.fragment();
                FragmentDescription fragmentDesc = new FragmentDescription(fragment.fragmentId(), !fragment.correlated(), mappedFragment.groupsBySourceId(), mappedFragment.target(), mappedFragment.sourcesByExchangeId(), mappedFragment.partitionPruningMetadata());
                for (String nodeName : mappedFragment.nodes()) {
                    CompletableFuture<Void> resultOfSending = this.sendFragment(nodeName, fragment.serialized(), fragmentDesc, attributes, multiStepPlan.catalogVersion());
                    resultOfSending.whenComplete((ignored, t) -> {
                        if (t == null) {
                            return;
                        }
                        CompletableFuture<Void> completionFuture = this.remoteFragmentInitCompletion.get(new RemoteFragmentKey(nodeName, fragment.fragmentId()));
                        if (completionFuture != null) {
                            completionFuture.complete(null);
                        }
                    });
                    resultsOfFragmentSending.add(resultOfSending);
                }
            }
            return ((CompletableFuture)CompletableFutures.allOf(resultsOfFragmentSending).handle((ignoredVal, ignoredTh) -> {
                if (ignoredTh == null) {
                    return this.root;
                }
                Throwable error = Commons.deriveExceptionFromListOfFutures(resultsOfFragmentSending);
                assert (error != null);
                return ((CompletableFuture)CompletableFutures.allOf(this.remoteFragmentInitCompletion.values()).thenCompose(none -> {
                    if (!this.root.completeExceptionally(error)) {
                        this.root.thenAccept(root -> root.onError(error));
                        this.close(AsyncDataCursorExt.CancellationReason.CANCEL);
                    }
                    return this.cancelFut.thenRun(() -> ExceptionUtils.sneakyThrow((Throwable)error));
                })).thenCompose(none -> this.root);
            })).thenCompose(Commons::cast);
        }

        private void enlistPartitions(final MappedFragment mappedFragment, final InternalTransaction tx) {
            if (mappedFragment.fragment().tables().isEmpty()) {
                return;
            }
            new IgniteRelShuttle(){

                @Override
                public IgniteRel visit(IgniteIndexScan rel) {
                    this.enlist(rel);
                    return super.visit(rel);
                }

                @Override
                public IgniteRel visit(IgniteTableScan rel) {
                    this.enlist(rel);
                    return super.visit(rel);
                }

                @Override
                public IgniteRel visit(IgniteTableModify rel) {
                    this.enlist(rel);
                    return super.visit(rel);
                }

                private void enlist(int tableId, Int2ObjectMap<NodeWithConsistencyToken> assignments) {
                    if (assignments.isEmpty()) {
                        return;
                    }
                    int partsCnt = assignments.size();
                    tx.assignCommitPartition(new TablePartitionId(tableId, ThreadLocalRandom.current().nextInt(partsCnt)));
                    for (Map.Entry partWithToken : assignments.int2ObjectEntrySet()) {
                        TablePartitionId tablePartId = new TablePartitionId(tableId, ((Integer)partWithToken.getKey()).intValue());
                        NodeWithConsistencyToken assignment = (NodeWithConsistencyToken)partWithToken.getValue();
                        tx.enlist(tablePartId, new IgniteBiTuple((Object)ExecutionServiceImpl.this.topSrvc.getByConsistentId(assignment.name()), (Object)assignment.enlistmentConsistencyToken()));
                    }
                }

                private void enlist(SourceAwareIgniteRel rel) {
                    int tableId = ((IgniteTable)rel.getTable().unwrap(IgniteTable.class)).id();
                    ColocationGroup colocationGroup = (ColocationGroup)mappedFragment.groupsBySourceId().get(rel.sourceId());
                    Int2ObjectMap<NodeWithConsistencyToken> assignments = colocationGroup.assignments();
                    this.enlist(tableId, assignments);
                }
            }.visit(mappedFragment.fragment().root());
        }

        private CompletableFuture<Void> close(AsyncDataCursorExt.CancellationReason reason) {
            if (!this.cancelled.compareAndSet(false, true)) {
                return this.cancelFut;
            }
            CompletableFuture<Void> start = new CompletableFuture<Void>();
            CompletionStage stage = this.coordinator ? ((CompletableFuture)start.thenCompose(ignored -> this.closeRootNode(reason))).thenCompose(ignored -> this.awaitFragmentInitialisationAndClose()) : ((CompletableFuture)start.thenCompose(ignored -> ExecutionServiceImpl.this.messageService.send(this.coordinatorNodeName, FACTORY.queryCloseMessage().queryId(this.executionId.queryId()).executionToken(this.executionId.executionToken()).build()))).thenCompose(ignored -> this.closeLocalFragments());
            ((CompletableFuture)((CompletableFuture)stage).whenComplete((r, e) -> {
                if (e != null) {
                    Throwable ex = ExceptionUtils.unwrapCause((Throwable)e);
                    LOG.warn("Fragment closing processed with errors: [queryId={}]", ex, new Object[]{this.ctx.queryId()});
                }
                ExecutionServiceImpl.this.queryManagerMap.remove(this.executionId);
                this.cancelFut.complete(null);
            })).thenRun(() -> this.localFragments.forEach(f -> f.context().cancel()));
            start.completeAsync(() -> null, ExecutionServiceImpl.this.taskExecutor);
            return this.cancelFut;
        }

        private CompletableFuture<Void> closeLocalFragments() {
            ArrayList localFragmentCompletions = new ArrayList();
            for (AbstractNode abstractNode : this.localFragments) {
                assert (!abstractNode.context().isCancelled()) : "node context is cancelled, but node still processed";
                localFragmentCompletions.add(abstractNode.context().submit(abstractNode::close, abstractNode::onError));
            }
            return CompletableFuture.allOf(localFragmentCompletions.toArray(new CompletableFuture[0]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CompletableFuture<Void> awaitFragmentInitialisationAndClose() {
            HashMap<String, List> requestsPerNode = new HashMap<String, List>();
            Object object = this.initMux;
            synchronized (object) {
                for (Map.Entry<RemoteFragmentKey, CompletableFuture<Void>> entry : this.remoteFragmentInitCompletion.entrySet()) {
                    requestsPerNode.computeIfAbsent(entry.getKey().nodeName(), key -> new ArrayList()).add(entry.getValue());
                }
            }
            ArrayList<CompletionStage> cancelFuts = new ArrayList<CompletionStage>();
            for (Map.Entry<RemoteFragmentKey, CompletableFuture<Void>> entry : requestsPerNode.entrySet()) {
                String nodeId = (String)((Object)entry.getKey());
                cancelFuts.add(((CompletableFuture)CompletableFuture.allOf(((List)((Object)entry.getValue())).toArray(new CompletableFuture[0])).handle((none2, t) -> null)).thenCompose(ignored -> {
                    if (ExecutionServiceImpl.this.localNode.name().equals(nodeId)) {
                        return this.closeLocalFragments();
                    }
                    return ExecutionServiceImpl.this.messageService.send(nodeId, FACTORY.queryCloseMessage().queryId(this.executionId.queryId()).executionToken(this.executionId.executionToken()).build());
                }));
            }
            return CompletableFuture.allOf(cancelFuts.toArray(new CompletableFuture[0]));
        }

        private CompletableFuture<Void> closeRootNode(AsyncDataCursorExt.CancellationReason closeReason) {
            assert (this.root != null);
            String message = closeReason == AsyncDataCursorExt.CancellationReason.TIMEOUT ? "Query timeout" : "The query was cancelled while executing.";
            if (!this.root.isDone()) {
                this.root.completeExceptionally((Throwable)((Object)new QueryCancelledException(message)));
            }
            if (!this.root.isCompletedExceptionally()) {
                AsyncRootNode node = this.root.getNow(null);
                if (closeReason != AsyncDataCursorExt.CancellationReason.CLOSE) {
                    node.onError((Throwable)((Object)new QueryCancelledException(message)));
                }
                return node.closeAsync();
            }
            return CompletableFutures.nullCompletedFuture();
        }

        private AsyncCursor<InternalSqlRow> wrapRootNode(final AsyncCursor<InternalSqlRow> cursor) {
            return new AsyncCursor<InternalSqlRow>(){

                public CompletableFuture<AsyncCursor.BatchedResult<InternalSqlRow>> requestNextAsync(int rows) {
                    CompletableFuture fut = cursor.requestNextAsync(rows);
                    fut.thenAccept(batch -> {
                        if (!batch.hasMore()) {
                            DistributedQueryManager.this.close(AsyncDataCursorExt.CancellationReason.CLOSE);
                        }
                    });
                    return fut;
                }

                public CompletableFuture<Void> closeAsync() {
                    return DistributedQueryManager.this.close(AsyncDataCursorExt.CancellationReason.CLOSE);
                }
            };
        }
    }

    private static class FragmentCacheKey {
        private final int catalogVersion;
        private final String fragmentString;

        FragmentCacheKey(int catalogVersion, String fragmentString) {
            this.catalogVersion = catalogVersion;
            this.fragmentString = fragmentString;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FragmentCacheKey that = (FragmentCacheKey)o;
            return this.catalogVersion == that.catalogVersion && this.fragmentString.equals(that.fragmentString);
        }

        public int hashCode() {
            return Objects.hash(this.catalogVersion, this.fragmentString);
        }
    }
}

