/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.LocalTime;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.calcite.DataContext;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.linq4j.function.NonDeterministic;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.IgniteMath;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public class IgniteSqlFunctions {
    private IgniteSqlFunctions() {
    }

    public static String toString(BigDecimal x) {
        return x == null ? null : x.toPlainString();
    }

    public static String toString(ByteString b) {
        return b == null ? null : new String(b.getBytes(), Commons.typeFactory().getDefaultCharset());
    }

    public static int length(Object b) {
        return b instanceof ByteString ? SqlFunctions.octetLength((ByteString)((ByteString)b)) : SqlFunctions.charLength((String)((String)b));
    }

    public static int octetLength(ByteString s) {
        return s.length();
    }

    public static int octetLength(String s) {
        return s.getBytes().length;
    }

    public static byte sround(byte b0) {
        return IgniteSqlFunctions.sround(b0, 0);
    }

    public static byte sround(byte b0, int b1) {
        return (byte)IgniteSqlFunctions.sround((int)b0, b1);
    }

    public static byte sround(short b0) {
        return (byte)IgniteSqlFunctions.sround(b0, 0);
    }

    public static short sround(short b0, int b1) {
        return (short)IgniteSqlFunctions.sround((int)b0, b1);
    }

    public static int sround(int b0) {
        return IgniteSqlFunctions.sround(b0, 0);
    }

    public static int sround(int b0, int b1) {
        if (b1 == 0) {
            return b0;
        }
        if (b1 > 0) {
            return b0;
        }
        return (int)IgniteSqlFunctions.sround((long)b0, b1);
    }

    public static long sround(long b0) {
        return IgniteSqlFunctions.sround(b0, 0);
    }

    public static long sround(long b0, int b1) {
        if (b1 == 0) {
            return b0;
        }
        if (b1 > 0) {
            return b0;
        }
        long abs = (long)Math.pow(10.0, Math.abs(b1));
        return IgniteSqlFunctions.divide(b0, abs, RoundingMode.HALF_UP) * abs;
    }

    public static double sround(double b0) {
        return IgniteSqlFunctions.sround(BigDecimal.valueOf(b0)).doubleValue();
    }

    public static double sround(double b0, int b1) {
        return IgniteSqlFunctions.sround(BigDecimal.valueOf(b0), b1).doubleValue();
    }

    public static float sround(float b0) {
        return IgniteSqlFunctions.sround(BigDecimal.valueOf(b0)).floatValue();
    }

    public static float sround(float b0, int b1) {
        return IgniteSqlFunctions.sround(BigDecimal.valueOf(b0), b1).floatValue();
    }

    public static BigDecimal sround(BigDecimal b0) {
        return b0.setScale(0, RoundingMode.HALF_UP);
    }

    public static BigDecimal sround(BigDecimal b0, int b1) {
        int originalScale = b0.scale();
        if (b1 >= originalScale) {
            return b0;
        }
        BigDecimal roundedValue = b0.setScale(b1, RoundingMode.HALF_UP);
        return roundedValue.setScale(originalScale, RoundingMode.UNNECESSARY);
    }

    public static byte struncate(byte b0) {
        return IgniteSqlFunctions.struncate(b0, 0);
    }

    public static byte struncate(byte b0, int b1) {
        return (byte)IgniteSqlFunctions.struncate((int)b0, b1);
    }

    public static byte struncate(short b0) {
        return (byte)IgniteSqlFunctions.struncate(b0, 0);
    }

    public static short struncate(short b0, int b1) {
        return (short)IgniteSqlFunctions.struncate((int)b0, b1);
    }

    public static int struncate(int b0) {
        return IgniteSqlFunctions.sround(b0, 0);
    }

    public static int struncate(int b0, int b1) {
        if (b1 == 0) {
            return b0;
        }
        if (b1 > 0) {
            return b0;
        }
        return (int)IgniteSqlFunctions.struncate((long)b0, b1);
    }

    public static long struncate(long b0) {
        return IgniteSqlFunctions.sround(b0, 0);
    }

    public static long struncate(long b0, int b1) {
        if (b1 == 0) {
            return b0;
        }
        if (b1 > 0) {
            return b0;
        }
        long abs = (long)Math.pow(10.0, Math.abs(b1));
        return IgniteSqlFunctions.divide(b0, abs, RoundingMode.DOWN) * abs;
    }

    public static double struncate(double b0) {
        return IgniteSqlFunctions.struncate(BigDecimal.valueOf(b0)).doubleValue();
    }

    public static double struncate(double b0, int b1) {
        return IgniteSqlFunctions.struncate(BigDecimal.valueOf(b0), b1).doubleValue();
    }

    public static float struncate(float b0) {
        return IgniteSqlFunctions.struncate(BigDecimal.valueOf(b0)).floatValue();
    }

    public static float struncate(float b0, int b1) {
        return IgniteSqlFunctions.struncate(BigDecimal.valueOf(b0), b1).floatValue();
    }

    public static BigDecimal struncate(BigDecimal b0) {
        return b0.setScale(0, RoundingMode.DOWN);
    }

    public static BigDecimal struncate(BigDecimal b0, int b1) {
        int originalScale = b0.scale();
        if (b1 >= originalScale) {
            return b0;
        }
        BigDecimal roundedValue = b0.setScale(b1, RoundingMode.DOWN);
        return roundedValue.setScale(originalScale, RoundingMode.UNNECESSARY);
    }

    public static BigDecimal toBigDecimal(double val, int precision, int scale) {
        return IgniteSqlFunctions.toBigDecimal((Number)val, precision, scale);
    }

    public static BigDecimal toBigDecimal(float val, int precision, int scale) {
        return IgniteSqlFunctions.toBigDecimal(Float.valueOf(val), precision, scale);
    }

    public static BigDecimal toBigDecimal(long val, int precision, int scale) {
        BigDecimal decimal = BigDecimal.valueOf(val);
        return IgniteSqlFunctions.toBigDecimal(decimal, precision, scale);
    }

    public static BigDecimal toBigDecimal(int val, int precision, int scale) {
        BigDecimal decimal = new BigDecimal(val);
        return IgniteSqlFunctions.toBigDecimal(decimal, precision, scale);
    }

    public static BigDecimal toBigDecimal(short val, int precision, int scale) {
        BigDecimal decimal = new BigDecimal(val);
        return IgniteSqlFunctions.toBigDecimal(decimal, precision, scale);
    }

    public static BigDecimal toBigDecimal(byte val, int precision, int scale) {
        BigDecimal decimal = new BigDecimal(val);
        return IgniteSqlFunctions.toBigDecimal(decimal, precision, scale);
    }

    public static BigDecimal toBigDecimal(boolean val, int precision, int scale) {
        throw new UnsupportedOperationException();
    }

    public static BigDecimal toBigDecimal(String s, int precision, int scale) {
        if (s == null) {
            return null;
        }
        BigDecimal decimal = new BigDecimal(s.trim());
        return IgniteSqlFunctions.toBigDecimal(decimal, precision, scale);
    }

    public static BigDecimal toBigDecimal(Object o, int precision, int scale) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            throw new UnsupportedOperationException();
        }
        return o instanceof Number ? IgniteSqlFunctions.toBigDecimal((Number)o, precision, scale) : IgniteSqlFunctions.toBigDecimal(o.toString(), precision, scale);
    }

    public static BigDecimal toBigDecimal(Number value, int precision, int scale) {
        assert (precision > 0) : "Invalid precision: " + precision;
        if (value == null) {
            return null;
        }
        if (value.longValue() == 0L) {
            return IgniteSqlFunctions.processFractionData(value, precision, scale);
        }
        return IgniteSqlFunctions.processValueWithIntegralPart(value, precision, scale);
    }

    public static double log(double d0, double d1) {
        return Math.log(d0) / Math.log(d1);
    }

    public static double log(double d0, BigDecimal d1) {
        return Math.log(d0) / Math.log(d1.doubleValue());
    }

    public static double log(BigDecimal d0, double d1) {
        return Math.log(d0.doubleValue()) / Math.log(d1);
    }

    public static double log(BigDecimal d0, BigDecimal d1) {
        return Math.log(d0.doubleValue()) / Math.log(d1.doubleValue());
    }

    private static BigDecimal processValueWithIntegralPart(Number value, int precision, int scale) {
        int expectedSignificantDigits;
        BigDecimal dec = IgniteSqlFunctions.convertToBigDecimal(value);
        if (scale > precision) {
            throw IgniteSqlFunctions.numericOverflowError(precision, scale);
        }
        int currentSignificantDigits = dec.precision() - dec.scale();
        if (currentSignificantDigits > (expectedSignificantDigits = precision - scale)) {
            throw IgniteSqlFunctions.numericOverflowError(precision, scale);
        }
        return dec.setScale(scale, IgniteMath.ROUNDING_MODE);
    }

    private static BigDecimal processFractionData(Number value, int precision, int scale) {
        BigDecimal num = IgniteSqlFunctions.convertToBigDecimal(value);
        if (num.unscaledValue().equals(BigInteger.ZERO)) {
            return num.setScale(scale, RoundingMode.UNNECESSARY);
        }
        BigDecimal num0 = num.movePointRight(scale).setScale(0, RoundingMode.DOWN);
        int numPrecision = Math.min(num0.precision(), scale);
        if (numPrecision > precision) {
            throw IgniteSqlFunctions.numericOverflowError(precision, scale);
        }
        return num.setScale(scale, IgniteMath.ROUNDING_MODE);
    }

    private static BigDecimal convertToBigDecimal(Number value) {
        BigDecimal dec = value instanceof Float ? new BigDecimal(value.floatValue()) : (value instanceof Double ? new BigDecimal(value.doubleValue()) : (value instanceof BigDecimal ? (BigDecimal)value : (value instanceof BigInteger ? new BigDecimal((BigInteger)value) : new BigDecimal(value.longValue()))));
        return dec;
    }

    private static SqlException numericOverflowError(int precision, int scale) {
        String maxVal = precision == scale ? "1" : IgniteStringFormatter.format((String)"10^{}", (Object[])new Object[]{precision - scale});
        String detail = IgniteStringFormatter.format((String)"A field with precision {}, scale {} must round to an absolute value less than {}.", (Object[])new Object[]{precision, scale, maxVal});
        throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, "Numeric field overflow. " + detail);
    }

    public static ByteString toByteString(String s) {
        return s == null ? null : new ByteString(s.getBytes(Commons.typeFactory().getDefaultCharset()));
    }

    public static int currentTime(DataContext ctx) {
        return (Integer)TypeUtils.toInternal(LocalTime.now(), LocalTime.class);
    }

    @Nullable
    public static Object least2(Object arg0, Object arg1) {
        return IgniteSqlFunctions.leastOrGreatest(true, arg0, arg1);
    }

    @Nullable
    public static Object greatest2(Object arg0, Object arg1) {
        return IgniteSqlFunctions.leastOrGreatest(false, arg0, arg1);
    }

    @NonDeterministic
    public static UUID randUuid() {
        return UUID.randomUUID();
    }

    public static Object consumeFirstArgument(Object args0, Object args1) {
        return args1;
    }

    public static Long subtractTimeZoneOffset(long timestamp, TimeZone timeZone) {
        int offset = timeZone.getOffset(timestamp - (long)timeZone.getOffset(timestamp));
        return timestamp - (long)offset;
    }

    public static String unixTimestampToString(long timestamp, int precision) {
        IgniteStringBuilder buf = new IgniteStringBuilder(17);
        int date = (int)(timestamp / 86400000L);
        int time = (int)(timestamp % 86400000L);
        if (time < 0) {
            --date;
            time += 86400000;
        }
        buf.app(DateTimeUtils.unixDateToString((int)date)).app(' ');
        IgniteSqlFunctions.unixTimeToString(buf, time, precision);
        return buf.toString();
    }

    public static String unixTimeToString(int time, int precision) {
        IgniteStringBuilder buf = new IgniteStringBuilder(8 + (precision > 0 ? 1 + precision : 0));
        IgniteSqlFunctions.unixTimeToString(buf, time, precision);
        return buf.toString();
    }

    private static void unixTimeToString(IgniteStringBuilder buf, int time, int precision) {
        int h = time / 3600000;
        int time2 = time % 3600000;
        int m = time2 / 60000;
        int time3 = time2 % 60000;
        int s = time3 / 1000;
        int ms = time3 % 1000;
        buf.app((char)(48 + h / 10 % 10)).app((char)(48 + h % 10)).app(':').app((char)(48 + m / 10 % 10)).app((char)(48 + m % 10)).app(':').app((char)(48 + s / 10 % 10)).app((char)(48 + s % 10));
        if (precision == 0 || ms == 0) {
            return;
        }
        buf.app('.');
        do {
            buf.app((char)(48 + ms / 100));
            ms %= 100;
        } while ((ms *= 10) > 0 && --precision > 0);
    }

    @Nullable
    private static Object leastOrGreatest(boolean least, Object arg0, Object arg1) {
        if (arg0 == null || arg1 == null) {
            return null;
        }
        assert (arg0 instanceof Comparable && arg1 instanceof Comparable) : "Unexpected class [arg0=" + arg0.getClass().getName() + ", arg1=" + arg1.getClass().getName() + "]";
        if (((Comparable)arg0).compareTo(arg1) < 0) {
            return least ? arg0 : arg1;
        }
        return least ? arg1 : arg0;
    }

    private static long divide(long p, long q, RoundingMode mode) {
        boolean increment;
        long div = p / q;
        long rem = p - q * div;
        int signum = 1 | (int)((p ^ q) >> 63);
        switch (mode) {
            case HALF_DOWN: 
            case HALF_UP: {
                long absRem = Math.abs(rem);
                long cmpRemToHalfDivisor = absRem - (Math.abs(q) - absRem);
                if (cmpRemToHalfDivisor == 0L) {
                    increment = mode == RoundingMode.HALF_UP;
                    break;
                }
                increment = cmpRemToHalfDivisor > 0L;
                break;
            }
            case DOWN: {
                increment = false;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment ? div + (long)signum : div;
    }
}

