/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule;

import java.util.Collection;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteKeyValueModify;
import org.apache.ignite.internal.sql.engine.rule.ImmutableTableModifyToKeyValuePutRule;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.immutables.value.Value;

@Value.Enclosing
public class TableModifyToKeyValuePutRule
extends RelRule<Config> {
    public static final RelOptRule VALUES = Config.VALUES.toRule();
    public static final RelOptRule PROJECT = Config.PROJECT.toRule();

    private TableModifyToKeyValuePutRule(Config cfg) {
        super((RelRule.Config)cfg);
    }

    public void onMatch(RelOptRuleCall call) {
        List expressions;
        List operands = call.getRelList();
        TableModify modify = (TableModify)TableModifyToKeyValuePutRule.cast((RelNode)operands.get(0));
        assert (modify.getOperation() == TableModify.Operation.INSERT) : modify.getOperation();
        if (operands.size() == 2) {
            Values values = (Values)TableModifyToKeyValuePutRule.cast((RelNode)operands.get(1));
            assert (values.getTuples().size() == 1) : "Expected exactly one tuple, but was " + values.getTuples().size();
            expressions = List.copyOf((Collection)values.getTuples().get(0));
        } else {
            assert (operands.size() == 3) : operands;
            Values values = (Values)TableModifyToKeyValuePutRule.cast((RelNode)operands.get(2));
            assert (values.getTuples().size() == 1) : "Expected exactly one tuple, but was " + values.getTuples().size();
            final List inputExpressions = List.copyOf((Collection)values.getTuples().get(0));
            RexShuttle inputInliner = new RexShuttle(){

                public RexNode visitInputRef(RexInputRef inputRef) {
                    return (RexNode)inputExpressions.get(inputRef.getIndex());
                }
            };
            Project project = (Project)TableModifyToKeyValuePutRule.cast((RelNode)operands.get(1));
            expressions = inputInliner.visitList((Iterable)project.getProjects());
        }
        call.transformTo((RelNode)new IgniteKeyValueModify(modify.getCluster(), modify.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single()), modify.getTable(), IgniteKeyValueModify.Operation.PUT, expressions));
    }

    private static <T extends RelNode> T cast(RelNode node) {
        return (T)node;
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config VALUES = (Config)ImmutableTableModifyToKeyValuePutRule.Config.of().withDescription("TableModifyToKeyValuePutRule:VALUES").withOperandSupplier(o0 -> o0.operand(TableModify.class).predicate(TableModify::isInsert).oneInput(o1 -> o1.operand(Values.class).predicate(values -> values.getTuples().size() == 1).noInputs())).as(Config.class);
        public static final Config PROJECT = (Config)ImmutableTableModifyToKeyValuePutRule.Config.of().withDescription("TableModifyToKeyValuePutRule:PROJECT").withOperandSupplier(o0 -> o0.operand(TableModify.class).predicate(TableModify::isInsert).oneInput(o1 -> o1.operand(Project.class).oneInput(o2 -> o2.operand(Values.class).predicate(values -> values.getTuples().size() == 1).noInputs()))).as(Config.class);

        default public TableModifyToKeyValuePutRule toRule() {
            return new TableModifyToKeyValuePutRule(this);
        }
    }
}

