/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.internal.compute.CancellableJobExecution;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.executor.JobExecutionInternal;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

class DelegatingJobExecution
implements CancellableJobExecution<ComputeJobDataHolder> {
    private final CompletableFuture<JobExecutionInternal<ComputeJobDataHolder>> delegate;

    DelegatingJobExecution(CompletableFuture<JobExecutionInternal<ComputeJobDataHolder>> delegate) {
        this.delegate = delegate;
    }

    public CompletableFuture<ComputeJobDataHolder> resultAsync() {
        return this.delegate.thenCompose(JobExecutionInternal::resultAsync);
    }

    public CompletableFuture<@Nullable JobState> stateAsync() {
        return this.delegate.thenApply(JobExecutionInternal::state);
    }

    @Override
    public CompletableFuture<@Nullable Boolean> cancelAsync() {
        return this.delegate.thenApply(JobExecutionInternal::cancel);
    }

    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        return this.delegate.thenApply(jobExecutionInternal -> jobExecutionInternal.changePriority(newPriority));
    }

    public ClusterNode node() {
        try {
            return (ClusterNode)((CompletableFuture)this.delegate.thenApply(JobExecutionInternal::node)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

