/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.message;

import org.apache.ignite.internal.compute.message.JobStateResponse;
import org.apache.ignite.internal.compute.message.JobStateResponseImpl;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class JobStateResponseSerializer
implements MessageSerializer<JobStateResponse> {
    public static final JobStateResponseSerializer INSTANCE = new JobStateResponseSerializer();

    private JobStateResponseSerializer() {
    }

    public boolean writeMessage(JobStateResponse msg, MessageWriter writer) throws MessageMappingException {
        JobStateResponseImpl message = (JobStateResponseImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeByteArray("stateByteArray", message.stateByteArray());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeByteArray("throwableByteArray", message.throwableByteArray());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

