/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.RecipientLeftException;
import org.apache.ignite.internal.raft.Command;
import org.apache.ignite.internal.raft.Marshaller;
import org.apache.ignite.internal.raft.Peer;
import org.apache.ignite.internal.raft.PeerUnavailableException;
import org.apache.ignite.internal.raft.PeersAndLearners;
import org.apache.ignite.internal.raft.ReadCommand;
import org.apache.ignite.internal.raft.RetryContext;
import org.apache.ignite.internal.raft.WriteCommand;
import org.apache.ignite.internal.raft.configuration.RaftConfiguration;
import org.apache.ignite.internal.raft.service.LeaderWithTerm;
import org.apache.ignite.internal.raft.service.RaftGroupService;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.tostring.IgniteToStringBuilder;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.rpc.ActionRequest;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.rpc.impl.RaftException;
import org.apache.ignite.raft.jraft.rpc.impl.SMCompactedThrowable;
import org.apache.ignite.raft.jraft.rpc.impl.SMFullThrowable;
import org.apache.ignite.raft.jraft.rpc.impl.SMThrowable;
import org.jetbrains.annotations.Nullable;

public class RaftGroupServiceImpl
implements RaftGroupService {
    private static final IgniteLogger LOG = Loggers.forClass(RaftGroupServiceImpl.class);
    private final String groupId;
    private final ReplicationGroupId realGroupId;
    private final RaftMessagesFactory factory;
    private final RaftConfiguration configuration;
    @Nullable
    private volatile Peer leader;
    private volatile List<Peer> peers;
    private volatile List<Peer> learners;
    private final ClusterService cluster;
    private final ScheduledExecutorService executor;
    private final Marshaller commandsMarshaller;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private static final Supplier<String> NO_DESCRIPTION = () -> null;

    private RaftGroupServiceImpl(ReplicationGroupId groupId, ClusterService cluster, RaftMessagesFactory factory, RaftConfiguration configuration, PeersAndLearners membersConfiguration, @Nullable Peer leader, ScheduledExecutorService executor, Marshaller commandsMarshaller) {
        this.cluster = cluster;
        this.configuration = configuration;
        this.peers = List.copyOf(membersConfiguration.peers());
        this.learners = List.copyOf(membersConfiguration.learners());
        this.factory = factory;
        this.groupId = groupId.toString();
        this.realGroupId = groupId;
        this.leader = leader;
        this.executor = executor;
        this.commandsMarshaller = commandsMarshaller;
    }

    public static RaftGroupService start(ReplicationGroupId groupId, ClusterService cluster, RaftMessagesFactory factory, RaftConfiguration configuration, PeersAndLearners membersConfiguration, ScheduledExecutorService executor, Marshaller commandsMarshaller) {
        boolean inBenchmark = IgniteSystemProperties.getBoolean((String)"IGNITE_SKIP_REPLICATION_IN_BENCHMARK");
        RaftGroupServiceImpl service = inBenchmark ? new RaftGroupServiceImpl(groupId, cluster, factory, configuration, membersConfiguration, null, executor, commandsMarshaller){

            @Override
            public <R> CompletableFuture<R> run(Command cmd) {
                return cmd.getClass().getSimpleName().contains("UpdateCommand") ? CompletableFutures.nullCompletedFuture() : super.run(cmd);
            }
        } : new RaftGroupServiceImpl(groupId, cluster, factory, configuration, membersConfiguration, null, executor, commandsMarshaller);
        return service;
    }

    public ReplicationGroupId groupId() {
        return this.realGroupId;
    }

    public Peer leader() {
        return this.leader;
    }

    public List<Peer> peers() {
        return this.peers;
    }

    public List<Peer> learners() {
        return this.learners;
    }

    public CompletableFuture<Void> refreshLeader() {
        return this.refreshLeader(NO_DESCRIPTION);
    }

    private CompletableFuture<Void> refreshLeader(Supplier<String> originDescription) {
        return this.refreshLeader(this.defaultTimeout(), originDescription);
    }

    private CompletableFuture<Void> refreshLeader(long timeout, Supplier<String> originDescription) {
        Function<Peer, CliRequests.GetLeaderRequest> requestFactory = targetPeer -> this.factory.getLeaderRequest().peerId(RaftGroupServiceImpl.peerId(targetPeer)).groupId(this.groupId).build();
        return this.sendWithRetry(this.randomNode(), timeout, originDescription, requestFactory).thenAccept(resp -> {
            this.leader = RaftGroupServiceImpl.parsePeer(resp.leaderId());
        });
    }

    public CompletableFuture<LeaderWithTerm> refreshAndGetLeaderWithTerm() {
        Function<Peer, CliRequests.GetLeaderRequest> requestFactory = targetPeer -> this.factory.getLeaderRequest().peerId(RaftGroupServiceImpl.peerId(targetPeer)).groupId(this.groupId).build();
        return this.sendWithRetry(this.randomNode(), requestFactory).thenApply(resp -> {
            Peer respLeader;
            if (resp.leaderId() == null) {
                return LeaderWithTerm.NO_LEADER;
            }
            this.leader = respLeader = RaftGroupServiceImpl.parsePeer(resp.leaderId());
            return new LeaderWithTerm(respLeader, resp.currentTerm());
        });
    }

    public CompletableFuture<Void> refreshMembers(boolean onlyAlive) {
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader(() -> "refreshMembers").thenCompose(res -> this.refreshMembers(onlyAlive));
        }
        Function<Peer, CliRequests.GetPeersRequest> requestFactory = targetPeer -> this.factory.getPeersRequest().leaderId(RaftGroupServiceImpl.peerId(targetPeer)).onlyAlive(onlyAlive).groupId(this.groupId).build();
        return this.sendWithRetry(leader, requestFactory).thenAccept(resp -> {
            this.peers = RaftGroupServiceImpl.parsePeerList(resp.peersList());
            this.learners = RaftGroupServiceImpl.parsePeerList(resp.learnersList());
        });
    }

    public CompletableFuture<Void> addPeer(Peer peer) {
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader(() -> "addPeer").thenCompose(res -> this.addPeer(peer));
        }
        Function<Peer, CliRequests.AddPeerRequest> requestFactory = targetPeer -> this.factory.addPeerRequest().leaderId(RaftGroupServiceImpl.peerId(targetPeer)).groupId(this.groupId).peerId(RaftGroupServiceImpl.peerId(peer)).build();
        return this.sendWithRetry(leader, requestFactory).thenAccept(resp -> {
            this.peers = RaftGroupServiceImpl.parsePeerList(resp.newPeersList());
        });
    }

    public CompletableFuture<Void> removePeer(Peer peer) {
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader(() -> "removePeer").thenCompose(res -> this.removePeer(peer));
        }
        Function<Peer, CliRequests.RemovePeerRequest> requestFactory = targetPeer -> this.factory.removePeerRequest().leaderId(RaftGroupServiceImpl.peerId(targetPeer)).groupId(this.groupId).peerId(RaftGroupServiceImpl.peerId(peer)).build();
        return this.sendWithRetry(leader, requestFactory).thenAccept(resp -> {
            this.peers = RaftGroupServiceImpl.parsePeerList(resp.newPeersList());
        });
    }

    public CompletableFuture<Void> changePeersAndLearners(PeersAndLearners peersAndLearners, long term) {
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader(() -> "changePeersAndLearners").thenCompose(res -> this.changePeersAndLearners(peersAndLearners, term));
        }
        Function<Peer, CliRequests.ChangePeersAndLearnersRequest> requestFactory = targetPeer -> this.factory.changePeersAndLearnersRequest().leaderId(RaftGroupServiceImpl.peerId(targetPeer)).groupId(this.groupId).newPeersList(RaftGroupServiceImpl.peerIds(peersAndLearners.peers())).newLearnersList(RaftGroupServiceImpl.peerIds(peersAndLearners.learners())).term(term).build();
        LOG.info("Sending changePeersAndLearners request for group={} to peers={} and learners={} with leader term={}", new Object[]{this.groupId, peersAndLearners.peers(), peersAndLearners.learners(), term});
        return this.sendWithRetry(leader, requestFactory).thenAccept(resp -> {
            this.peers = RaftGroupServiceImpl.parsePeerList(resp.newPeersList());
            this.learners = RaftGroupServiceImpl.parsePeerList(resp.newLearnersList());
        });
    }

    public CompletableFuture<Void> changePeersAndLearnersAsync(PeersAndLearners peersAndLearners, long term) {
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader(() -> "changePeersAndLearnersAsync").thenCompose(res -> this.changePeersAndLearnersAsync(peersAndLearners, term));
        }
        Function<Peer, CliRequests.ChangePeersAndLearnersAsyncRequest> requestFactory = targetPeer -> this.factory.changePeersAndLearnersAsyncRequest().leaderId(RaftGroupServiceImpl.peerId(targetPeer)).groupId(this.groupId).term(term).newPeersList(RaftGroupServiceImpl.peerIds(peersAndLearners.peers())).newLearnersList(RaftGroupServiceImpl.peerIds(peersAndLearners.learners())).build();
        LOG.info("Sending changePeersAndLearnersAsync request for group={} to peers={} and learners={} with leader term={}", new Object[]{this.groupId, peersAndLearners.peers(), peersAndLearners.learners(), term});
        return this.sendWithRetry(leader, requestFactory).thenAccept(resp -> {
            assert (!(resp instanceof RpcRequests.ErrorResponse));
        });
    }

    public CompletableFuture<Void> addLearners(Collection<Peer> learners) {
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader(() -> "addLearners").thenCompose(res -> this.addLearners(learners));
        }
        Function<Peer, CliRequests.AddLearnersRequest> requestFactory = targetPeer -> this.factory.addLearnersRequest().leaderId(RaftGroupServiceImpl.peerId(targetPeer)).groupId(this.groupId).learnersList(RaftGroupServiceImpl.peerIds(learners)).build();
        return this.sendWithRetry(leader, requestFactory).thenAccept(resp -> {
            this.learners = RaftGroupServiceImpl.parsePeerList(resp.newLearnersList());
        });
    }

    public CompletableFuture<Void> removeLearners(Collection<Peer> learners) {
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader(() -> "removeLearners").thenCompose(res -> this.removeLearners(learners));
        }
        Function<Peer, CliRequests.RemoveLearnersRequest> requestFactory = targetPeer -> this.factory.removeLearnersRequest().leaderId(RaftGroupServiceImpl.peerId(targetPeer)).groupId(this.groupId).learnersList(RaftGroupServiceImpl.peerIds(learners)).build();
        return this.sendWithRetry(leader, requestFactory).thenAccept(resp -> {
            this.learners = RaftGroupServiceImpl.parsePeerList(resp.newLearnersList());
        });
    }

    public CompletableFuture<Void> resetLearners(Collection<Peer> learners) {
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader(() -> "resetLearners").thenCompose(res -> this.resetLearners(learners));
        }
        Function<Peer, CliRequests.ResetLearnersRequest> requestFactory = targetPeer -> this.factory.resetLearnersRequest().leaderId(RaftGroupServiceImpl.peerId(targetPeer)).groupId(this.groupId).learnersList(RaftGroupServiceImpl.peerIds(learners)).build();
        return this.sendWithRetry(leader, requestFactory).thenAccept(resp -> {
            this.learners = RaftGroupServiceImpl.parsePeerList(resp.newLearnersList());
        });
    }

    public CompletableFuture<Void> snapshot(Peer peer) {
        CliRequests.SnapshotRequest req = this.factory.snapshotRequest().peerId(RaftGroupServiceImpl.peerId(peer)).groupId(this.groupId).build();
        return ((CompletableFuture)this.resolvePeer(peer).thenCompose(node -> this.cluster.messagingService().invoke(node, (NetworkMessage)req, Integer.MAX_VALUE))).thenAccept(resp -> {
            RpcRequests.ErrorResponse resp0;
            if (resp != null && (resp0 = (RpcRequests.ErrorResponse)resp).errorCode() != RaftError.SUCCESS.getNumber()) {
                RaftException ex = new RaftException(RaftError.forNumber(resp0.errorCode()), resp0.errorMsg());
                throw new CompletionException((Throwable)((Object)ex));
            }
        });
    }

    public CompletableFuture<Void> transferLeadership(Peer newLeader) {
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader(() -> "transferLeadership").thenCompose(res -> this.transferLeadership(newLeader));
        }
        Function<Peer, CliRequests.TransferLeaderRequest> requestFactory = targetPeer -> this.factory.transferLeaderRequest().groupId(this.groupId).leaderId(RaftGroupServiceImpl.peerId(targetPeer)).peerId(RaftGroupServiceImpl.peerId(newLeader)).build();
        return this.sendWithRetry(leader, requestFactory).thenRun(() -> {
            this.leader = newLeader;
        });
    }

    public <R> CompletableFuture<R> run(Command cmd) {
        return this.run(cmd, this.defaultTimeout());
    }

    public <R> CompletableFuture<R> run(Command cmd, long timeoutMillis) {
        Peer leader = this.leader;
        if (leader == null) {
            return this.refreshLeader(timeoutMillis, () -> ((Command)cmd).toStringForLightLogging()).thenCompose(res -> this.run(cmd));
        }
        Function<Peer, ActionRequest> requestFactory = cmd instanceof WriteCommand ? targetPeer -> this.factory.writeActionRequest().groupId(this.groupId).command(this.commandsMarshaller.marshall((Object)cmd)).deserializedCommand((WriteCommand)cmd).build() : targetPeer -> this.factory.readActionRequest().groupId(this.groupId).command((ReadCommand)cmd).readOnlySafe(true).build();
        return this.sendWithRetry(leader, timeoutMillis, NO_DESCRIPTION, requestFactory).thenApply(resp -> resp.result());
    }

    public void shutdown() {
        this.busyLock.block();
    }

    public CompletableFuture<Long> readIndex() {
        Function<Peer, NetworkMessage> requestFactory = p -> this.factory.readIndexRequest().groupId(this.groupId).peerId(p.consistentId()).serverId(p.consistentId()).build();
        Peer leader = this.leader();
        Peer node = leader == null ? this.randomNode() : leader;
        return this.sendWithRetry(node, requestFactory).thenApply(RpcRequests.ReadIndexResponse::index);
    }

    public ClusterService clusterService() {
        return this.cluster;
    }

    public void updateConfiguration(PeersAndLearners configuration) {
        this.peers = List.copyOf(configuration.peers());
        this.learners = List.copyOf(configuration.learners());
        this.leader = null;
    }

    private long defaultTimeout() {
        return (Long)this.configuration.retryTimeout().value();
    }

    private <R extends NetworkMessage> CompletableFuture<R> sendWithRetry(Peer peer, Function<Peer, ? extends NetworkMessage> requestFactory) {
        return this.sendWithRetry(peer, this.defaultTimeout(), NO_DESCRIPTION, requestFactory);
    }

    private <R extends NetworkMessage> CompletableFuture<R> sendWithRetry(Peer peer, long timeoutMillis, Supplier<String> originDescription, Function<Peer, ? extends NetworkMessage> requestFactory) {
        CompletableFuture future = new CompletableFuture();
        long stopTime = timeoutMillis >= 0L ? System.currentTimeMillis() + timeoutMillis : Long.MAX_VALUE;
        RetryContext context = new RetryContext(peer, originDescription, requestFactory, stopTime);
        this.sendWithRetry(future, context);
        return future;
    }

    private <R extends NetworkMessage> void sendWithRetry(CompletableFuture<R> fut, RetryContext retryContext) {
        if (!this.busyLock.enterBusy()) {
            fut.cancel(true);
            return;
        }
        try {
            if (System.currentTimeMillis() >= retryContext.stopTime()) {
                fut.completeExceptionally(new TimeoutException(IgniteStringFormatter.format((String)"Send with retry timed out [retryCount = {}, groupId = {}, traceId = {}, request = {}, originCommand = {}].", (Object[])new Object[]{retryContext.retryCount(), this.groupId, retryContext.errorTraceId(), retryContext.request().toStringForLightLogging(), retryContext.originCommandDescription()})));
                return;
            }
            ((CompletableFuture)this.resolvePeer(retryContext.targetPeer()).thenCompose(node -> this.cluster.messagingService().invoke(node, retryContext.request(), ((Long)this.configuration.responseTimeout().value()).longValue()))).whenComplete((resp, err) -> {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("sendWithRetry req={} resp={} from={} to={} err={}", new Object[]{retryContext.request(), resp, this.cluster.topologyService().localMember().address(), retryContext.targetPeer().consistentId(), err == null ? null : err.getMessage()});
                }
                try {
                    if (err != null) {
                        this.handleThrowable(fut, (Throwable)err, retryContext);
                    } else if (resp instanceof RpcRequests.ErrorResponse) {
                        this.handleErrorResponse(fut, (RpcRequests.ErrorResponse)resp, retryContext);
                    } else if (resp instanceof RpcRequests.SMErrorResponse) {
                        RaftGroupServiceImpl.handleSmErrorResponse(fut, (RpcRequests.SMErrorResponse)resp, retryContext);
                    } else {
                        this.leader = retryContext.targetPeer();
                        fut.complete(resp);
                    }
                }
                catch (Throwable e) {
                    fut.completeExceptionally(e);
                }
            });
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void handleThrowable(CompletableFuture<? extends NetworkMessage> fut, Throwable err, RetryContext retryContext) {
        if (!RaftGroupServiceImpl.recoverable(err = ExceptionUtils.unwrapCause((Throwable)err))) {
            fut.completeExceptionally(err);
            return;
        }
        Peer randomPeer = this.randomNode(retryContext);
        if (LOG.isDebugEnabled()) {
            String msg = err instanceof TimeoutException ? "Recoverable TimeoutException during the request occurred (will be retried on a randomly selected node) [request={}, peer={}, newPeer={}, traceId={}]." : "Recoverable error during the request occurred (will be retried on a randomly selected node) [request={}, peer={}, newPeer={}, traceId={}].";
            LOG.debug(msg, new Object[]{IgniteToStringBuilder.includeSensitive() ? retryContext.request() : retryContext.request().toStringForLightLogging(), retryContext.targetPeer(), randomPeer, retryContext.errorTraceId()});
        }
        this.scheduleRetry(fut, retryContext.nextAttempt(randomPeer));
    }

    private void handleErrorResponse(CompletableFuture<? extends NetworkMessage> fut, RpcRequests.ErrorResponse resp, RetryContext retryContext) {
        RaftError error = RaftError.forNumber(resp.errorCode());
        switch (error) {
            case SUCCESS: {
                this.leader = retryContext.targetPeer();
                fut.complete(null);
                break;
            }
            case EBUSY: 
            case EAGAIN: {
                this.scheduleRetry(fut, retryContext.nextAttempt(retryContext.targetPeer()));
                break;
            }
            case UNKNOWN: 
            case EINTERNAL: 
            case ENOENT: {
                NetworkMessage request = retryContext.request();
                Peer newTargetPeer = request instanceof CliRequests.GetLeaderRequest || request instanceof CliRequests.ChangePeersAndLearnersAsyncRequest ? this.randomNode(retryContext) : retryContext.targetPeer();
                this.scheduleRetry(fut, retryContext.nextAttempt(newTargetPeer));
                break;
            }
            case EHOSTDOWN: 
            case ESHUTDOWN: 
            case ENODESHUTDOWN: {
                Peer newTargetPeer = this.randomNode(retryContext);
                this.scheduleRetry(fut, retryContext.nextAttemptForUnavailablePeer(newTargetPeer));
                break;
            }
            case EPERM: {
                Peer newTargetPeer;
                if (resp.leaderId() == null) {
                    newTargetPeer = this.randomNode(retryContext);
                } else {
                    newTargetPeer = RaftGroupServiceImpl.parsePeer(resp.leaderId());
                    assert (newTargetPeer != null);
                    this.leader = newTargetPeer;
                }
                this.scheduleRetry(fut, retryContext.nextAttempt(newTargetPeer));
                break;
            }
            default: {
                fut.completeExceptionally((Throwable)((Object)new RaftException(error, resp.errorMsg())));
            }
        }
    }

    private static void handleSmErrorResponse(CompletableFuture<? extends NetworkMessage> fut, RpcRequests.SMErrorResponse resp, RetryContext retryContext) {
        SMThrowable th = resp.error();
        if (th instanceof SMCompactedThrowable) {
            SMCompactedThrowable compactedThrowable = (SMCompactedThrowable)th;
            try {
                Throwable restoredTh = (Throwable)Class.forName(compactedThrowable.throwableClassName()).getConstructor(String.class).newInstance(compactedThrowable.throwableMessage());
                fut.completeExceptionally(restoredTh);
            }
            catch (Exception e) {
                LOG.warn("Cannot restore throwable from user's state machine. Check if throwable " + compactedThrowable.throwableClassName() + " is present in the classpath.", new Object[0]);
                fut.completeExceptionally((Throwable)new IgniteInternalException(retryContext.errorTraceId(), ErrorGroups.Common.INTERNAL_ERR, compactedThrowable.throwableMessage()));
            }
        } else if (th instanceof SMFullThrowable) {
            fut.completeExceptionally(((SMFullThrowable)th).throwable());
        } else assert (false) : th;
    }

    private void scheduleRetry(CompletableFuture<? extends NetworkMessage> fut, RetryContext retryContext) {
        this.executor.schedule(() -> this.sendWithRetry(fut, retryContext), (long)((Long)this.configuration.retryDelay().value()), TimeUnit.MILLISECONDS);
    }

    private static boolean recoverable(Throwable t) {
        return (t = ExceptionUtils.unwrapCause((Throwable)t)) instanceof TimeoutException || t instanceof IOException || t instanceof PeerUnavailableException || t instanceof RecipientLeftException;
    }

    private Peer randomNode() {
        return this.randomNode(null);
    }

    private Peer randomNode(@Nullable RetryContext retryContext) {
        List<Peer> localPeers = this.peers;
        ArrayList<Peer> availablePeers = new ArrayList<Peer>(localPeers.size());
        if (retryContext == null) {
            availablePeers.addAll(localPeers);
        } else {
            for (Peer peer2 : localPeers) {
                if (retryContext.targetPeer().equals((Object)peer2) || retryContext.unavailablePeers().contains(peer2)) continue;
                availablePeers.add(peer2);
            }
            if (availablePeers.isEmpty()) {
                LOG.warn("All peers are unavailable, going to keep retrying until timeout [peers = {}, group = {}, trace ID: {}].", new Object[]{localPeers, this.groupId, retryContext.errorTraceId()});
                retryContext.resetUnavailablePeers();
                availablePeers.addAll(this.peers);
            }
        }
        if (availablePeers.isEmpty()) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "No peers available [groupId=" + this.groupId + "]");
        }
        Collections.shuffle(availablePeers, ThreadLocalRandom.current());
        return availablePeers.stream().filter(peer -> this.cluster.topologyService().getByConsistentId(peer.consistentId()) != null).findAny().orElse((Peer)availablePeers.get(0));
    }

    @Nullable
    private static Peer parsePeer(@Nullable String peerId) {
        PeerId id = PeerId.parsePeer(peerId);
        return id == null ? null : new Peer(id.getConsistentId(), id.getIdx());
    }

    private static List<Peer> parsePeerList(@Nullable Collection<String> peers) {
        if (peers == null) {
            return List.of();
        }
        ArrayList<Peer> res = new ArrayList<Peer>(peers.size());
        for (String peer : peers) {
            res.add(RaftGroupServiceImpl.parsePeer(peer));
        }
        return res;
    }

    private static String peerId(Peer peer) {
        return PeerId.fromPeer(peer).toString();
    }

    private static List<String> peerIds(Collection<Peer> peers) {
        return peers.stream().map(RaftGroupServiceImpl::peerId).collect(Collectors.toList());
    }

    private CompletableFuture<ClusterNode> resolvePeer(Peer peer) {
        ClusterNode node = this.cluster.topologyService().getByConsistentId(peer.consistentId());
        if (node == null) {
            return CompletableFuture.failedFuture(new PeerUnavailableException(peer.consistentId()));
        }
        return CompletableFuture.completedFuture(node);
    }
}

