/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class BatchedArguments
implements Iterable<List<Object>> {
    private final List<List<Object>> batchedArgs;

    public static BatchedArguments create() {
        return new BatchedArguments();
    }

    public static BatchedArguments of(Object ... args) {
        BatchedArguments arguments = BatchedArguments.create();
        arguments.add(args);
        return arguments;
    }

    public static BatchedArguments from(List<List<Object>> batchedArgs) {
        Objects.requireNonNull(batchedArgs, "batchedArgs");
        return new BatchedArguments(batchedArgs);
    }

    public BatchedArguments add(Object ... args) {
        Objects.requireNonNull(args, "args");
        return this.addArguments(List.of(args));
    }

    public List<Object> get(int index) {
        return this.batchedArgs.get(index);
    }

    public int size() {
        return this.batchedArgs.size();
    }

    public boolean isEmpty() {
        return this.batchedArgs.isEmpty();
    }

    @Override
    public Iterator<List<Object>> iterator() {
        return new ImmutableIterator<List<Object>>(this.batchedArgs.iterator());
    }

    private BatchedArguments() {
        this.batchedArgs = new ArrayList<List<Object>>();
    }

    private BatchedArguments(List<List<Object>> batchedArgs) {
        ArrayList<List<Object>> resultList = new ArrayList<List<Object>>(batchedArgs.size());
        int pos = 0;
        int requiredLength = 0;
        for (List<Object> arguments : batchedArgs) {
            Objects.requireNonNull(arguments, "Arguments list cannot be null.");
            if (arguments.isEmpty()) {
                BatchedArguments.throwEmptyArgumentsException();
            }
            if (pos == 0) {
                requiredLength = arguments.size();
            } else {
                BatchedArguments.ensureRowLength(requiredLength, arguments.size());
            }
            resultList.add(List.copyOf(arguments));
            ++pos;
        }
        this.batchedArgs = resultList;
    }

    private BatchedArguments addArguments(List<Object> immutableList) {
        if (immutableList.isEmpty()) {
            BatchedArguments.throwEmptyArgumentsException();
        }
        if (!this.batchedArgs.isEmpty()) {
            BatchedArguments.ensureRowLength(this.batchedArgs.get(0).size(), immutableList.size());
        }
        this.batchedArgs.add(immutableList);
        return this;
    }

    private static void throwEmptyArgumentsException() {
        throw new IllegalArgumentException("Non empty arguments required.");
    }

    private static void ensureRowLength(int expected, int actual) {
        if (expected != actual) {
            throw new IllegalArgumentException("Argument lists must be the same size.");
        }
    }

    private static class ImmutableIterator<E>
    implements Iterator<E> {
        private final Iterator<E> delegate;

        private ImmutableIterator(Iterator<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public E next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            this.delegate.forEachRemaining(action);
        }
    }
}

