/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.util.Objects;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.table.MutableRowTupleAdapter;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.table.Tuple;

public class TableRow
extends MutableRowTupleAdapter {
    public static Tuple keyTuple(Row row) {
        return new KeyRowChunk(row);
    }

    public static Tuple valueTuple(Row row) {
        return new ValueRowChunk(row);
    }

    public static Tuple tuple(Row row) {
        return new TableRow(row);
    }

    private TableRow(Row row) {
        super(row);
    }

    private static class KeyRowChunk
    extends MutableRowTupleAdapter {
        KeyRowChunk(Row row) {
            super(row);
        }

        @Override
        public int columnCount() {
            return this.tuple != null ? this.tuple.columnCount() : this.schema().keyColumns().size();
        }

        @Override
        public int columnIndex(String columnName) {
            if (this.tuple != null) {
                return this.tuple.columnIndex(columnName);
            }
            Objects.requireNonNull(columnName);
            Column col = this.schema().column(IgniteNameUtils.parseSimpleName((String)columnName));
            return col == null ? -1 : col.positionInKey();
        }

        @Override
        protected Column rowColumnByName(String columnName) {
            Column col = super.rowColumnByName(columnName);
            if (col.positionInKey() == -1) {
                throw new IllegalArgumentException("Invalid column name: columnName=" + columnName);
            }
            return col;
        }

        @Override
        protected Column rowColumnByIndex(int columnIndex) {
            Objects.checkIndex(columnIndex, this.schema().keyColumns().size());
            return (Column)this.schema().keyColumns().get(columnIndex);
        }
    }

    private static class ValueRowChunk
    extends MutableRowTupleAdapter {
        ValueRowChunk(Row row) {
            super(row);
        }

        @Override
        public int columnCount() {
            return this.tuple != null ? this.tuple.columnCount() : this.schema().valueColumns().size();
        }

        @Override
        public int columnIndex(String columnName) {
            if (this.tuple != null) {
                return this.tuple.columnIndex(columnName);
            }
            Objects.requireNonNull(columnName);
            Column col = this.schema().column(IgniteNameUtils.parseSimpleName((String)columnName));
            return col == null ? -1 : col.positionInValue();
        }

        @Override
        protected Column rowColumnByName(String columnName) {
            Column col = super.rowColumnByName(columnName);
            if (col.positionInKey() >= 0) {
                throw new IllegalArgumentException("Invalid column name: columnName=" + columnName);
            }
            return col;
        }

        @Override
        protected Column rowColumnByIndex(int columnIndex) {
            Objects.checkIndex(columnIndex, this.schema().valueColumns().size());
            return (Column)this.schema().valueColumns().get(columnIndex);
        }
    }
}

