/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.AnnotationDefinition;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.ClassVisitor;

public class ClassDefinition {
    private final EnumSet<Access> access;
    private final ParameterizedType type;
    private final ParameterizedType superClass;
    private final List<ParameterizedType> interfaces = new ArrayList<ParameterizedType>();
    private final List<AnnotationDefinition> annotations = new ArrayList<AnnotationDefinition>();
    private final List<FieldDefinition> fields = new ArrayList<FieldDefinition>();
    private final List<MethodDefinition> methods = new ArrayList<MethodDefinition>();
    private final MethodDefinition classInitializer;
    private String source;
    private String debug;

    public ClassDefinition(EnumSet<Access> access, String name, ParameterizedType superClass, ParameterizedType ... interfaces) {
        this(access, new ParameterizedType(name), superClass, interfaces);
    }

    public ClassDefinition(EnumSet<Access> access, ParameterizedType type, ParameterizedType superClass, ParameterizedType ... interfaces) {
        Objects.requireNonNull(access, "access is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(superClass, "superClass is null");
        Objects.requireNonNull(interfaces, "interfaces is null");
        this.access = access;
        this.type = type;
        this.superClass = superClass;
        this.interfaces.addAll(List.of(interfaces));
        this.classInitializer = new MethodDefinition(this, Access.a(Access.STATIC), "<clinit>", ParameterizedType.type(Void.TYPE), List.of());
    }

    public Set<Access> getAccess() {
        return Set.copyOf(this.access);
    }

    public String getName() {
        return this.type.getClassName();
    }

    public ParameterizedType getType() {
        return this.type;
    }

    public ParameterizedType getSuperClass() {
        return this.superClass;
    }

    public String getSource() {
        return this.source;
    }

    public List<ParameterizedType> getInterfaces() {
        return List.copyOf(this.interfaces);
    }

    public List<AnnotationDefinition> getAnnotations() {
        return List.copyOf(this.annotations);
    }

    public List<FieldDefinition> getFields() {
        return List.copyOf(this.fields);
    }

    public List<MethodDefinition> getMethods() {
        return List.copyOf(this.methods);
    }

    public boolean isInterface() {
        return this.access.contains((Object)Access.INTERFACE);
    }

    public void visit(ClassVisitor visitor) {
        String signature = null;
        if (this.superClass.isGeneric() || this.interfaces.stream().anyMatch(ParameterizedType::isGeneric)) {
            signature = ClassDefinition.genericClassSignature(this.superClass, this.interfaces);
        }
        String[] interfaces = new String[this.interfaces.size()];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaces[i] = this.interfaces.get(i).getClassName();
        }
        int accessModifier = Access.toAccessModifier(this.access);
        visitor.visit(55, this.isInterface() ? accessModifier : accessModifier | 0x20, this.type.getClassName(), signature, this.superClass.getClassName(), interfaces);
        if (this.source != null) {
            visitor.visitSource(this.source, this.debug);
        }
        for (AnnotationDefinition annotation : this.annotations) {
            annotation.visitClassAnnotation(visitor);
        }
        for (FieldDefinition field : this.fields) {
            field.visit(visitor);
        }
        if (!this.isInterface()) {
            this.classInitializer.visit(visitor, true);
        }
        for (MethodDefinition method : this.methods) {
            method.visit(visitor);
        }
        visitor.visitEnd();
    }

    public AnnotationDefinition declareAnnotation(Class<?> type) {
        AnnotationDefinition annotationDefinition = new AnnotationDefinition(type);
        this.annotations.add(annotationDefinition);
        return annotationDefinition;
    }

    public AnnotationDefinition declareAnnotation(ParameterizedType type) {
        AnnotationDefinition annotationDefinition = new AnnotationDefinition(type);
        this.annotations.add(annotationDefinition);
        return annotationDefinition;
    }

    public FieldDefinition declareField(EnumSet<Access> access, String name, Class<?> type) {
        FieldDefinition fieldDefinition = new FieldDefinition(this, access, name, type);
        this.fields.add(fieldDefinition);
        return fieldDefinition;
    }

    public ClassDefinition addField(EnumSet<Access> access, String name, Class<?> type) {
        this.declareField(access, name, type);
        return this;
    }

    public FieldDefinition declareField(EnumSet<Access> access, String name, ParameterizedType type) {
        FieldDefinition fieldDefinition = new FieldDefinition(this, access, name, type);
        this.fields.add(fieldDefinition);
        return fieldDefinition;
    }

    public ClassDefinition addField(EnumSet<Access> access, String name, ParameterizedType type) {
        this.declareField(access, name, type);
        return this;
    }

    public ClassDefinition addField(FieldDefinition field) {
        this.fields.add(field);
        return this;
    }

    public MethodDefinition getClassInitializer() {
        if (this.isInterface()) {
            throw new IllegalAccessError("Interface does not have class initializer");
        }
        return this.classInitializer;
    }

    public MethodDefinition declareConstructor(EnumSet<Access> access, Parameter ... parameters) {
        return this.declareMethod(access, "<init>", ParameterizedType.type(Void.TYPE), List.of(parameters));
    }

    public MethodDefinition declareConstructor(EnumSet<Access> access, Collection<Parameter> parameters) {
        return this.declareMethod(access, "<init>", ParameterizedType.type(Void.TYPE), List.copyOf(parameters));
    }

    public ClassDefinition declareDefaultConstructor(EnumSet<Access> access) {
        MethodDefinition constructor = this.declareConstructor(access, new Parameter[0]);
        constructor.getBody().append(constructor.getThis()).invokeConstructor(this.superClass, new ParameterizedType[0]).ret();
        return this;
    }

    public ClassDefinition addMethod(MethodDefinition method) {
        this.methods.add(method);
        return this;
    }

    public ClassDefinition visitSource(String source, String debug) {
        this.source = source;
        this.debug = debug;
        return this;
    }

    public MethodDefinition declareMethod(EnumSet<Access> access, String name, ParameterizedType returnType, Parameter ... parameters) {
        return this.declareMethod(access, name, returnType, List.of(parameters));
    }

    public MethodDefinition declareMethod(EnumSet<Access> access, String name, ParameterizedType returnType, Collection<Parameter> parameters) {
        MethodDefinition methodDefinition = new MethodDefinition(this, access, name, returnType, parameters);
        EnumSet<Access> bridgeAccess = EnumSet.of(Access.SYNTHETIC, Access.BRIDGE);
        for (MethodDefinition method : this.methods) {
            if (!name.equals(method.getName()) || !method.getParameterTypes().equals(methodDefinition.getParameterTypes())) continue;
            boolean curBridge = method.getAccess().containsAll(bridgeAccess);
            boolean newBridge = methodDefinition.getAccess().containsAll(bridgeAccess);
            if ((curBridge || newBridge) && !method.getReturnType().equals(methodDefinition.getReturnType())) continue;
            throw new IllegalArgumentException("Method with same name and signature already exists: " + name);
        }
        this.methods.add(methodDefinition);
        return methodDefinition;
    }

    public static String genericClassSignature(ParameterizedType classType, ParameterizedType ... interfaceTypes) {
        return Stream.concat(Stream.of(classType), Stream.of(interfaceTypes)).map(ParameterizedType::toString).collect(Collectors.joining(""));
    }

    public static String genericClassSignature(ParameterizedType classType, List<ParameterizedType> interfaceTypes) {
        return Stream.concat(Stream.of(classType), interfaceTypes.stream()).map(ParameterizedType::toString).collect(Collectors.joining(""));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClassDefinition");
        sb.append("{access=").append(this.access);
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }
}

