/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.VariableInstruction;
import java.util.List;
import java.util.Objects;

public class Variable
extends BytecodeExpression {
    private final String name;

    public Variable(String name, ParameterizedType type) {
        super(type);
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public String getName() {
        return this.name;
    }

    public BytecodeExpression set(BytecodeExpression value) {
        return new SetVariableBytecodeExpression(this, value);
    }

    public BytecodeExpression increment() {
        return new SetVariableBytecodeExpression(this, BytecodeExpressions.add(this, BytecodeExpressions.constantInt(1)));
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return VariableInstruction.loadVariable(this);
    }

    @Override
    protected String formatOneLine() {
        return this.name;
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.of();
    }

    private static final class SetVariableBytecodeExpression
    extends BytecodeExpression {
        private final Variable variable;
        private final BytecodeExpression value;

        SetVariableBytecodeExpression(Variable variable, BytecodeExpression value) {
            super(ParameterizedType.type(Void.TYPE));
            this.variable = Objects.requireNonNull(variable, "variable is null");
            this.value = Objects.requireNonNull(value, "value is null");
        }

        @Override
        public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
            return new BytecodeBlock().append(this.value).putVariable(this.variable);
        }

        @Override
        public List<BytecodeNode> getChildNodes() {
            return List.of(this.value);
        }

        @Override
        protected String formatOneLine() {
            return this.variable.getName() + " = " + String.valueOf(this.value);
        }
    }
}

