/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.lowwatermark.LowWatermark;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.NetworkMessageHandler;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.ReplicaMeta;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEvent;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEventParameters;
import org.apache.ignite.internal.replicator.ReplicaService;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.exception.PrimaryReplicaMissException;
import org.apache.ignite.internal.replicator.exception.ReplicationException;
import org.apache.ignite.internal.replicator.exception.ReplicationTimeoutException;
import org.apache.ignite.internal.replicator.message.ErrorReplicaResponse;
import org.apache.ignite.internal.replicator.message.ReplicaMessageGroup;
import org.apache.ignite.internal.replicator.message.ReplicaResponse;
import org.apache.ignite.internal.systemview.api.SystemView;
import org.apache.ignite.internal.systemview.api.SystemViewProvider;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.tx.InternalTxOptions;
import org.apache.ignite.internal.tx.LocalRwTxCounter;
import org.apache.ignite.internal.tx.LockManager;
import org.apache.ignite.internal.tx.MismatchingTransactionOutcomeInternalException;
import org.apache.ignite.internal.tx.TransactionIds;
import org.apache.ignite.internal.tx.TransactionMeta;
import org.apache.ignite.internal.tx.TransactionResult;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.TxStateMeta;
import org.apache.ignite.internal.tx.TxStateMetaFinishing;
import org.apache.ignite.internal.tx.configuration.TransactionConfiguration;
import org.apache.ignite.internal.tx.impl.DeadlockPreventionPolicyImpl;
import org.apache.ignite.internal.tx.impl.OrphanDetector;
import org.apache.ignite.internal.tx.impl.PersistentTxStateVacuumizer;
import org.apache.ignite.internal.tx.impl.PlacementDriverHelper;
import org.apache.ignite.internal.tx.impl.PrimaryReplicaExpiredException;
import org.apache.ignite.internal.tx.impl.ReadOnlyTransactionImpl;
import org.apache.ignite.internal.tx.impl.ReadWriteTransactionImpl;
import org.apache.ignite.internal.tx.impl.RemotelyTriggeredResourceRegistry;
import org.apache.ignite.internal.tx.impl.TransactionExpirationRegistry;
import org.apache.ignite.internal.tx.impl.TransactionIdGenerator;
import org.apache.ignite.internal.tx.impl.TransactionInflights;
import org.apache.ignite.internal.tx.impl.TxCleanupRequestHandler;
import org.apache.ignite.internal.tx.impl.TxCleanupRequestSender;
import org.apache.ignite.internal.tx.impl.TxIdAndTimestamp;
import org.apache.ignite.internal.tx.impl.TxMessageSender;
import org.apache.ignite.internal.tx.impl.VolatileTxStateMetaStorage;
import org.apache.ignite.internal.tx.impl.WriteIntentSwitchProcessor;
import org.apache.ignite.internal.tx.message.WriteIntentSwitchReplicatedInfo;
import org.apache.ignite.internal.tx.views.LocksViewProvider;
import org.apache.ignite.internal.tx.views.TransactionsViewProvider;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TxManagerImpl
implements TxManager,
NetworkMessageHandler,
SystemViewProvider {
    private static final IgniteLogger LOG = Loggers.forClass(TxManagerImpl.class);
    private final TransactionConfiguration txConfig;
    private final LockManager lockManager;
    private final ExecutorService writeIntentSwitchPool;
    private final ClockService clockService;
    private final TransactionIdGenerator transactionIdGenerator;
    private final VolatileTxStateMetaStorage txStateVolatileStorage = new VolatileTxStateMetaStorage();
    private final LowWatermark lowWatermark;
    private final PlacementDriver placementDriver;
    private final PlacementDriverHelper placementDriverHelper;
    private final LongSupplier idleSafeTimePropagationPeriodMsSupplier;
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final LongAdder startedTxs = new LongAdder();
    private final LongAdder finishedTxs = new LongAdder();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final OrphanDetector orphanDetector;
    private final TopologyService topologyService;
    private final MessagingService messagingService;
    private volatile UUID localNodeId;
    private final TxCleanupRequestHandler txCleanupRequestHandler;
    private final TxCleanupRequestSender txCleanupRequestSender;
    private final TxMessageSender txMessageSender;
    private final EventListener<PrimaryReplicaEventParameters> primaryReplicaExpiredListener;
    private final EventListener<PrimaryReplicaEventParameters> primaryReplicaElectedListener;
    private final LocalRwTxCounter localRwTxCounter;
    private final Executor partitionOperationsExecutor;
    private final TransactionInflights transactionInflights;
    private final ReplicaService replicaService;
    private final ScheduledExecutorService commonScheduler;
    private final TransactionsViewProvider txViewProvider = new TransactionsViewProvider();
    private volatile PersistentTxStateVacuumizer persistentTxStateVacuumizer;
    private final TransactionExpirationRegistry transactionExpirationRegistry = new TransactionExpirationRegistry();
    @Nullable
    private volatile ScheduledFuture<?> transactionExpirationJobFuture;

    @TestOnly
    public TxManagerImpl(TransactionConfiguration txConfig, ClusterService clusterService, ReplicaService replicaService, LockManager lockManager, ClockService clockService, TransactionIdGenerator transactionIdGenerator, PlacementDriver placementDriver, LongSupplier idleSafeTimePropagationPeriodMsSupplier, LocalRwTxCounter localRwTxCounter, RemotelyTriggeredResourceRegistry resourcesRegistry, TransactionInflights transactionInflights, LowWatermark lowWatermark, ScheduledExecutorService commonScheduler) {
        this(clusterService.nodeName(), txConfig, clusterService.messagingService(), clusterService.topologyService(), replicaService, lockManager, clockService, transactionIdGenerator, placementDriver, idleSafeTimePropagationPeriodMsSupplier, localRwTxCounter, ForkJoinPool.commonPool(), resourcesRegistry, transactionInflights, lowWatermark, commonScheduler);
    }

    public TxManagerImpl(String nodeName, TransactionConfiguration txConfig, MessagingService messagingService, TopologyService topologyService, ReplicaService replicaService, LockManager lockManager, ClockService clockService, TransactionIdGenerator transactionIdGenerator, PlacementDriver placementDriver, LongSupplier idleSafeTimePropagationPeriodMsSupplier, LocalRwTxCounter localRwTxCounter, Executor partitionOperationsExecutor, RemotelyTriggeredResourceRegistry resourcesRegistry, TransactionInflights transactionInflights, LowWatermark lowWatermark, ScheduledExecutorService commonScheduler) {
        this.txConfig = txConfig;
        this.lockManager = lockManager;
        this.clockService = clockService;
        this.transactionIdGenerator = transactionIdGenerator;
        this.placementDriver = placementDriver;
        this.idleSafeTimePropagationPeriodMsSupplier = idleSafeTimePropagationPeriodMsSupplier;
        this.topologyService = topologyService;
        this.messagingService = messagingService;
        this.primaryReplicaExpiredListener = this::primaryReplicaExpiredListener;
        this.primaryReplicaElectedListener = this::primaryReplicaElectedListener;
        this.localRwTxCounter = localRwTxCounter;
        this.partitionOperationsExecutor = partitionOperationsExecutor;
        this.transactionInflights = transactionInflights;
        this.lowWatermark = lowWatermark;
        this.replicaService = replicaService;
        this.commonScheduler = commonScheduler;
        this.placementDriverHelper = new PlacementDriverHelper(placementDriver, clockService);
        int cpus = Runtime.getRuntime().availableProcessors();
        this.writeIntentSwitchPool = new ThreadPoolExecutor(cpus, cpus, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), IgniteThreadFactory.create((String)nodeName, (String)"tx-async-write-intent", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[]{ThreadOperation.STORAGE_READ, ThreadOperation.STORAGE_WRITE}));
        this.orphanDetector = new OrphanDetector(topologyService, replicaService, this.placementDriverHelper, lockManager, partitionOperationsExecutor);
        this.txMessageSender = new TxMessageSender(messagingService, replicaService, clockService, txConfig);
        WriteIntentSwitchProcessor writeIntentSwitchProcessor = new WriteIntentSwitchProcessor(this.placementDriverHelper, this.txMessageSender, topologyService);
        this.txCleanupRequestHandler = new TxCleanupRequestHandler(messagingService, lockManager, clockService, writeIntentSwitchProcessor, resourcesRegistry);
        this.txCleanupRequestSender = new TxCleanupRequestSender(this.txMessageSender, this.placementDriverHelper, this.txStateVolatileStorage);
    }

    private CompletableFuture<Boolean> primaryReplicaEventListener(PrimaryReplicaEventParameters eventParameters, Consumer<TablePartitionId> action) {
        return (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            if (!(eventParameters.groupId() instanceof TablePartitionId)) {
                return CompletableFutures.falseCompletedFuture();
            }
            TablePartitionId groupId = (TablePartitionId)eventParameters.groupId();
            action.accept(groupId);
            return CompletableFutures.falseCompletedFuture();
        });
    }

    private CompletableFuture<Boolean> primaryReplicaElectedListener(PrimaryReplicaEventParameters eventParameters) {
        return this.primaryReplicaEventListener(eventParameters, groupId -> {
            if (this.localNodeId.equals(eventParameters.leaseholderId())) {
                String localNodeName = this.topologyService.localMember().name();
                this.txMessageSender.sendRecoveryCleanup(localNodeName, (TablePartitionId)groupId);
            }
        });
    }

    private CompletableFuture<Boolean> primaryReplicaExpiredListener(PrimaryReplicaEventParameters eventParameters) {
        return this.primaryReplicaEventListener(eventParameters, this.transactionInflights::cancelWaitingInflights);
    }

    @Override
    public InternalTransaction beginImplicit(HybridTimestampTracker timestampTracker, boolean readOnly) {
        return this.begin(timestampTracker, true, readOnly, InternalTxOptions.defaults());
    }

    @Override
    public InternalTransaction beginExplicit(HybridTimestampTracker timestampTracker, boolean readOnly, InternalTxOptions txOptions) {
        return this.begin(timestampTracker, false, readOnly, txOptions);
    }

    private InternalTransaction begin(HybridTimestampTracker timestampTracker, boolean implicit, boolean readOnly, InternalTxOptions options) {
        return (InternalTransaction)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.beginBusy(timestampTracker, implicit, readOnly, options));
    }

    private InternalTransaction beginBusy(HybridTimestampTracker timestampTracker, boolean implicit, boolean readOnly, InternalTxOptions options) {
        HybridTimestamp beginTimestamp = readOnly ? this.clockService.now() : this.createBeginTimestampWithIncrementRwTxCounter();
        UUID txId = this.transactionIdGenerator.transactionIdFor(beginTimestamp, options.priority());
        this.startedTxs.add(1L);
        if (!readOnly) {
            this.txStateVolatileStorage.initialize(txId, this.localNodeId);
            return new ReadWriteTransactionImpl(this, timestampTracker, txId, this.localNodeId, implicit);
        }
        return this.beginReadOnlyTransaction(timestampTracker, beginTimestamp, txId, implicit, options);
    }

    private ReadOnlyTransactionImpl beginReadOnlyTransaction(HybridTimestampTracker timestampTracker, HybridTimestamp beginTimestamp, UUID txId, boolean implicit, InternalTxOptions options) {
        HybridTimestamp observableTimestamp = timestampTracker.get();
        HybridTimestamp readTimestamp = observableTimestamp != null ? HybridTimestamp.max((HybridTimestamp[])new HybridTimestamp[]{observableTimestamp, this.currentReadTimestamp(beginTimestamp)}) : this.currentReadTimestamp(beginTimestamp);
        boolean lockAcquired = this.lowWatermark.tryLock(txId, readTimestamp);
        if (!lockAcquired) {
            throw new IgniteInternalException(ErrorGroups.Transactions.TX_READ_ONLY_TOO_OLD_ERR, "Timestamp of read-only transaction must be greater than the low watermark: [txTimestamp={}, lowWatermark={}]", new Object[]{readTimestamp, this.lowWatermark.getLowWatermark()});
        }
        try {
            boolean scheduleExpiration;
            CompletableFuture<Void> txFuture = new CompletableFuture<Void>();
            ReadOnlyTransactionImpl transaction = new ReadOnlyTransactionImpl(this, timestampTracker, txId, this.localNodeId, implicit, readTimestamp, txFuture);
            boolean bl = scheduleExpiration = !implicit;
            if (scheduleExpiration) {
                this.transactionExpirationRegistry.register(transaction, this.roExpirationPhysicalTimeFor(beginTimestamp, options));
            }
            txFuture.whenComplete((unused, throwable) -> {
                this.lowWatermark.unlock(txId);
                if (scheduleExpiration) {
                    this.transactionExpirationRegistry.unregister(transaction);
                }
            });
            return transaction;
        }
        catch (Throwable t) {
            this.lowWatermark.unlock(txId);
            throw t;
        }
    }

    private long roExpirationPhysicalTimeFor(HybridTimestamp beginTimestamp, InternalTxOptions options) {
        long effectiveTimeoutMillis = options.timeoutMillis() == 0L ? this.defaultTransactionTimeoutMillis() : options.timeoutMillis();
        return TxManagerImpl.sumWithSaturation(beginTimestamp.getPhysical(), effectiveTimeoutMillis);
    }

    private static long sumWithSaturation(long a, long b) {
        assert (a >= 0L) : a;
        assert (b >= 0L) : b;
        long sum = a + b;
        if (sum < 0L) {
            return Long.MAX_VALUE;
        }
        return sum;
    }

    private long defaultTransactionTimeoutMillis() {
        return (Long)this.txConfig.timeout().value();
    }

    private HybridTimestamp currentReadTimestamp(HybridTimestamp beginTx) {
        return beginTx.subtractPhysicalTime(this.idleSafeTimePropagationPeriodMsSupplier.getAsLong() + this.clockService.maxClockSkewMillis());
    }

    @Override
    @Nullable
    public TxStateMeta stateMeta(UUID txId) {
        return this.txStateVolatileStorage.state(txId);
    }

    @TestOnly
    public Collection<TxStateMeta> states() {
        return this.txStateVolatileStorage.states();
    }

    @Override
    @Nullable
    public <T extends TxStateMeta> T updateTxMeta(UUID txId, Function<@Nullable TxStateMeta, TxStateMeta> updater) {
        return this.txStateVolatileStorage.updateMeta(txId, updater);
    }

    @Override
    public void finishFull(HybridTimestampTracker timestampTracker, UUID txId, @Nullable HybridTimestamp ts, boolean commit) {
        TxState finalState;
        this.finishedTxs.add(1L);
        if (commit) {
            assert (ts != null) : "RW transaction commit timestamp cannot be null.";
            timestampTracker.update(ts);
            finalState = TxState.COMMITTED;
        } else {
            finalState = TxState.ABORTED;
        }
        this.updateTxMeta(txId, old -> new TxStateMeta(finalState, old == null ? null : old.txCoordinatorId(), old == null ? null : old.commitPartitionId(), ts));
        this.decrementRwTxCount(txId);
    }

    @Nullable
    private HybridTimestamp commitTimestamp(boolean commit) {
        return commit ? this.clockService.now() : null;
    }

    @Override
    public CompletableFuture<Void> finish(HybridTimestampTracker observableTimestampTracker, TablePartitionId commitPartition, boolean commitIntent, Map<TablePartitionId, IgniteBiTuple<ClusterNode, Long>> enlistedGroups, UUID txId) {
        Object stateMeta;
        LOG.debug("Finish [commit={}, txId={}, groups={}].", new Object[]{commitIntent, txId, enlistedGroups});
        this.finishedTxs.add(1L);
        assert (enlistedGroups != null);
        if (enlistedGroups.isEmpty()) {
            this.updateTxMeta(txId, old -> new TxStateMeta(commitIntent ? TxState.COMMITTED : TxState.ABORTED, this.localNodeId, commitPartition, this.commitTimestamp(commitIntent)));
            this.decrementRwTxCount(txId);
            return CompletableFutures.nullCompletedFuture();
        }
        TxStateMeta txMeta = this.stateMeta(txId);
        TxStateMetaFinishing finishingStateMeta = txMeta == null ? new TxStateMetaFinishing(null, commitPartition) : txMeta.finishing();
        if (finishingStateMeta != (stateMeta = this.updateTxMeta(txId, oldMeta -> finishingStateMeta))) {
            if (((TxStateMeta)stateMeta).txState() == TxState.FINISHING) {
                return ((TxStateMetaFinishing)stateMeta).txFinishFuture().thenCompose(meta -> TxManagerImpl.checkTxOutcome(commitIntent, txId, meta));
            }
            return TxManagerImpl.checkTxOutcome(commitIntent, txId, stateMeta);
        }
        TransactionInflights.ReadWriteTxContext txContext = this.transactionInflights.lockTxForNewUpdates(txId, enlistedGroups);
        return ((CompletableFuture)txContext.performFinish(commitIntent, commit -> this.prepareFinish(observableTimestampTracker, commitPartition, (boolean)commit, enlistedGroups, txId, finishingStateMeta.txFinishFuture())).thenAccept(unused -> {
            if (this.localNodeId.equals(finishingStateMeta.txCoordinatorId())) {
                this.decrementRwTxCount(txId);
            }
        })).whenComplete((unused, throwable) -> this.transactionInflights.removeTxContext(txId));
    }

    private static CompletableFuture<Void> checkTxOutcome(boolean commit, UUID txId, TransactionMeta stateMeta) {
        if (stateMeta.txState() == TxState.COMMITTED == commit) {
            return CompletableFutures.nullCompletedFuture();
        }
        return CompletableFuture.failedFuture((Throwable)((Object)new MismatchingTransactionOutcomeInternalException("Failed to change the outcome of a finished transaction [txId=" + String.valueOf(txId) + ", txState=" + String.valueOf((Object)stateMeta.txState()) + "].", new TransactionResult(stateMeta.txState(), stateMeta.commitTimestamp()))));
    }

    private CompletableFuture<Void> prepareFinish(HybridTimestampTracker observableTimestampTracker, TablePartitionId commitPartition, boolean commit, Map<TablePartitionId, IgniteBiTuple<ClusterNode, Long>> enlistedGroups, UUID txId, CompletableFuture<TransactionMeta> txFinishFuture) {
        HybridTimestamp commitTimestamp = this.commitTimestamp(commit);
        CompletableFuture<Void> verificationFuture = commit ? this.verifyCommitTimestamp(enlistedGroups, commitTimestamp) : CompletableFutures.nullCompletedFuture();
        return ((CompletableFuture)((CompletableFuture)verificationFuture.handle((unused, throwable) -> {
            boolean verifiedCommit = throwable == null && commit;
            Map<TablePartitionId, String> replicationGroupIds = enlistedGroups.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ClusterNode)((IgniteBiTuple)entry.getValue()).get1()).name()));
            return this.durableFinish(observableTimestampTracker, commitPartition, verifiedCommit, replicationGroupIds, txId, commitTimestamp, txFinishFuture);
        })).thenCompose(Function.identity())).thenCompose(r -> verificationFuture);
    }

    private CompletableFuture<Void> durableFinish(HybridTimestampTracker observableTimestampTracker, TablePartitionId commitPartition, boolean commit, Map<TablePartitionId, String> replicationGroupIds, UUID txId, HybridTimestamp commitTimestamp, CompletableFuture<TransactionMeta> txFinishFuture) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> ((CompletableFuture)((CompletableFuture)this.placementDriverHelper.awaitPrimaryReplicaWithExceptionHandling(commitPartition).thenCompose(meta -> this.makeFinishRequest(observableTimestampTracker, commitPartition, meta.getLeaseholder(), meta.getStartTime().longValue(), commit, replicationGroupIds, txId, commitTimestamp, txFinishFuture))).handle((res, ex) -> {
            if (ex != null) {
                Throwable cause = ExceptionUtils.unwrapCause((Throwable)ex);
                if (cause instanceof MismatchingTransactionOutcomeInternalException) {
                    MismatchingTransactionOutcomeInternalException transactionException = (MismatchingTransactionOutcomeInternalException)((Object)((Object)((Object)cause)));
                    TransactionResult result = transactionException.transactionResult();
                    Object updatedMeta = this.updateTxMeta(txId, old -> new TxStateMeta(result.transactionState(), old == null ? null : old.txCoordinatorId(), commitPartition, result.commitTimestamp(), old == null ? null : old.initialVacuumObservationTimestamp(), old == null ? null : old.cleanupCompletionTimestamp()));
                    txFinishFuture.complete((TransactionMeta)updatedMeta);
                    return CompletableFuture.failedFuture(cause);
                }
                if (TransactionFailureHandler.isRecoverable(cause)) {
                    LOG.warn("Failed to finish Tx. The operation will be retried [txId={}].", ex, new Object[]{txId});
                    return CompletableFuture.supplyAsync(() -> this.durableFinish(observableTimestampTracker, commitPartition, commit, replicationGroupIds, txId, commitTimestamp, txFinishFuture), this.partitionOperationsExecutor).thenCompose(Function.identity());
                }
                LOG.warn("Failed to finish Tx [txId={}].", ex, new Object[]{txId});
                return CompletableFuture.failedFuture(cause);
            }
            return CompletableFutures.nullCompletedFuture();
        })).thenCompose(Function.identity()));
    }

    private CompletableFuture<Void> makeFinishRequest(HybridTimestampTracker observableTimestampTracker, TablePartitionId commitPartition, String primaryConsistentId, Long enlistmentConsistencyToken, boolean commit, Map<TablePartitionId, String> replicationGroupIds, UUID txId, HybridTimestamp commitTimestamp, CompletableFuture<TransactionMeta> txFinishFuture) {
        LOG.debug("Finish [partition={}, node={}, enlistmentConsistencyToken={} commit={}, txId={}, groups={}", new Object[]{commitPartition, primaryConsistentId, enlistmentConsistencyToken, commit, txId, replicationGroupIds});
        return this.txMessageSender.finish(primaryConsistentId, commitPartition, replicationGroupIds, txId, enlistmentConsistencyToken, commit, commitTimestamp).thenAccept(txResult -> {
            TxManagerImpl.validateTxFinishedAsExpected(commit, txId, txResult);
            Object updatedMeta = this.updateTxMeta(txId, old -> new TxStateMeta(txResult.transactionState(), this.localNodeId, old == null ? null : old.commitPartitionId(), txResult.commitTimestamp(), old == null ? null : old.initialVacuumObservationTimestamp(), old == null ? null : old.cleanupCompletionTimestamp()));
            assert (TxState.isFinalState(((TxStateMeta)updatedMeta).txState())) : "Unexpected transaction state [id=" + String.valueOf(txId) + ", state=" + String.valueOf((Object)((TxStateMeta)updatedMeta).txState()) + "].";
            txFinishFuture.complete((TransactionMeta)updatedMeta);
            if (commit) {
                observableTimestampTracker.update(commitTimestamp);
            }
        });
    }

    private static void validateTxFinishedAsExpected(boolean commit, UUID txId, TransactionResult txResult) {
        if (commit != (txResult.transactionState() == TxState.COMMITTED)) {
            LOG.error("Failed to finish a transaction that is already finished [txId={}, expectedState={}, actualState={}].", new Object[]{txId, commit ? TxState.COMMITTED : TxState.ABORTED, txResult.transactionState()});
            throw new MismatchingTransactionOutcomeInternalException("Failed to change the outcome of a finished transaction [txId=" + String.valueOf(txId) + ", txState=" + String.valueOf((Object)txResult.transactionState()) + "].", txResult);
        }
    }

    @Override
    public int finished() {
        return this.finishedTxs.intValue();
    }

    @Override
    public int pending() {
        return this.startedTxs.intValue() - this.finishedTxs.intValue();
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            DeadlockPreventionPolicyImpl deadlockPreventionPolicy = new DeadlockPreventionPolicyImpl((String)this.txConfig.deadlockPreventionPolicy().txIdComparator().value(), (long)((Long)this.txConfig.deadlockPreventionPolicy().waitTimeout().value()));
            this.lockManager.start(deadlockPreventionPolicy);
            this.localNodeId = this.topologyService.localMember().id();
            this.messagingService.addMessageHandler(ReplicaMessageGroup.class, (NetworkMessageHandler)this);
            this.persistentTxStateVacuumizer = new PersistentTxStateVacuumizer(this.replicaService, this.topologyService.localMember(), this.clockService, this.placementDriver);
            this.txStateVolatileStorage.start();
            this.txViewProvider.init(this.localNodeId, this.lowWatermark.lockIds(), this.txStateVolatileStorage.statesMap());
            this.orphanDetector.start(this.txStateVolatileStorage, this.txConfig.abandonedCheckTs());
            this.txCleanupRequestSender.start();
            this.txCleanupRequestHandler.start();
            this.placementDriver.listen((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_EXPIRED, this.primaryReplicaExpiredListener);
            this.placementDriver.listen((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_ELECTED, this.primaryReplicaElectedListener);
            this.transactionExpirationJobFuture = this.commonScheduler.scheduleAtFixedRate(this::expireTransactionsUpToNow, 1000L, 1000L, TimeUnit.MILLISECONDS);
            return CompletableFutures.nullCompletedFuture();
        });
    }

    private void expireTransactionsUpToNow() {
        HybridTimestamp expirationTime = null;
        try {
            expirationTime = this.clockService.current();
            this.transactionExpirationRegistry.expireUpTo(expirationTime.getPhysical());
        }
        catch (Throwable t) {
            LOG.error("Could not expire transactions up to {}", t, new Object[]{expirationTime});
        }
    }

    public void beforeNodeStop() {
        this.orphanDetector.stop();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        this.txStateVolatileStorage.stop();
        this.txCleanupRequestHandler.stop();
        this.placementDriver.removeListener((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_EXPIRED, this.primaryReplicaExpiredListener);
        this.placementDriver.removeListener((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_ELECTED, this.primaryReplicaElectedListener);
        ScheduledFuture<?> expirationJobFuture = this.transactionExpirationJobFuture;
        if (expirationJobFuture != null) {
            expirationJobFuture.cancel(false);
        }
        this.transactionExpirationRegistry.abortAllRegistered();
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.writeIntentSwitchPool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public LockManager lockManager() {
        return this.lockManager;
    }

    @Override
    public CompletableFuture<Void> cleanup(TablePartitionId commitPartitionId, Map<TablePartitionId, String> enlistedPartitions, boolean commit, @Nullable HybridTimestamp commitTimestamp, UUID txId) {
        return this.txCleanupRequestSender.cleanup(commitPartitionId, enlistedPartitions, commit, commitTimestamp, txId);
    }

    @Override
    public CompletableFuture<Void> cleanup(TablePartitionId commitPartitionId, Collection<TablePartitionId> enlistedPartitions, boolean commit, @Nullable HybridTimestamp commitTimestamp, UUID txId) {
        return this.txCleanupRequestSender.cleanup(commitPartitionId, enlistedPartitions, commit, commitTimestamp, txId);
    }

    @Override
    public CompletableFuture<Void> cleanup(TablePartitionId commitPartitionId, String node, UUID txId) {
        return this.txCleanupRequestSender.cleanup(commitPartitionId, node, txId);
    }

    @Override
    public CompletableFuture<Void> vacuum() {
        if (this.persistentTxStateVacuumizer == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        long vacuumObservationTimestamp = System.currentTimeMillis();
        return this.txStateVolatileStorage.vacuum(vacuumObservationTimestamp, (Long)this.txConfig.txnResourceTtl().value(), this.persistentTxStateVacuumizer::vacuumPersistentTxStates);
    }

    @Override
    public CompletableFuture<Void> executeWriteIntentSwitchAsync(Runnable runnable) {
        return CompletableFuture.runAsync(runnable, this.writeIntentSwitchPool);
    }

    void completeReadOnlyTransactionFuture(TxIdAndTimestamp txIdAndTimestamp) {
        this.finishedTxs.add(1L);
        UUID txId = txIdAndTimestamp.getTxId();
        this.transactionInflights.markReadOnlyTxFinished(txId);
    }

    public void onReceived(NetworkMessage message, ClusterNode sender, @Nullable Long correlationId) {
        if (!(message instanceof ReplicaResponse) || correlationId != null) {
            return;
        }
        if (message instanceof ErrorReplicaResponse) {
            return;
        }
        ReplicaResponse response = (ReplicaResponse)message;
        Object result = response.result();
        if (result instanceof UUID) {
            this.transactionInflights.removeInflight((UUID)result);
        }
        if (result instanceof WriteIntentSwitchReplicatedInfo) {
            this.txCleanupRequestHandler.writeIntentSwitchReplicated((WriteIntentSwitchReplicatedInfo)result);
        }
    }

    private CompletableFuture<Void> verifyCommitTimestamp(Map<TablePartitionId, IgniteBiTuple<ClusterNode, Long>> enlistedGroups, HybridTimestamp commitTimestamp) {
        CompletableFuture[] verificationFutures = new CompletableFuture[enlistedGroups.size()];
        int cnt = -1;
        for (Map.Entry<TablePartitionId, IgniteBiTuple<ClusterNode, Long>> enlistedGroup : enlistedGroups.entrySet()) {
            TablePartitionId groupId = enlistedGroup.getKey();
            Long expectedEnlistmentConsistencyToken = (Long)enlistedGroup.getValue().get2();
            verificationFutures[++cnt] = this.placementDriver.getPrimaryReplica((ReplicationGroupId)groupId, commitTimestamp).thenAccept(currentPrimaryReplica -> {
                if (currentPrimaryReplica == null || !expectedEnlistmentConsistencyToken.equals(currentPrimaryReplica.getStartTime().longValue())) {
                    throw new PrimaryReplicaExpiredException((ReplicationGroupId)groupId, expectedEnlistmentConsistencyToken, commitTimestamp, (ReplicaMeta)currentPrimaryReplica);
                }
                assert (commitTimestamp.compareTo(currentPrimaryReplica.getExpirationTime()) <= 0) : IgniteStringFormatter.format((String)"Commit timestamp is greater than primary replica expiration timestamp: [groupId = {}, commit timestamp = {}, primary replica expiration timestamp = {}]", (Object[])new Object[]{groupId, commitTimestamp, currentPrimaryReplica.getExpirationTime()});
            });
        }
        return CompletableFuture.allOf(verificationFutures);
    }

    public List<SystemView<?>> systemViews() {
        LocksViewProvider lockViewProvider = new LocksViewProvider(this.lockManager::locks);
        return List.of(this.txViewProvider.get(), lockViewProvider.get());
    }

    private HybridTimestamp createBeginTimestampWithIncrementRwTxCounter() {
        return this.localRwTxCounter.inUpdateRwTxCountLock(() -> {
            HybridTimestamp beginTs = this.clockService.now();
            this.localRwTxCounter.incrementRwTxCount(beginTs);
            return beginTs;
        });
    }

    private void decrementRwTxCount(UUID txId) {
        this.localRwTxCounter.inUpdateRwTxCountLock(() -> {
            this.localRwTxCounter.decrementRwTxCount(TransactionIds.beginTimestamp(txId));
            return null;
        });
    }

    static class TransactionFailureHandler {
        private static final Set<Class<? extends Throwable>> RECOVERABLE = Set.of(TimeoutException.class, IOException.class, ReplicationException.class, ReplicationTimeoutException.class, PrimaryReplicaMissException.class);

        TransactionFailureHandler() {
        }

        static boolean isRecoverable(Throwable throwable) {
            if (throwable == null) {
                return false;
            }
            Throwable candidate = ExceptionUtils.unwrapCause((Throwable)throwable);
            for (Class<? extends Throwable> recoverableClass : RECOVERABLE) {
                if (!recoverableClass.isAssignableFrom(candidate.getClass())) continue;
                return true;
            }
            return false;
        }
    }
}

