/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb;

import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import org.apache.ignite.internal.storage.rocksdb.IgniteRocksDbException;
import org.apache.ignite.internal.storage.rocksdb.RocksDbStorageUtils;
import org.apache.ignite.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

public class IndexIdCursor
implements Cursor<TableAndIndexId> {
    private final RocksIterator it;
    @Nullable
    private final Integer tableId;
    @Nullable
    private ByteBuffer curIndexId = null;
    private boolean hasNext = true;

    public IndexIdCursor(RocksIterator it, @Nullable Integer tableId) {
        this.it = it;
        this.tableId = tableId;
    }

    public boolean hasNext() {
        if (!this.hasNext) {
            return false;
        }
        if (this.curIndexId == null) {
            this.positionToFirst();
        } else if (this.setNextIndexId()) {
            this.positionToNext();
        } else {
            this.hasNext = false;
            return false;
        }
        this.hasNext = this.it.isValid();
        if (!this.hasNext) {
            try {
                this.it.status();
            }
            catch (RocksDBException e) {
                throw new IgniteRocksDbException(e);
            }
        }
        return this.hasNext;
    }

    private void positionToFirst() {
        this.curIndexId = ByteBuffer.allocate(8).order(RocksDbStorageUtils.KEY_BYTE_ORDER);
        if (this.tableId != null) {
            this.curIndexId.putInt(0, this.tableId);
            this.it.seek(this.curIndexId);
            this.curIndexId.rewind();
        } else {
            this.it.seekToFirst();
        }
    }

    private void positionToNext() {
        assert (this.curIndexId != null);
        this.it.seek(this.curIndexId);
        this.curIndexId.rewind();
    }

    public TableAndIndexId next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        assert (this.curIndexId != null);
        this.it.key(this.curIndexId);
        this.curIndexId.rewind();
        return new TableAndIndexId(this.curIndexId.getInt(0), this.curIndexId.getInt(4));
    }

    public void close() {
        this.it.close();
    }

    private boolean setNextIndexId() {
        assert (this.curIndexId != null);
        for (int i = this.curIndexId.remaining() - 1; i >= 0; --i) {
            byte b = (byte)(this.curIndexId.get(i) + 1);
            this.curIndexId.put(i, b);
            if (b == 0) continue;
            return true;
        }
        return false;
    }

    public static class TableAndIndexId {
        static final int BYTES = 8;
        private final int tableId;
        private final int indexId;

        TableAndIndexId(int tableId, int indexId) {
            this.tableId = tableId;
            this.indexId = indexId;
        }

        public int tableId() {
            return this.tableId;
        }

        public int indexId() {
            return this.indexId;
        }
    }
}

