/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.sql.engine.metadata.IgniteMdRowCount;
import org.apache.ignite.internal.sql.engine.trait.DistributionFunction;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.trait.TraitsAwareIgniteRel;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.util.CollectionUtils;

public abstract class AbstractIgniteJoin
extends Join
implements TraitsAwareIgniteRel {
    protected AbstractIgniteJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        super(cluster, traitSet, List.of(), left, right, condition, variablesSet, joinType);
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet left = inputTraits.get(0);
        RelTraitSet right = inputTraits.get(1);
        RelCollation collation = TraitUtils.collation(left);
        if (this.joinType == JoinRelType.RIGHT || this.joinType == JoinRelType.FULL) {
            for (RelFieldCollation field : collation.getFieldCollations()) {
                if (RelFieldCollation.NullDirection.LAST.nullComparison == field.nullDirection.nullComparison) continue;
                collation = RelCollations.EMPTY;
                break;
            }
        }
        RelTraitSet outTraits = nodeTraits.replace((RelTrait)collation);
        RelTraitSet leftTraits = left.replace((RelTrait)collation);
        RelTraitSet rightTraits = right.replace((RelTrait)RelCollations.EMPTY);
        return List.of(Pair.of((Object)outTraits, List.of(leftTraits, rightTraits)));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet rightTraits;
        RelTraitSet leftTraits;
        RelTraitSet outTraits;
        RelTraitSet left = inputTraits.get(0);
        RelTraitSet right = inputTraits.get(1);
        ArrayList<Pair> res = new ArrayList<Pair>();
        IgniteDistribution leftDistr = TraitUtils.distribution(left);
        IgniteDistribution rightDistr = TraitUtils.distribution(right);
        IgniteDistribution left2rightProjectedDistr = leftDistr.apply(this.buildTransposeMapping(true));
        IgniteDistribution right2leftProjectedDistr = rightDistr.apply(this.buildTransposeMapping(false));
        if (leftDistr == IgniteDistributions.broadcast() && rightDistr == IgniteDistributions.broadcast()) {
            outTraits = nodeTraits.replace((RelTrait)IgniteDistributions.broadcast());
            leftTraits = left.replace((RelTrait)IgniteDistributions.broadcast());
            rightTraits = right.replace((RelTrait)IgniteDistributions.broadcast());
        } else {
            outTraits = nodeTraits.replace((RelTrait)IgniteDistributions.single());
            leftTraits = left.replace((RelTrait)IgniteDistributions.single());
            rightTraits = right.replace((RelTrait)IgniteDistributions.single());
        }
        res.add(Pair.of((Object)outTraits, List.of(leftTraits, rightTraits)));
        if (CollectionUtils.nullOrEmpty((Collection)this.joinInfo.pairs())) {
            return List.copyOf(res);
        }
        if (leftDistr.getType() == RelDistribution.Type.HASH_DISTRIBUTED && left2rightProjectedDistr != IgniteDistributions.random()) {
            outTraits = nodeTraits.replace((RelTrait)leftDistr);
            leftTraits = left.replace((RelTrait)leftDistr);
            rightTraits = right.replace((RelTrait)left2rightProjectedDistr);
            res.add(Pair.of((Object)outTraits, List.of(leftTraits, rightTraits)));
        }
        if (rightDistr.getType() == RelDistribution.Type.HASH_DISTRIBUTED && right2leftProjectedDistr != IgniteDistributions.random()) {
            outTraits = nodeTraits.replace((RelTrait)rightDistr);
            leftTraits = left.replace((RelTrait)right2leftProjectedDistr);
            rightTraits = right.replace((RelTrait)rightDistr);
            res.add(Pair.of((Object)outTraits, List.of(leftTraits, rightTraits)));
        }
        leftTraits = left.replace((RelTrait)IgniteDistributions.hash((List<Integer>)this.joinInfo.leftKeys, DistributionFunction.hash()));
        rightTraits = right.replace((RelTrait)IgniteDistributions.hash((List<Integer>)this.joinInfo.rightKeys, DistributionFunction.hash()));
        outTraits = nodeTraits.replace((RelTrait)IgniteDistributions.hash((List<Integer>)this.joinInfo.leftKeys, DistributionFunction.hash()));
        res.add(Pair.of((Object)outTraits, List.of(leftTraits, rightTraits)));
        outTraits = nodeTraits.replace((RelTrait)IgniteDistributions.hash((List<Integer>)this.joinInfo.rightKeys, DistributionFunction.hash()));
        res.add(Pair.of((Object)outTraits, List.of(leftTraits, rightTraits)));
        return List.copyOf(res);
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelCollation collation = TraitUtils.collation(nodeTraits);
        RelTraitSet left = inputTraits.get(0);
        RelTraitSet right = inputTraits.get(1);
        if (collation.equals((Object)RelCollations.EMPTY)) {
            return Pair.of((Object)nodeTraits, List.of(left.replace((RelTrait)RelCollations.EMPTY), right.replace((RelTrait)RelCollations.EMPTY)));
        }
        if (!this.projectsLeft(collation)) {
            collation = RelCollations.EMPTY;
        } else if (this.joinType == JoinRelType.RIGHT || this.joinType == JoinRelType.FULL) {
            for (RelFieldCollation field : collation.getFieldCollations()) {
                if (RelFieldCollation.NullDirection.LAST.nullComparison == field.nullDirection.nullComparison) continue;
                collation = RelCollations.EMPTY;
                break;
            }
        }
        return Pair.of((Object)nodeTraits.replace((RelTrait)collation), List.of(left.replace((RelTrait)collation), right.replace((RelTrait)RelCollations.EMPTY)));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet left = inputTraits.get(0);
        RelTraitSet right = inputTraits.get(1);
        IgniteDistribution distribution = TraitUtils.distribution(nodeTraits);
        RelDistribution.Type distrType = distribution.getType();
        switch (distrType) {
            case BROADCAST_DISTRIBUTED: 
            case SINGLETON: {
                return Pair.of((Object)nodeTraits, Commons.transform(inputTraits, t -> t.replace((RelTrait)distribution)));
            }
            case HASH_DISTRIBUTED: 
            case RANDOM_DISTRIBUTED: {
                if (CollectionUtils.nullOrEmpty((Collection)this.joinInfo.pairs())) break;
                DistributionFunction function = distrType == RelDistribution.Type.HASH_DISTRIBUTED ? distribution.function() : DistributionFunction.hash();
                IgniteDistribution outDistr = IgniteDistributions.hash((List<Integer>)this.joinInfo.leftKeys, function);
                if (distrType == RelDistribution.Type.HASH_DISTRIBUTED && !outDistr.satisfies((RelTrait)distribution)) break;
                return Pair.of((Object)nodeTraits.replace((RelTrait)outDistr), List.of(left.replace((RelTrait)outDistr), right.replace((RelTrait)IgniteDistributions.hash((List<Integer>)this.joinInfo.rightKeys, function))));
            }
        }
        return Pair.of((Object)nodeTraits.replace((RelTrait)IgniteDistributions.single()), Commons.transform(inputTraits, t -> t.replace((RelTrait)IgniteDistributions.single())));
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return Util.first((Double)IgniteMdRowCount.joinRowCount(mq, this), (double)1.0);
    }

    protected boolean projectsLeft(RelCollation collation) {
        int leftFieldCount = this.getLeft().getRowType().getFieldCount();
        Iterator iterator = RelCollations.ordinals((RelCollation)collation).iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            if (field < leftFieldCount) continue;
            return false;
        }
        return true;
    }

    protected Mappings.TargetMapping buildTransposeMapping(boolean left2Right) {
        ImmutableIntList sourceKeys = left2Right ? this.joinInfo.leftKeys : this.joinInfo.rightKeys;
        ImmutableIntList targetKeys = left2Right ? this.joinInfo.rightKeys : this.joinInfo.leftKeys;
        HashMap<Integer, Integer> keyMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.joinInfo.leftKeys.size(); ++i) {
            keyMap.put(sourceKeys.get(i), targetKeys.get(i));
        }
        return Mappings.target(keyMap, (int)(left2Right ? this.left : this.right).getRowType().getFieldCount(), (int)(left2Right ? this.right : this.left).getRowType().getFieldCount());
    }
}

