/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.tx;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.sql.engine.exec.TransactionTracker;
import org.apache.ignite.internal.sql.engine.tx.QueryTransactionWrapper;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.CompletableFutures;

public class QueryTransactionWrapperImpl
implements QueryTransactionWrapper {
    private final boolean queryImplicit;
    private final InternalTransaction transaction;
    private final TransactionTracker txTracker;
    private final AtomicBoolean committedImplicit = new AtomicBoolean();

    public QueryTransactionWrapperImpl(InternalTransaction transaction, boolean implicit, TransactionTracker txTracker) {
        this.transaction = transaction;
        this.queryImplicit = implicit;
        this.txTracker = txTracker;
    }

    @Override
    public InternalTransaction unwrap() {
        return this.transaction;
    }

    @Override
    public CompletableFuture<Void> commitImplicit() {
        if (this.transaction.isReadOnly() && this.committedImplicit.compareAndSet(false, true)) {
            this.txTracker.unregister(this.transaction.id());
        }
        if (this.queryImplicit) {
            return this.transaction.commitAsync();
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> rollback(Throwable cause) {
        return this.transaction.rollbackAsync();
    }

    @Override
    public boolean implicit() {
        return this.queryImplicit;
    }
}

