/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.index;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.index.IndexBuildCompletionListener;
import org.apache.ignite.internal.index.IndexBuildTask;
import org.apache.ignite.internal.index.IndexBuildTaskId;
import org.apache.ignite.internal.replicator.ReplicaService;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.index.IndexStorage;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.network.ClusterNode;

class IndexBuilder
implements ManuallyCloseable {
    static final int BATCH_SIZE = 100;
    private final Executor executor;
    private final ReplicaService replicaService;
    private final Map<IndexBuildTaskId, IndexBuildTask> indexBuildTaskById = new ConcurrentHashMap<IndexBuildTaskId, IndexBuildTask>();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean closeGuard = new AtomicBoolean();
    private final List<IndexBuildCompletionListener> listeners = new CopyOnWriteArrayList<IndexBuildCompletionListener>();

    IndexBuilder(Executor executor, ReplicaService replicaService) {
        this.replicaService = replicaService;
        this.executor = executor;
    }

    public void scheduleBuildIndex(int tableId, int partitionId, int indexId, IndexStorage indexStorage, MvPartitionStorage partitionStorage, ClusterNode node, long enlistmentConsistencyToken) {
        IgniteUtils.inBusyLockSafe((IgniteSpinBusyLock)this.busyLock, () -> {
            if (indexStorage.getNextRowIdToBuild() == null) {
                for (IndexBuildCompletionListener listener : this.listeners) {
                    listener.onBuildCompletion(indexId, tableId, partitionId);
                }
                return;
            }
            IndexBuildTaskId taskId = new IndexBuildTaskId(tableId, partitionId, indexId);
            IndexBuildTask newTask = new IndexBuildTask(taskId, indexStorage, partitionStorage, this.replicaService, this.executor, this.busyLock, 100, node, this.listeners, enlistmentConsistencyToken, false);
            this.putAndStartTaskIfAbsent(taskId, newTask);
        });
    }

    public void scheduleBuildIndexAfterDisasterRecovery(int tableId, int partitionId, int indexId, IndexStorage indexStorage, MvPartitionStorage partitionStorage, ClusterNode node, long enlistmentConsistencyToken) {
        IgniteUtils.inBusyLockSafe((IgniteSpinBusyLock)this.busyLock, () -> {
            if (indexStorage.getNextRowIdToBuild() == null) {
                return;
            }
            IndexBuildTaskId taskId = new IndexBuildTaskId(tableId, partitionId, indexId);
            IndexBuildTask newTask = new IndexBuildTask(taskId, indexStorage, partitionStorage, this.replicaService, this.executor, this.busyLock, 100, node, this.listeners, enlistmentConsistencyToken, true);
            this.putAndStartTaskIfAbsent(taskId, newTask);
        });
    }

    public void stopBuildIndex(int tableId, int partitionId, int indexId) {
        IgniteUtils.inBusyLockSafe((IgniteSpinBusyLock)this.busyLock, () -> {
            IndexBuildTask removed = this.indexBuildTaskById.remove(new IndexBuildTaskId(tableId, partitionId, indexId));
            if (removed != null) {
                removed.stop();
            }
        });
    }

    public void stopBuildingIndexes(int tableId, int partitionId) {
        this.stopBuildingIndexes(taskId -> tableId == taskId.getTableId() && partitionId == taskId.getPartitionId());
    }

    public void stopBuildingIndexes(int indexId) {
        this.stopBuildingIndexes(taskId -> indexId == taskId.getIndexId());
    }

    private void stopBuildingIndexes(Predicate<IndexBuildTaskId> stopBuildIndexPredicate) {
        Iterator<Map.Entry<IndexBuildTaskId, IndexBuildTask>> it = this.indexBuildTaskById.entrySet().iterator();
        while (it.hasNext()) {
            IgniteUtils.inBusyLockSafe((IgniteSpinBusyLock)this.busyLock, () -> {
                Map.Entry entry = (Map.Entry)it.next();
                if (stopBuildIndexPredicate.test((IndexBuildTaskId)entry.getKey())) {
                    it.remove();
                    ((IndexBuildTask)entry.getValue()).stop();
                }
            });
        }
    }

    public void close() {
        if (!this.closeGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
    }

    public void listen(IndexBuildCompletionListener listener) {
        this.listeners.add(listener);
    }

    public void stopListen(IndexBuildCompletionListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAndStartTaskIfAbsent(IndexBuildTaskId taskId, IndexBuildTask task) {
        IndexBuildTask previousTask = this.indexBuildTaskById.putIfAbsent(taskId, task);
        if (previousTask != null) {
            return;
        }
        try {
            task.start();
        }
        finally {
            task.getTaskFuture().whenComplete((unused, throwable) -> this.indexBuildTaskById.remove(taskId));
        }
    }
}

