/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.postprocessors;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import java.util.HashMap;

public class OpenApiOperationsPostProcessor {
    public void processOperations(OpenAPI openAPI) {
        if (openAPI.getPaths() == null) {
            return;
        }
        HashMap operationIdsIndex = new HashMap();
        openAPI.getPaths().values().stream().flatMap(pathItem -> pathItem.readOperations().stream()).forEach(operation -> {
            String operationId = operation.getOperationId();
            if (operationIdsIndex.containsKey(operationId)) {
                int nextValue = (Integer)operationIdsIndex.get(operationId);
                String newOperationId = operationId + '_' + nextValue;
                operation.setOperationId(newOperationId);
                OpenApiOperationsPostProcessor.updateResponseDescription(operation, operationId, newOperationId);
                operationIdsIndex.put(operationId, ++nextValue);
            } else {
                operationIdsIndex.put(operationId, 1);
            }
        });
    }

    private static void updateResponseDescription(Operation operation, String originalId, String newOperationId) {
        if (operation.getResponses() != null) {
            operation.getResponses().values().stream().filter(apiResponse -> apiResponse != null && apiResponse.getDescription() != null).forEach(apiResponse -> apiResponse.setDescription(apiResponse.getDescription().replaceFirst(originalId, newOperationId)));
        }
    }
}

