/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.config;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.context.ServerContextPathProvider;
import io.micronaut.security.config.InterceptUrlMapPattern;
import io.micronaut.security.config.InterceptUrlPatternModifier;
import io.micronaut.security.config.SecurityConfiguration;
import io.micronaut.security.config.ServerContextPathProviderUtils;
import jakarta.inject.Singleton;

@Singleton
public class DefaultInterceptUrlPatternModifier
implements InterceptUrlPatternModifier {
    private final SecurityConfiguration securityConfiguration;
    private final ServerContextPathProvider serverContextPathProvider;

    public DefaultInterceptUrlPatternModifier(SecurityConfiguration securityConfiguration, ServerContextPathProvider serverContextPathProvider) {
        this.securityConfiguration = securityConfiguration;
        this.serverContextPathProvider = serverContextPathProvider;
    }

    @Override
    @NonNull
    public InterceptUrlMapPattern modify(@NonNull InterceptUrlMapPattern interceptUrlMapPattern) {
        if (this.securityConfiguration.isInterceptUrlMapPrependPatternWithContextPath()) {
            return new InterceptUrlMapPattern(ServerContextPathProviderUtils.prependContextPath(interceptUrlMapPattern.getPattern(), this.serverContextPathProvider), interceptUrlMapPattern.getAccess(), interceptUrlMapPattern.getHttpMethod().orElse(null));
        }
        return interceptUrlMapPattern;
    }
}

