/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.entity;

import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.raft.jraft.entity.EntryMetaImpl;
import org.apache.ignite.raft.jraft.entity.RaftOutter;

class EntryMetaSerializer
implements MessageSerializer<RaftOutter.EntryMeta> {
    public static final EntryMetaSerializer INSTANCE = new EntryMetaSerializer();

    private EntryMetaSerializer() {
    }

    public boolean writeMessage(RaftOutter.EntryMeta msg, MessageWriter writer) throws MessageMappingException {
        EntryMetaImpl message = (EntryMetaImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)9)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeLong("checksum", message.checksum());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeLong("dataLen", message.dataLen());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeBoolean("hasChecksum", message.hasChecksum());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeCollection("learnersList", message.learnersList(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeCollection("oldLearnersList", message.oldLearnersList(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeCollection("oldPeersList", message.oldPeersList(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeCollection("peersList", message.peersList(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                boolean written = writer.writeLong("term", message.term());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                int ordinalShifted = message.type() == null ? 0 : message.type().ordinal() + 1;
                boolean written = writer.writeInt("type", ordinalShifted);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

