/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl;

import java.util.concurrent.Executor;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite.raft.jraft.rpc.RpcContext;
import org.apache.ignite.raft.jraft.rpc.RpcProcessor;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

public class PingRequestProcessor
implements RpcProcessor<RpcRequests.PingRequest> {
    private static final IgniteLogger LOG = Loggers.forClass(PingRequestProcessor.class);
    private final Executor executor;
    private final RaftMessagesFactory msgFactory;

    public PingRequestProcessor(Executor executor, RaftMessagesFactory msgFactory) {
        this.executor = executor;
        this.msgFactory = msgFactory;
    }

    @Override
    public void handleRequest(RpcContext rpcCtx, RpcRequests.PingRequest request) {
        LOG.debug("Pinged from={}", new Object[]{rpcCtx.getRemoteAddress()});
        rpcCtx.sendResponse(RaftRpcFactory.DEFAULT.newResponse(this.msgFactory, 0, "OK", new Object[0]));
    }

    @Override
    public String interest() {
        return RpcRequests.PingRequest.class.getName();
    }

    @Override
    public Executor executor() {
        return this.executor;
    }
}

