/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.ReflectGenericPlaceholderElement;
import io.micronaut.inject.ast.ReflectTypeElement;
import java.lang.reflect.Array;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Internal
class ReflectClassElement
extends ReflectTypeElement<Class<?>> {
    ReflectClassElement(Class<?> type) {
        super(type);
    }

    @Override
    public boolean isArray() {
        return ((Class)this.type).isArray();
    }

    @Override
    public int getArrayDimensions() {
        return this.computeDimensions((Class)this.type);
    }

    private int computeDimensions(Class<?> type) {
        int i = 0;
        while (type.isArray()) {
            ++i;
            type = type.getComponentType();
        }
        return i;
    }

    @Override
    public ClassElement toArray() {
        Class<?> arrayType = Array.newInstance((Class)this.type, 0).getClass();
        return ClassElement.of(arrayType);
    }

    @Override
    public ClassElement fromArray() {
        return new ReflectClassElement(((Class)this.type).getComponentType());
    }

    @Override
    @NonNull
    public List<? extends GenericPlaceholderElement> getDeclaredGenericPlaceholders() {
        return Arrays.stream(((Class)this.type).getTypeParameters()).map(tv -> new ReflectGenericPlaceholderElement((TypeVariable<?>)tv, 0)).collect(Collectors.toList());
    }
}

