/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class FullyQualifiedResourceId
implements Comparable<FullyQualifiedResourceId>,
Cloneable,
Serializable {
    private static final UUID LOWEST_UUID = new UUID(Long.MIN_VALUE, Long.MIN_VALUE);
    private static final UUID HIGHEST_UUID = new UUID(Long.MAX_VALUE, Long.MAX_VALUE);
    private static final long serialVersionUID = 0L;
    @Nullable
    private final UUID contextId;
    private final UUID resourceId;

    private static int compareNullable(@Nullable UUID contextId1, @Nullable UUID contextId2) {
        if (contextId1 == null && contextId2 == null) {
            return 0;
        }
        if (contextId1 == null) {
            return -1;
        }
        if (contextId2 == null) {
            return 1;
        }
        return contextId1.compareTo(contextId2);
    }

    public FullyQualifiedResourceId(@Nullable UUID contextId, UUID resourceId) {
        assert (resourceId != null);
        this.contextId = contextId;
        this.resourceId = resourceId;
    }

    public static FullyQualifiedResourceId lower(UUID contextId) {
        return new FullyQualifiedResourceId(contextId, LOWEST_UUID);
    }

    public static FullyQualifiedResourceId upper(UUID contextId) {
        return new FullyQualifiedResourceId(contextId, HIGHEST_UUID);
    }

    @Nullable
    public UUID contextId() {
        return this.contextId;
    }

    public UUID resourceId() {
        return this.resourceId;
    }

    @Override
    public int compareTo(FullyQualifiedResourceId o) {
        if (o == this) {
            return 0;
        }
        int res = FullyQualifiedResourceId.compareNullable(this.contextId, o.contextId());
        if (res == 0) {
            res = this.resourceId.compareTo(o.resourceId());
        }
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FullyQualifiedResourceId that = (FullyQualifiedResourceId)o;
        return Objects.equals(this.contextId, that.contextId) && Objects.equals(this.resourceId, that.resourceId);
    }

    public int hashCode() {
        return Objects.hash(this.contextId, this.resourceId);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        if (this.contextId == null) {
            return String.valueOf(this.resourceId);
        }
        return String.valueOf(this.contextId) + "/" + String.valueOf(this.resourceId);
    }
}

