/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.raft;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMvDataRequest;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMvDataRequestBuilder;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMvDataRequestSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class SnapshotMvDataRequestImpl
implements SnapshotMvDataRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 12;
    @IgniteToStringInclude
    private final long batchSizeHint;
    @IgniteToStringInclude
    private final UUID id;

    private SnapshotMvDataRequestImpl(long batchSizeHint, UUID id) {
        this.batchSizeHint = batchSizeHint;
        this.id = id;
    }

    @Override
    public long batchSizeHint() {
        return this.batchSizeHint;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    public MessageSerializer serializer() {
        return SnapshotMvDataRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(SnapshotMvDataRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 12;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SnapshotMvDataRequestImpl otherMessage = (SnapshotMvDataRequestImpl)other;
        return Objects.equals(this.id, otherMessage.id) && this.batchSizeHint == otherMessage.batchSizeHint;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.batchSizeHint, this.id);
        return result;
    }

    public SnapshotMvDataRequestImpl clone() {
        try {
            return (SnapshotMvDataRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SnapshotMvDataRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements SnapshotMvDataRequestBuilder {
        private long batchSizeHint;
        private UUID id;

        private Builder() {
        }

        @Override
        public SnapshotMvDataRequestBuilder batchSizeHint(long batchSizeHint) {
            this.batchSizeHint = batchSizeHint;
            return this;
        }

        @Override
        public SnapshotMvDataRequestBuilder id(UUID id) {
            Objects.requireNonNull(id, "id is not marked @Nullable");
            this.id = id;
            return this;
        }

        @Override
        public long batchSizeHint() {
            return this.batchSizeHint;
        }

        @Override
        public UUID id() {
            return this.id;
        }

        @Override
        public SnapshotMvDataRequest build() {
            return new SnapshotMvDataRequestImpl(this.batchSizeHint, Objects.requireNonNull(this.id, "id is not marked @Nullable"));
        }
    }
}

