/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.List;
import java.util.Objects;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.AbstractTableCommand;
import org.apache.ignite3.internal.catalog.commands.AlterTableAlterColumnCommandBuilder;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.DefaultValue;
import org.apache.ignite3.internal.catalog.commands.DeferredDefaultValue;
import org.apache.ignite3.internal.catalog.commands.TypeChangeValidationListener;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.storage.AlterColumnEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class AlterTableAlterColumnCommand
extends AbstractTableCommand {
    private static final TypeChangeValidationListener TYPE_CHANGE_VALIDATION_HANDLER = (pattern, originalType, newType) -> {
        throw new CatalogValidationException(pattern, new Object[]{originalType, newType});
    };
    private final String columnName;
    @Nullable
    private final ColumnType type;
    @Nullable
    private final Integer precision;
    @Nullable
    private final Integer length;
    @Nullable
    private final Integer scale;
    @Nullable
    private final Boolean nullable;
    @Nullable
    private final DeferredDefaultValue deferredDefault;

    public static AlterTableAlterColumnCommandBuilder builder() {
        return new Builder();
    }

    private AlterTableAlterColumnCommand(String tableName, String schemaName, boolean ifTableExists, String columnName, @Nullable ColumnType type, @Nullable Integer precision, @Nullable Integer length, @Nullable Integer scale, @Nullable Boolean nullable, @Nullable DeferredDefaultValue deferredDefault) {
        super(schemaName, tableName, ifTableExists, true);
        this.columnName = columnName;
        this.type = type;
        this.precision = precision;
        this.length = length;
        this.scale = scale;
        this.nullable = nullable;
        this.deferredDefault = deferredDefault;
        this.validate();
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, !this.ifTableExists);
        if (schema == null) {
            return List.of();
        }
        CatalogTableDescriptor table = CatalogUtils.table(schema, this.tableName, !this.ifTableExists);
        if (table == null) {
            return List.of();
        }
        CatalogTableColumnDescriptor origin = table.column(this.columnName);
        if (origin == null) {
            throw new CatalogValidationException("Column with name '{}' not found in table '{}.{}'.", this.columnName, this.schemaName, this.tableName);
        }
        if (table.isPrimaryKeyColumn(origin.name())) {
            this.validatePkColumnChange(origin);
        }
        this.validateColumnChange(origin);
        CatalogTableColumnDescriptor target = this.createNewTableColumn(origin);
        if (origin.equals(target)) {
            return List.of();
        }
        return List.of(new AlterColumnEntry(table.id(), target));
    }

    private void validate() {
        CatalogParamsValidationUtils.validateIdentifier(this.columnName, "Name of the column");
    }

    private CatalogTableColumnDescriptor createNewTableColumn(CatalogTableColumnDescriptor origin) {
        return new CatalogTableColumnDescriptor(origin.name(), Objects.requireNonNullElse(this.type, origin.type()), Objects.requireNonNullElse(this.nullable, origin.nullable()), Objects.requireNonNullElse(this.precision, origin.precision()), Objects.requireNonNullElse(this.scale, origin.scale()), Objects.requireNonNullElse(this.length, origin.length()), this.deferredDefault != null ? this.deferredDefault.derive(origin.type()) : origin.defaultValue());
    }

    private void validatePkColumnChange(CatalogTableColumnDescriptor origin) {
        if (this.type != null && this.type != origin.type()) {
            throw new CatalogValidationException("Changing the type of key column is not allowed.");
        }
        if (this.precision != null && this.precision.intValue() != origin.precision()) {
            throw new CatalogValidationException("Changing the precision of key column is not allowed.");
        }
        if (this.scale != null && this.scale.intValue() != origin.scale()) {
            throw new CatalogValidationException("Changing the scale of key column is not allowed.");
        }
        if (this.nullable != null && this.nullable.booleanValue()) {
            throw new CatalogValidationException("Dropping NOT NULL constraint on key column is not allowed.");
        }
    }

    private void validateColumnChange(CatalogTableColumnDescriptor origin) {
        DefaultValue defaultValue;
        CatalogUtils.validateColumnChange(origin, this.type, this.precision, this.scale, this.length, TYPE_CHANGE_VALIDATION_HANDLER);
        if (this.nullable != null && !this.nullable.booleanValue() && origin.nullable()) {
            throw new CatalogValidationException("Adding NOT NULL constraint is not allowed.");
        }
        if (this.deferredDefault != null && (defaultValue = this.deferredDefault.derive(origin.type())).type() != DefaultValue.Type.CONSTANT) {
            throw new CatalogValidationException("Non-constant default cannot be assigned after table creation.");
        }
    }

    private static class Builder
    implements AlterTableAlterColumnCommandBuilder {
        private String tableName;
        private String schemaName;
        private boolean ifTableExists;
        private String columnName;
        @Nullable
        private ColumnType type;
        @Nullable
        private Integer precision;
        @Nullable
        private Integer length;
        @Nullable
        private Integer scale;
        @Nullable
        private Boolean nullable;
        @Nullable
        private DeferredDefaultValue deferredDefault;

        private Builder() {
        }

        @Override
        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public AlterTableAlterColumnCommandBuilder ifTableExists(boolean ifTableExists) {
            this.ifTableExists = ifTableExists;
            return this;
        }

        @Override
        public Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        @Override
        public Builder type(ColumnType type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder precision(int precision) {
            this.precision = precision;
            return this;
        }

        @Override
        public Builder length(int length) {
            this.length = length;
            return this;
        }

        @Override
        public Builder scale(int scale) {
            this.scale = scale;
            return this;
        }

        @Override
        public Builder nullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        @Override
        public Builder deferredDefaultValue(DeferredDefaultValue deferredDefault) {
            this.deferredDefault = deferredDefault;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new AlterTableAlterColumnCommand(this.tableName, this.schemaName, this.ifTableExists, this.columnName, this.type, this.precision, this.length, this.scale, this.nullable, this.deferredDefault);
        }
    }
}

