/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.deployment.protocol.gg;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.deployment.GridDeploymentManager;
import org.apache.ignite.lang.IgniteUuid;

public class GridUrlConnection
extends URLConnection {
    private GridDeploymentManager mgr;
    private InputStream in;

    public GridUrlConnection(URL url, GridDeploymentManager mgr) {
        super(url);
        assert (mgr != null);
        this.mgr = mgr;
    }

    @Override
    public void connect() throws IOException {
        URL url = this.getURL();
        IgniteUuid ldrId = IgniteUuid.fromString(url.getHost());
        String name = url.getPath();
        GridDeployment dep = this.mgr.getDeployment(ldrId);
        if (dep != null) {
            this.in = dep.classLoader().getParent().getResourceAsStream(name);
            this.connected = true;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.in;
    }
}

