/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.security.thread;

import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.SecurityContext;

class SecurityAwareRunnable
implements Runnable {
    private final Runnable delegate;
    private final IgniteSecurity security;
    private final SecurityContext secCtx;

    private SecurityAwareRunnable(IgniteSecurity security, Runnable delegate) {
        assert (security.enabled());
        assert (delegate != null);
        this.delegate = delegate;
        this.security = security;
        this.secCtx = security.securityContext();
    }

    @Override
    public void run() {
        try (OperationSecurityContext ignored = this.security.withContext(this.secCtx);){
            this.delegate.run();
        }
    }

    static Runnable of(IgniteSecurity security, Runnable delegate) {
        if (delegate == null || security.isDefaultContext()) {
            return delegate;
        }
        return new SecurityAwareRunnable(security, delegate);
    }
}

