/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityKeyMapper;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.cache.CacheDefaultBinaryAffinityKeyMapper;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.platform.client.ClientAffinityTopologyVersion;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCachePartitionAwarenessGroup;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCachePartitionMapping;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCachePartitionsResponse;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class ClientCachePartitionsRequest
extends ClientRequest {
    private final int[] cacheIds;

    public ClientCachePartitionsRequest(BinaryRawReader reader) {
        super(reader);
        int len = reader.readInt();
        this.cacheIds = new int[len];
        for (int i = 0; i < len; ++i) {
            this.cacheIds[i] = reader.readInt();
        }
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        ArrayList<ClientCachePartitionAwarenessGroup> groups = new ArrayList<ClientCachePartitionAwarenessGroup>(this.cacheIds.length);
        HashMap<Integer, ClientCachePartitionAwarenessGroup> cacheGroupIds = new HashMap<Integer, ClientCachePartitionAwarenessGroup>(this.cacheIds.length);
        ClientAffinityTopologyVersion affinityVer = ctx.checkAffinityTopologyVersion();
        for (int cacheId : this.cacheIds) {
            ClientCachePartitionAwarenessGroup grp;
            DynamicCacheDescriptor cacheDesc = ctx.kernalContext().cache().cacheDescriptor(cacheId);
            if (cacheDesc == null || (grp = ClientCachePartitionsRequest.processCache(ctx, groups, cacheGroupIds, affinityVer, cacheDesc)) == null) continue;
            groups.add(grp);
            cacheGroupIds.put(cacheDesc.groupId(), grp);
        }
        Map<String, DynamicCacheDescriptor> allCaches = ctx.kernalContext().cache().cacheDescriptors();
        for (DynamicCacheDescriptor cacheDesc : allCaches.values()) {
            if (!cacheDesc.cacheType().userCache()) continue;
            ClientCachePartitionsRequest.processCache(ctx, groups, cacheGroupIds, affinityVer, cacheDesc);
        }
        return new ClientCachePartitionsResponse(this.requestId(), groups, affinityVer);
    }

    private static ClientCachePartitionAwarenessGroup processCache(ClientConnectionContext ctx, List<ClientCachePartitionAwarenessGroup> groups, Map<Integer, ClientCachePartitionAwarenessGroup> cacheGroupIds, ClientAffinityTopologyVersion affinityVer, DynamicCacheDescriptor cacheDesc) {
        int cacheGroupId = cacheDesc.groupId();
        int cacheId = cacheDesc.cacheId();
        ClientCachePartitionAwarenessGroup group = cacheGroupIds.get(cacheGroupId);
        if (group != null) {
            group.addCache(cacheDesc);
            return null;
        }
        AffinityAssignment assignment = ClientCachePartitionsRequest.getCacheAssignment(ctx, affinityVer, cacheId);
        if (assignment == null) {
            return null;
        }
        ClientCachePartitionMapping mapping = null;
        if (ClientCachePartitionsRequest.isApplicable(cacheDesc.cacheConfiguration())) {
            mapping = new ClientCachePartitionMapping(cacheId, assignment);
        }
        if ((group = ClientCachePartitionsRequest.getCompatibleGroup(groups, mapping)) != null) {
            group.addCache(cacheDesc);
            cacheGroupIds.put(cacheGroupId, group);
            return null;
        }
        CacheObjectBinaryProcessorImpl proc = (CacheObjectBinaryProcessorImpl)ctx.kernalContext().cacheObjects();
        return new ClientCachePartitionAwarenessGroup(proc, mapping, cacheDesc);
    }

    @Nullable
    private static ClientCachePartitionAwarenessGroup getCompatibleGroup(List<ClientCachePartitionAwarenessGroup> groups, ClientCachePartitionMapping mapping) {
        for (ClientCachePartitionAwarenessGroup group : groups) {
            if (!group.isCompatible(mapping)) continue;
            return group;
        }
        return null;
    }

    @Nullable
    private static AffinityAssignment getCacheAssignment(ClientConnectionContext ctx, ClientAffinityTopologyVersion affinityVer, int cacheId) {
        try {
            GridCacheContext cacheContext = ctx.kernalContext().cache().context().cacheContext(cacheId);
            return cacheContext.affinity().assignment(affinityVer.getVersion());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isApplicable(CacheConfiguration ccfg) {
        if (ccfg.getCacheMode() != CacheMode.PARTITIONED) {
            return false;
        }
        AffinityKeyMapper keyMapper = ccfg.getAffinityMapper();
        if (!(keyMapper instanceof CacheDefaultBinaryAffinityKeyMapper)) {
            return false;
        }
        if (!ccfg.getAffinity().getClass().equals(RendezvousAffinityFunction.class)) {
            return false;
        }
        IgnitePredicate<ClusterNode> filter = ccfg.getNodeFilter();
        boolean hasNodeFilter = filter != null && !(filter instanceof CacheConfiguration.IgniteAllNodesPredicate);
        return !hasNodeFilter;
    }
}

