/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.property;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.property.QueryPropertyAccessor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class QueryClassProperty
implements GridQueryProperty {
    private final QueryPropertyAccessor accessor;
    private final boolean key;
    private QueryClassProperty parent;
    private final String name;
    private final CacheObjectContext coCtx;
    private final boolean notNull;

    public QueryClassProperty(QueryPropertyAccessor accessor, boolean key, String name, boolean notNull, @Nullable CacheObjectContext coCtx) {
        this.accessor = accessor;
        this.key = key;
        this.name = !F.isEmpty(name) ? name : accessor.getPropertyName();
        this.notNull = notNull;
        this.coCtx = coCtx;
    }

    @Override
    public Object value(Object key, Object val) throws IgniteCheckedException {
        Object x = this.unwrap(this.key ? key : val);
        if (this.parent != null) {
            x = this.parent.value(key, val);
        }
        if (x == null) {
            return null;
        }
        return this.accessor.getValue(x);
    }

    @Override
    public void setValue(Object key, Object val, Object propVal) throws IgniteCheckedException {
        Object x = this.unwrap(this.key ? key : val);
        if (this.parent != null) {
            x = this.parent.value(key, val);
        }
        if (x == null) {
            return;
        }
        this.accessor.setValue(x, propVal);
    }

    @Override
    public boolean key() {
        return this.key;
    }

    private Object unwrap(Object o) {
        return this.coCtx == null ? o : (o instanceof CacheObject ? ((CacheObject)o).value(this.coCtx, false) : o);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Class<?> type() {
        return this.accessor.getType();
    }

    public void parent(QueryClassProperty parent) {
        this.parent = parent;
    }

    public String toString() {
        return S.toString(QueryClassProperty.class, this);
    }

    @Override
    public GridQueryProperty parent() {
        return this.parent;
    }

    @Override
    public boolean notNull() {
        return this.notNull;
    }

    @Override
    public Object defaultValue() {
        return null;
    }

    @Override
    public int precision() {
        return -1;
    }

    @Override
    public int scale() {
        return -1;
    }
}

